/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.animation;

import moe.plushie.armourers_workshop.core.client.animation.AnimationContext;
import moe.plushie.armourers_workshop.core.client.animation.AnimationController;
import moe.plushie.armourers_workshop.core.client.animation.AnimationPlayState;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.skin.molang.MolangVirtualMachine;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.SyntaxException;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.ExecutionContextImpl;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class AnimationEngine {
    private static final MolangVirtualMachine VM = new MolangVirtualMachine();

    public static void apply(@Nullable Object source, BakedSkin skin, SkinRenderContext context) {
        AnimationContext animationContext = context.getAnimationManager().getAnimationContext(skin);
        if (animationContext == null) {
            return;
        }
        VM.beginVariableCaching();
        AnimationEngine.apply(source, skin.getId(), context.getPartialTicks(), context.getAnimationTicks(), animationContext);
        VM.endVariableCaching();
    }

    public static void apply(@Nullable Object source, int skinId, float partialTick, double animationTime, AnimationContext context) {
        context.beginUpdates(animationTime);
        ExecutionContextImpl executionContext = context.getExecutionContext();
        for (AnimationController animationController : context.getAnimationControllers()) {
            AnimationPlayState playState = context.getPlayState(animationController);
            if (playState == null) continue;
            double adjustedTime = playState.getAdjustedTime(animationTime);
            if (animationController.isRequiresVirtualMachine()) {
                executionContext.upload(skinId, playState.getTime(), adjustedTime, animationTime, partialTick);
            }
            animationController.process(adjustedTime, playState, executionContext);
        }
        context.commitUpdates();
    }

    public static Expression compile(String source) throws SyntaxException {
        return VM.compile(source);
    }
}

