/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.animation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.core.client.animation.AnimatedPoint;
import moe.plushie.armourers_workshop.core.client.animation.AnimatedTransform;
import moe.plushie.armourers_workshop.core.client.animation.AnimationController;
import moe.plushie.armourers_workshop.core.client.animation.AnimationPlayState;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.ExecutionContextImpl;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import org.jetbrains.annotations.Nullable;

public class AnimationContext {
    private final List<Snapshot> snapshots = new ArrayList<Snapshot>();
    private final Map<AnimationController, AnimationPlayState> playStates = new HashMap<AnimationController, AnimationPlayState>();
    protected final ExecutionContextImpl executionContext;
    protected final List<AnimationController> animationControllers;

    public AnimationContext(ExecutionContextImpl executionContext, List<AnimationController> animationControllers) {
        this.executionContext = executionContext;
        this.animationControllers = animationControllers;
        LinkedHashSet animatedTransforms = new LinkedHashSet(Collections.flatMap(animationControllers, AnimationController::getAffectedTransforms));
        for (AnimatedTransform animatedTransform : animatedTransforms) {
            this.snapshots.add(new Snapshot(animatedTransform));
        }
    }

    public void beginUpdates(double animationTime) {
        for (Snapshot snapshot : this.snapshots) {
            snapshot.beginUpdates(animationTime);
        }
    }

    public void commitUpdates() {
        for (Snapshot snapshot : this.snapshots) {
            snapshot.commitUpdates();
        }
    }

    public void addAnimation(@Nullable AnimationController fromAnimationController, @Nullable AnimationController toAnimationController, double time, double speed, double duration) {
        ArrayList affectedTransforms = new ArrayList();
        affectedTransforms.addAll(Objects.flatMap(fromAnimationController, AnimationController::getAffectedTransforms, Collections.emptyList()));
        affectedTransforms.addAll(Objects.flatMap(toAnimationController, AnimationController::getAffectedTransforms, Collections.emptyList()));
        for (Snapshot snapshot : this.snapshots) {
            if (!affectedTransforms.contains(snapshot.transform)) continue;
            snapshot.addTransitingAnimation(time, speed, duration);
        }
    }

    protected void addPlayState(AnimationController animationController, AnimationPlayState playState) {
        this.playStates.put(animationController, playState);
    }

    @Nullable
    protected AnimationPlayState removePlayState(AnimationController animationController) {
        return this.playStates.remove(animationController);
    }

    @Nullable
    public AnimationPlayState getPlayState(AnimationController animationController) {
        return this.playStates.get(animationController);
    }

    public List<AnimationController> getAnimationControllers() {
        return this.animationControllers;
    }

    public ExecutionContextImpl getExecutionContext() {
        return this.executionContext;
    }

    private static class Snapshot {
        protected final AnimatedPoint currentValue = new AnimatedPoint();
        protected final AnimatedTransform transform;
        protected TransitingAnimation transitingAnimation;
        protected boolean isExported = false;

        public Snapshot(AnimatedTransform transform) {
            this.transform = transform;
        }

        public void beginUpdates(double animationTicks) {
            this.transform.snapshot = null;
            this.transform.clear();
            if (this.transitingAnimation != null) {
                this.transitingAnimation.update(animationTicks);
                if (this.transitingAnimation.isCompleted()) {
                    this.transitingAnimation = null;
                }
            }
        }

        public void commitUpdates() {
            if (this.transitingAnimation == null && this.transform.dirty == 0) {
                this.isExported = false;
                return;
            }
            this.isExported = true;
            this.transform.export(this.currentValue);
            this.transform.snapshot = this.currentValue;
            if (this.transitingAnimation != null) {
                this.transitingAnimation.apply(this.currentValue);
                this.transform.snapshot = this.transitingAnimation.getOutputValue();
            }
        }

        protected void addTransitingAnimation(double time, double speed, double duration) {
            this.transitingAnimation = new TransitingAnimation(time, duration);
            AnimatedPoint snapshotValue = this.transitingAnimation.getSnapshotValue();
            if (this.isExported) {
                snapshotValue.setTranslate(this.currentValue.getTranslate());
                snapshotValue.setRotation(this.currentValue.getRotation());
                snapshotValue.setScale(this.currentValue.getScale());
            } else {
                OpenTransform3f original = this.transform.getParent();
                snapshotValue.setTranslate(original.translate());
                snapshotValue.setRotation(original.rotation());
                snapshotValue.setScale(original.scale());
            }
        }

        public String toString() {
            return Objects.toString(this, new Object[0]);
        }
    }

    private static class TransitingAnimation {
        private final AnimatedPoint snapshotValue = new AnimatedPoint();
        private final AnimatedPoint outputValue = new AnimatedPoint();
        private final double beginTime;
        private final double endTime;
        private final double duration;
        private float progress;
        private boolean isCompleted;

        public TransitingAnimation(double time, double duration) {
            this.beginTime = time;
            this.endTime = time + duration;
            this.duration = duration;
        }

        public void update(double time) {
            this.progress = (float)OpenMath.clamp((time - this.beginTime) / this.duration, 0.0, 1.0);
            this.isCompleted = time > this.endTime;
        }

        public void apply(AnimatedPoint currentValue) {
            OpenVector3f lt = this.snapshotValue.getTranslate();
            OpenVector3f lr = this.snapshotValue.getRotation();
            OpenVector3f ls = this.snapshotValue.getScale();
            OpenVector3f rt = currentValue.getTranslate();
            OpenVector3f rr = currentValue.getRotation();
            OpenVector3f rs = currentValue.getScale();
            float tx = OpenMath.lerp(this.progress, lt.x(), rt.x());
            float ty = OpenMath.lerp(this.progress, lt.y(), rt.y());
            float tz = OpenMath.lerp(this.progress, lt.z(), rt.z());
            float sx = OpenMath.lerp(this.progress, ls.x(), rs.x());
            float sy = OpenMath.lerp(this.progress, ls.y(), rs.y());
            float sz = OpenMath.lerp(this.progress, ls.z(), rs.z());
            float rx = OpenMath.lerp(this.progress, lr.x(), rr.x());
            float ry = OpenMath.lerp(this.progress, lr.y(), rr.y());
            float rz = OpenMath.lerp(this.progress, lr.z(), rr.z());
            this.outputValue.clear();
            this.outputValue.setTranslate(tx, ty, tz);
            this.outputValue.setScale(sx, sy, sz);
            this.outputValue.setRotation(rx, ry, rz);
        }

        public AnimatedPoint getSnapshotValue() {
            return this.snapshotValue;
        }

        public AnimatedPoint getOutputValue() {
            return this.outputValue;
        }

        public float getProgress() {
            return this.progress;
        }

        public boolean isCompleted() {
            return this.isCompleted;
        }
    }
}

