/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.animation;

import moe.plushie.armourers_workshop.core.math.OpenVector3f;

public class AnimatedPoint {
    protected final OpenVector3f translate = new OpenVector3f();
    protected final OpenVector3f rotation = new OpenVector3f();
    protected final OpenVector3f scale = new OpenVector3f(1.0f, 1.0f, 1.0f);
    protected int dirty = 0;

    public void setTranslate(OpenVector3f value) {
        this.setTranslate(value.x(), value.y(), value.z());
    }

    public void setTranslate(float x, float y, float z) {
        if (x != 0.0f || y != 0.0f || z != 0.0f) {
            this.translate.set(x, y, z);
            this.setDirty(16);
        }
    }

    public OpenVector3f getTranslate() {
        if ((this.dirty & 0x10) != 0) {
            return this.translate;
        }
        return OpenVector3f.ZERO;
    }

    public void setRotation(OpenVector3f value) {
        this.setRotation(value.x(), value.y(), value.z());
    }

    public void setRotation(float x, float y, float z) {
        if (x != 0.0f || y != 0.0f || z != 0.0f) {
            this.rotation.set(x, y, z);
            this.setDirty(32);
        }
    }

    public OpenVector3f getRotation() {
        if ((this.dirty & 0x20) != 0) {
            return this.rotation;
        }
        return OpenVector3f.ZERO;
    }

    public void setScale(OpenVector3f value) {
        this.setScale(value.x(), value.y(), value.z());
    }

    public void setScale(float x, float y, float z) {
        if (x != 1.0f || y != 1.0f || z != 1.0f) {
            this.scale.set(x, y, z);
            this.setDirty(64);
        }
    }

    public OpenVector3f getScale() {
        if ((this.dirty & 0x40) != 0) {
            return this.scale;
        }
        return OpenVector3f.ONE;
    }

    public void clear() {
        this.dirty = 0;
    }

    public void setDirty(int newFlags) {
        this.dirty |= newFlags;
    }
}

