/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.capability;

import java.util.Map;
import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class SkinWardrobeJS {
    private static final Map<String, BiConsumer<SkinWardrobe, Boolean>> OPTIONS = Collections.immutableMap(builder -> {
        builder.put((Object)"render.head", (w, f) -> w.setRenderEquipment(EquipmentSlot.HEAD, (boolean)f));
        builder.put((Object)"render.chest", (w, f) -> w.setRenderEquipment(EquipmentSlot.CHEST, (boolean)f));
        builder.put((Object)"render.legs", (w, f) -> w.setRenderEquipment(EquipmentSlot.LEGS, (boolean)f));
        builder.put((Object)"render.feet", (w, f) -> w.setRenderEquipment(EquipmentSlot.FEET, (boolean)f));
        builder.put((Object)"render.extra", SkinWardrobe::setRenderExtra);
    });
    private final SkinWardrobe wardrobe;

    public SkinWardrobeJS(SkinWardrobe wardrobe) {
        this.wardrobe = wardrobe;
    }

    public SkinDescriptorJS loadSkin(String identifier) {
        Skin skin = SkinLoader.getInstance().loadSkin(identifier);
        if (skin != null) {
            return new SkinDescriptorJS(new SkinDescriptor(identifier, skin.getType(), SkinPaintScheme.EMPTY));
        }
        return null;
    }

    public SkinDescriptorJS loadSkinFromDB(String identifier) {
        SkinDescriptor descriptor = SkinLoader.getInstance().loadSkinFromDB(identifier, SkinPaintScheme.EMPTY, true);
        if (!descriptor.isEmpty()) {
            return new SkinDescriptorJS(descriptor);
        }
        return null;
    }

    public SkinDescriptorJS loadSkinByItem(ItemStack itemStack) {
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (!descriptor.isEmpty()) {
            return new SkinDescriptorJS(descriptor);
        }
        return null;
    }

    public void setItem(String slotType, int slot, ItemStack itemStack) {
        this.wardrobe.setItem(SkinSlotType.byName(slotType), slot, itemStack);
    }

    public ItemStack getItem(String slotType, int slot) {
        return this.wardrobe.getItem(SkinSlotType.byName(slotType), slot);
    }

    public void clear() {
        this.wardrobe.clear();
    }

    public void setUnlockedSize(String slotType, int size) {
        this.wardrobe.setUnlockedSize(SkinSlotType.byName(slotType), size);
    }

    public int getUnlockedSize(String slotType) {
        return this.wardrobe.getUnlockedSize(SkinSlotType.byName(slotType));
    }

    public int getMaximumSize(String slotType) {
        return this.wardrobe.getMaximumSize(SkinSlotType.byName(slotType));
    }

    public int getFreeSize(String slotType) {
        return this.wardrobe.getFreeSlot(SkinSlotType.byName(slotType));
    }

    public void disable(String opt) {
        this.setOptions(opt, false);
    }

    public void enable(String opt) {
        this.setOptions(opt, true);
    }

    public void broadcast() {
        this.wardrobe.broadcast();
    }

    public boolean isValid() {
        return this.wardrobe != null;
    }

    public boolean isEditable(Player player) {
        return this.wardrobe != null && this.wardrobe.isEditable(player);
    }

    private void setOptions(String opt, boolean flag) {
        BiConsumer<SkinWardrobe, Boolean> o = OPTIONS.get(opt);
        if (o != null) {
            o.accept(this.wardrobe, flag);
        }
    }

    public static class SkinDescriptorJS {
        private final SkinDescriptor descriptor;

        public SkinDescriptorJS(SkinDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public void addTo(ItemStack itemStack) {
            ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.SKIN.get(), this.descriptor);
        }

        public void removeFrom(ItemStack itemStack) {
            ComponentAPI.remove(itemStack, (IDataComponentType)ModDataComponents.SKIN.get());
        }

        public String getIdentifier() {
            return this.descriptor.getIdentifier();
        }

        public String getType() {
            return this.descriptor.getType().getRegistryName().getPath();
        }

        public ItemStack asItemStack() {
            return this.descriptor.asItemStack();
        }
    }
}

