/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.capability;

import java.lang.ref.WeakReference;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IMenuType;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobeStorage;
import moe.plushie.armourers_workshop.core.data.EntityCollisionContainer;
import moe.plushie.armourers_workshop.core.data.EntityCollisionShape;
import moe.plushie.armourers_workshop.core.data.EntityDataStorage;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.network.UpdateWardrobePacket;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModEntityProfiles;
import moe.plushie.armourers_workshop.init.ModMenuTypes;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SkinWardrobe
implements IDataSerializable.Mutable {
    private final BitSet flags = new BitSet(6);
    private final HashMap<SkinSlotType, Integer> skinSlots = new HashMap();
    private final SimpleContainer inventory = new SimpleContainer(SkinSlotType.getTotalSize());
    private final EntityCollisionContainer collision;
    private final WeakReference<Entity> entity;
    private int id;
    private EntityProfile profile;

    public SkinWardrobe(Entity entity, EntityProfile profile) {
        this.id = entity.m_19879_();
        this.entity = new WeakReference<Entity>(entity);
        this.collision = new EntityCollisionContainer(this.inventory, entity);
        this.profile = profile;
    }

    @Nullable
    public static SkinWardrobe of(@Nullable Entity entity) {
        if (entity != null) {
            return EntityDataStorage.of(entity).getWardrobe().orElse(null);
        }
        return null;
    }

    public static Optional<SkinWardrobe> create(Entity entity) {
        EntityProfile profile = ModEntityProfiles.getProfile(entity);
        if (profile != null) {
            return Optional.of(new SkinWardrobe(entity, profile));
        }
        return Optional.empty();
    }

    @Override
    public void serialize(IDataSerializer serializer) {
        SkinWardrobeStorage.saveSkinSlots(this.skinSlots, serializer);
        SkinWardrobeStorage.saveFlags(this.flags, serializer);
        SkinWardrobeStorage.saveInventoryItems((Container)this.inventory, serializer);
        SkinWardrobeStorage.saveBoundingBox(this.collision, serializer);
        SkinWardrobeStorage.saveDataFixer(this, serializer);
    }

    @Override
    public void deserialize(IDataSerializer serializer) {
        this.collision.beginUpdates();
        SkinWardrobeStorage.loadSkinSlots(this.skinSlots, serializer);
        SkinWardrobeStorage.loadFlags(this.flags, serializer);
        SkinWardrobeStorage.loadInventoryItems((Container)this.inventory, serializer);
        SkinWardrobeStorage.loadBoundingBox(this.collision, this, serializer);
        SkinWardrobeStorage.loadDataFixer(this, serializer);
        this.collision.endUpdates();
    }

    public void setProfile(EntityProfile profile) {
        this.profile = profile;
    }

    public EntityProfile getProfile() {
        return this.profile;
    }

    public int getFreeSlot(SkinSlotType slotType) {
        int unlockedSize = this.getUnlockedSize(slotType);
        for (int i = 0; i < unlockedSize; ++i) {
            if (!this.inventory.m_8020_(slotType.getIndex() + i).m_41619_()) continue;
            return i;
        }
        return unlockedSize - 1;
    }

    public ItemStack getItem(SkinSlotType slotType, int slot) {
        if (slot < 0 || slot >= this.getUnlockedSize(slotType)) {
            return ItemStack.f_41583_;
        }
        return this.inventory.m_8020_(slotType.getIndex() + slot);
    }

    public void setItem(SkinSlotType slotType, int slot, ItemStack itemStack) {
        if (slot < 0 || slot >= this.getUnlockedSize(slotType)) {
            return;
        }
        this.inventory.m_6836_(slotType.getIndex() + slot, itemStack);
    }

    public void dropAll(@Nullable Consumer<ItemStack> consumer) {
        int containerSize = this.inventory.m_6643_();
        int ignoredStart = SkinSlotType.DYE.getIndex() + 8;
        int ignoredEnd = SkinSlotType.DYE.getIndex() + SkinSlotType.DYE.getMaxSize();
        for (int i = 0; i < containerSize; ++i) {
            ItemStack itemStack;
            if (i >= ignoredStart && i < ignoredEnd || (itemStack = this.inventory.m_8020_(i)).m_41619_()) continue;
            if (consumer != null) {
                consumer.accept(itemStack);
            }
            this.inventory.m_6836_(i, ItemStack.f_41583_);
        }
    }

    public void clear() {
        this.inventory.m_6211_();
    }

    public void sendToServer() {
        NetworkManager.sendToServer(UpdateWardrobePacket.sync(this));
    }

    public void broadcast() {
        NetworkManager.sendToTracking(UpdateWardrobePacket.sync(this), this.getEntity());
    }

    public void broadcast(ServerPlayer player) {
        NetworkManager.sendTo(UpdateWardrobePacket.sync(this), player);
    }

    public void setCollisionShape(EntityCollisionShape shape) {
        this.collision.setResult(shape);
    }

    public EntityCollisionShape getCollisionShape() {
        return this.collision.getResult();
    }

    public boolean shouldRenderEquipment(EquipmentSlot slotType) {
        return !this.flags.get(slotType.m_20750_());
    }

    public void setRenderEquipment(EquipmentSlot slotType, boolean enable) {
        if (enable) {
            this.flags.clear(slotType.m_20750_());
        } else {
            this.flags.set(slotType.m_20750_());
        }
    }

    public boolean shouldRenderExtra() {
        return !this.flags.get(6);
    }

    public void setRenderExtra(boolean value) {
        if (value) {
            this.flags.clear(6);
        } else {
            this.flags.set(6);
        }
    }

    public BitSet getFlags() {
        return this.flags;
    }

    public void setUnlockedSize(SkinSlotType slotType, int size) {
        if (slotType != SkinSlotType.DYE) {
            this.skinSlots.put(slotType, size);
        }
    }

    public int getUnlockedSize(SkinSlotType slotType) {
        if (slotType == SkinSlotType.DYE) {
            return 8;
        }
        Integer modifiedSize = this.skinSlots.get((Object)slotType);
        if (modifiedSize != null) {
            return Math.min(slotType.getMaxSize(), modifiedSize);
        }
        return Math.min(slotType.getMaxSize(), this.profile.getMaxCount(slotType));
    }

    public int getMaximumSize(SkinSlotType slotType) {
        if (slotType == SkinSlotType.DYE) {
            return 8;
        }
        return slotType.getMaxSize();
    }

    public Container getInventory() {
        return this.inventory;
    }

    @Nullable
    public Entity getEntity() {
        return (Entity)this.entity.get();
    }

    public int getId() {
        Entity entity = this.getEntity();
        if (entity != null) {
            this.id = entity.m_19879_();
        }
        return this.id;
    }

    public boolean isEditable(Player player) {
        if (!ModPermissions.OPEN.accept((IMenuType)ModMenuTypes.WARDROBE.get(), this.getEntity(), player)) {
            return false;
        }
        Entity entity = this.getEntity();
        if (entity instanceof Player && entity.m_19879_() != player.m_19879_()) {
            return false;
        }
        if (!ModConfig.Common.canOpenWardrobe(entity, player)) {
            return false;
        }
        return !this.getProfile().isLocked();
    }

    public boolean isSupported(SkinSlotType slotType) {
        return this.profile.isSupported(slotType);
    }
}

