/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.armature.thirdparty;

import moe.plushie.armourers_workshop.api.armature.IJoint;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.core.armature.JointModifier;
import moe.plushie.armourers_workshop.core.armature.thirdparty.EpicFlightTransformProvider;
import moe.plushie.armourers_workshop.core.math.OpenPoseStack;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IODataObject;

public class EpicFightJointBinder
extends JointModifier {
    private final String name;

    public EpicFightJointBinder(String name, IODataObject parameters) {
        this.name = name;
    }

    @Override
    public IJointTransform apply(IJoint joint, IModel model, IJointTransform transform) {
        if (this.name.equals("Root")) {
            return transform;
        }
        return poseStack -> {
            OpenPoseStack.Pose jointPose = model.getAssociatedObject(EpicFlightTransformProvider.KEY).getJointPose(this.name);
            float f1 = 16.0f;
            float f2 = 0.0625f;
            poseStack.scale(f1, f1, f1);
            poseStack.multiply(jointPose.pose());
            poseStack.multiply(jointPose.normal());
            poseStack.scale(f2, f2, f2);
            transform.apply(poseStack);
        };
    }
}

