/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.armature;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.IEntityTypeProvider;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.core.armature.ArmaturePlugin;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformerContext;
import moe.plushie.armourers_workshop.core.armature.JointModifier;
import moe.plushie.armourers_workshop.core.armature.JointShape;
import moe.plushie.armourers_workshop.core.math.OpenRectangle2f;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector2f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IODataObject;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureBox;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureData;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTexturePos;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;

public class ArmatureSerializers {
    private static final HashMap<IResourceLocation, Class<?>> NAMED_CLASSES = new HashMap();
    private static final HashMap<String, Supplier<? extends JointModifier>> NAMED_MODIFIERS = new HashMap();
    private static final HashMap<String, Function<ArmatureTransformerContext, ? extends ArmaturePlugin>> NAMED_PLUGINS = new HashMap();

    public static OpenVector3f readVector(IODataObject object, OpenVector3f defaultValue) {
        switch (object.type()) {
            case ARRAY: {
                if (object.size() != 3) break;
                float f1 = object.at(0).floatValue();
                float f2 = object.at(1).floatValue();
                float f3 = object.at(2).floatValue();
                return new OpenVector3f(f1, f2, f3);
            }
            case DICTIONARY: {
                float f1 = object.get("x").floatValue();
                float f2 = object.get("y").floatValue();
                float f3 = object.get("z").floatValue();
                return new OpenVector3f(f1, f2, f3);
            }
        }
        return defaultValue;
    }

    public static OpenTransform3f readTransform(IODataObject object) {
        if (object.isNull()) {
            return OpenTransform3f.IDENTITY;
        }
        OpenVector3f translate = ArmatureSerializers.readVector(object.get("translate"), OpenVector3f.ZERO);
        OpenVector3f scale = ArmatureSerializers.readVector(object.get("scale"), OpenVector3f.ONE);
        OpenVector3f rotation = ArmatureSerializers.readVector(object.get("rotation"), OpenVector3f.ZERO);
        OpenVector3f pivot = ArmatureSerializers.readVector(object.get("pivot"), OpenVector3f.ZERO);
        OpenVector3f afterTranslate = ArmatureSerializers.readVector(object.get("afterTranslate"), OpenVector3f.ZERO);
        return OpenTransform3f.create(translate, rotation, scale, pivot, afterTranslate);
    }

    public static JointShape readShape(IODataObject object) {
        if (object.isNull()) {
            return null;
        }
        OpenVector3f origin = ArmatureSerializers.readVector(object.get("origin"), OpenVector3f.ZERO);
        OpenVector3f size = ArmatureSerializers.readVector(object.get("size"), OpenVector3f.ZERO);
        float inflate = object.get("inflate").floatValue();
        OpenTransform3f transform = ArmatureSerializers.readTransform(object);
        Map<OpenDirection, OpenRectangle2f> textureBox = ArmatureSerializers.readShapeTextureUVs(object.get("uv"), size);
        ArrayList<JointShape> children = new ArrayList<JointShape>();
        object.get("children").allValues().forEach(it -> children.add(ArmatureSerializers.readShape(it)));
        return new JointShape(origin, size, inflate, transform, textureBox, children);
    }

    public static Map<OpenDirection, OpenRectangle2f> readShapeTextureUVs(IODataObject object, OpenVector3f size) {
        switch (object.type()) {
            case ARRAY: {
                if (object.size() < 2) break;
                float u = object.at(0).floatValue();
                float v = object.at(1).floatValue();
                boolean mirror = false;
                if (u < 0.0f) {
                    u = -u;
                    mirror = true;
                }
                SkinTextureData textureData = new SkinTextureData("", 255.0f, 255.0f);
                SkinTextureBox textureBox = new SkinTextureBox(size.x(), size.y(), size.z(), mirror, new OpenVector2f(u, v), textureData);
                EnumMap<OpenDirection, OpenRectangle2f> uvs = new EnumMap<OpenDirection, OpenRectangle2f>(OpenDirection.class);
                for (OpenDirection dir : OpenDirection.values()) {
                    SkinTexturePos key = textureBox.getTexture(dir);
                    if (key == null) continue;
                    uvs.put(dir, new OpenRectangle2f(key.getU(), key.getV(), key.getWidth(), key.getHeight()));
                }
                return uvs;
            }
            case DICTIONARY: {
                SkinTextureData textureData = new SkinTextureData("", 255.0f, 255.0f);
                SkinTextureBox textureBox = new SkinTextureBox(size.x(), size.y(), size.z(), false, null, textureData);
                for (OpenDirection dir : OpenDirection.values()) {
                    IODataObject ob = object.get(dir.getName());
                    if (ob.size() < 4) continue;
                    float u = ob.at(0).floatValue();
                    float v = ob.at(1).floatValue();
                    float n = ob.at(2).floatValue();
                    float m = ob.at(3).floatValue();
                    textureBox.putTextureRect(dir, new OpenRectangle2f(u, v, n - u, m - v));
                }
                EnumMap<OpenDirection, OpenRectangle2f> uvs = new EnumMap<OpenDirection, OpenRectangle2f>(OpenDirection.class);
                for (OpenDirection dir : OpenDirection.values()) {
                    SkinTexturePos key = textureBox.getTexture(dir);
                    if (key == null) continue;
                    uvs.put(dir, new OpenRectangle2f(key.getU(), key.getV(), key.getWidth(), key.getHeight()));
                }
                return uvs;
            }
        }
        return null;
    }

    public static IEntityTypeProvider<?> readEntityType(IODataObject object) {
        return IEntityTypeProvider.of(object.stringValue());
    }

    public static IResourceLocation readResourceLocation(IODataObject object) {
        return OpenResourceLocation.parse(object.stringValue());
    }

    public static <T> void registerClass(String registryName, Class<T> clazz) {
        NAMED_CLASSES.put(OpenResourceLocation.parse(registryName), clazz);
    }

    public static <T> Class<?> getClass(IResourceLocation registryName) {
        return NAMED_CLASSES.get(registryName);
    }

    public static void registerPlugin(String registryName, Supplier<? extends ArmaturePlugin> provider) {
        ArmatureSerializers.registerPlugin(registryName, (ArmatureTransformerContext context) -> (ArmaturePlugin)provider.get());
    }

    public static void registerPlugin(String registryName, Function<ArmatureTransformerContext, ? extends ArmaturePlugin> provider) {
        NAMED_PLUGINS.put(registryName, provider);
    }

    public static Function<ArmatureTransformerContext, ? extends ArmaturePlugin> getPlugin(String registryName) {
        return NAMED_PLUGINS.get(registryName);
    }

    public static void registerModifier(String registryName, Supplier<? extends JointModifier> provider) {
        NAMED_MODIFIERS.put(registryName, provider);
    }

    public static Supplier<? extends JointModifier> getModifier(String registryName) {
        return NAMED_MODIFIERS.get(registryName);
    }
}

