/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.mixin;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import moe.plushie.armourers_workshop.compatibility.client.AbstractSimpleSound;
import moe.plushie.armourers_workshop.compatibility.client.AbstractSoundManagerImpl;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.resources.sounds.Sound.Constructor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.client.sounds.Weighted;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SoundManager.class})
public class SoundManagerMixin
implements AbstractSoundManagerImpl {
    @Unique
    private final Map<ResourceLocation, WeighedSoundEvents> aw2$registry = Maps.newHashMap();

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/packs/resources/ResourceProvider;fromMap(Ljava/util/Map;)Lnet/minecraft/server/packs/resources/ResourceProvider;"))
    private ResourceProvider aw2$init(Map<ResourceLocation, Resource> map) {
        return location -> {
            Resource resource = (Resource)map.get(location);
            if (resource != null) {
                return Optional.of(resource);
            }
            return Minecraft.m_91087_().m_91098_().m_213713_(location);
        };
    }

    @Inject(method={"getSoundEvent"}, at={@At(value="HEAD")}, cancellable=true)
    private void aw2$getSoundEvent(ResourceLocation location, CallbackInfoReturnable<WeighedSoundEvents> cir) {
        WeighedSoundEvents event = this.aw2$registry.get(location);
        if (event != null) {
            cir.setReturnValue((Object)event);
        }
    }

    @Override
    public void aw2$register(ResourceLocation location, AbstractSimpleSound sound) {
        WeighedSoundEvents event = new WeighedSoundEvents(location, sound.getName());
        event.m_120451_((Weighted)Constructor.create(Sound.class, sound));
        this.aw2$registry.put(location, event);
    }

    @Override
    public void aw2$unregister(ResourceLocation location) {
        this.aw2$registry.remove(location);
    }
}

