/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import io.netty.buffer.ByteBuf;
import moe.plushie.armourers_workshop.api.common.IMenuProvider;
import moe.plushie.armourers_workshop.api.common.IMenuSerializer;
import moe.plushie.armourers_workshop.compatibility.core.AbstractMenuType;
import moe.plushie.armourers_workshop.compatibility.core.data.AbstractFriendlyByteBuf;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class AbstractForgeMenuType<C extends AbstractContainerMenu>
extends AbstractMenuType<C> {
    private final MenuType<C> type = IForgeMenuType.create(this::createMenu);
    private final IMenuProvider<C, Object> factory;
    private final IMenuSerializer<Object> serializer;

    public <T> AbstractForgeMenuType(IMenuProvider<C, T> factory, IMenuSerializer<T> serializer) {
        this.factory = (IMenuProvider)Objects.unsafeCast(factory);
        this.serializer = (IMenuSerializer)Objects.unsafeCast(serializer);
    }

    public static <C extends AbstractContainerMenu, T> AbstractForgeMenuType<C> create(IMenuProvider<C, T> factory, IMenuSerializer<T> serializer) {
        return new AbstractForgeMenuType<C>(factory, serializer);
    }

    protected C createMenu(int containerId, Inventory inventory, FriendlyByteBuf buf) {
        Object value = this.serializer.read(AbstractFriendlyByteBuf.wrap((ByteBuf)buf), inventory.f_35978_);
        return (C)((AbstractContainerMenu)this.factory.createMenu(this.type, containerId, inventory, value));
    }

    @Override
    protected <T> InteractionResult openMenu(ServerPlayer player, final Component title, final T value) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new MenuProvider(){

            @Nullable
            public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
                return (AbstractContainerMenu)AbstractForgeMenuType.this.factory.createMenu(AbstractForgeMenuType.this.type, containerId, inventory, value);
            }

            public Component m_5446_() {
                return title;
            }
        }, buf -> this.serializer.write(AbstractFriendlyByteBuf.wrap((ByteBuf)buf), (Player)player, value));
        return InteractionResult.SUCCESS;
    }

    public MenuType<C> getType() {
        return this.type;
    }
}

