/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Map;
import moe.plushie.armourers_workshop.api.client.key.IKeyModifier;
import moe.plushie.armourers_workshop.api.event.EventBus;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.init.event.client.RegisterKeyMappingsEvent;
import moe.plushie.armourers_workshop.utils.OpenKeyModifier;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;

public abstract class AbstractForgeKeyMapping
extends KeyMapping {
    private static final Map<IKeyModifier, KeyModifier> MODIFIERS1 = Collections.immutableMap(builder -> {
        builder.put((Object)OpenKeyModifier.CONTROL, (Object)KeyModifier.CONTROL);
        builder.put((Object)OpenKeyModifier.SHIFT, (Object)KeyModifier.SHIFT);
        builder.put((Object)OpenKeyModifier.ALT, (Object)KeyModifier.ALT);
        builder.put((Object)OpenKeyModifier.NONE, (Object)KeyModifier.NONE);
    });
    private static final Map<KeyModifier, IKeyModifier> MODIFIERS2 = Collections.immutableMap(builder -> {
        builder.put((Object)KeyModifier.CONTROL, (Object)OpenKeyModifier.CONTROL);
        builder.put((Object)KeyModifier.SHIFT, (Object)OpenKeyModifier.SHIFT);
        builder.put((Object)KeyModifier.ALT, (Object)OpenKeyModifier.ALT);
        builder.put((Object)KeyModifier.NONE, (Object)OpenKeyModifier.NONE);
    });

    public AbstractForgeKeyMapping(String description, IKeyModifier keyModifier, InputConstants.Key keyCode, String category) {
        super(description, (IKeyConflictContext)KeyConflictContext.IN_GAME, MODIFIERS1.getOrDefault(keyModifier, KeyModifier.NONE), keyCode, category);
    }

    public static void register(String name, KeyMapping keyMapping) {
        EventBus.register(RegisterKeyMappingsEvent.class, (E event) -> event.register(keyMapping));
    }

    public IKeyModifier getOpenKeyModifier() {
        return MODIFIERS2.getOrDefault(this.getKeyModifier(), OpenKeyModifier.NONE);
    }
}

