/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import java.lang.ref.WeakReference;
import java.util.IdentityHashMap;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.IBlockEntityCapability;
import moe.plushie.armourers_workshop.api.common.IEntityCapability;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IRegistryHolder;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobeStorage;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class AbstractForgeCapabilityManagerImpl {
    private static final IdentityHashMap<Capability<?>, IBlockEntityCapability<?>> REGISTERED_CAPABILITIES = new IdentityHashMap();

    public static <T> IBlockEntityCapability<T> wrap(Capability<T> capability) {
        IBlockEntityCapability result = REGISTERED_CAPABILITIES.computeIfAbsent(capability, CapabilityWrapper::new);
        return (IBlockEntityCapability)Objects.unsafeCast(result);
    }

    public static <T> Capability<T> unwrap(IBlockEntityCapability<T> capability) {
        if (capability instanceof CapabilityWrapper) {
            CapabilityWrapper impl = (CapabilityWrapper)capability;
            return impl.capability;
        }
        return null;
    }

    protected static class CapabilityWrapper<T>
    implements IBlockEntityCapability<T> {
        private final Capability<T> capability;

        protected CapabilityWrapper(Capability<T> capability) {
            this.capability = capability;
        }

        @Override
        public T get(Level level, BlockPos blockPos, @Nullable BlockState blockState, @Nullable BlockEntity blockEntity, Direction dir) {
            if (blockEntity != null) {
                return blockEntity.getCapability(this.capability, dir).resolve().orElse(null);
            }
            blockEntity = level.m_7702_(blockPos);
            if (blockEntity != null) {
                return blockEntity.getCapability(this.capability, dir).resolve().orElse(null);
            }
            return null;
        }
    }

    protected static abstract class CapabilityProxy<T extends IDataSerializable.Mutable>
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        protected final T value;
        protected final WeakReference<Entity> entity;

        protected CapabilityProxy(Entity entity, T value) {
            this.value = value;
            this.entity = new WeakReference<Entity>(entity);
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            this.value.serialize(SkinWardrobeStorage.encoder((Entity)this.entity.get(), tag));
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            this.value.deserialize(SkinWardrobeStorage.decoder((Entity)this.entity.get(), tag));
        }

        public <I> LazyOptional<I> getCapability(Capability<I> cap, @Nullable Direction arg) {
            return this.getCapability().orEmpty(cap, LazyOptional.of(() -> this.value));
        }

        public abstract Capability<T> getCapability();
    }

    protected static class HolderProxy<T extends IDataSerializable.Mutable>
    implements IRegistryHolder<IEntityCapability<T>> {
        protected final IResourceLocation registryName;
        protected final Supplier<Capability<T>> capability;
        protected final Class<T> type;
        protected final IEntityCapability<T> capabilityType;
        protected final Function<Entity, Optional<T>> factory;

        protected HolderProxy(IResourceLocation registryName, Class<T> type, Function<Entity, Optional<T>> factory, IEntityCapability<T> capabilityType, Supplier<Capability<T>> capability) {
            this.type = type;
            this.factory = factory;
            this.capability = capability;
            this.capabilityType = capabilityType;
            this.registryName = registryName;
        }

        public CapabilityProxy<T> attach(Entity entity) {
            return this.factory.apply(entity).map(t -> new CapabilityProxy<T>(entity, (IDataSerializable.Mutable)t){

                @Override
                public Capability<T> getCapability() {
                    return capability.get();
                }
            }).orElse(null);
        }

        @Override
        public IEntityCapability<T> get() {
            return this.capabilityType;
        }

        @Override
        public IResourceLocation getRegistryName() {
            return this.registryName;
        }
    }
}

