/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.init.command.EntitySelectorPredicate;
import moe.plushie.armourers_workshop.init.command.HasSkinArgumentType;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.network.chat.Component;

public abstract class AbstractEntitySelectorParser {
    private static boolean IS_INITIALED = false;
    private final String name;
    private final Component description;

    protected AbstractEntitySelectorParser(String name, Component description) {
        this.name = name;
        this.description = description;
    }

    public static void register(Consumer<AbstractEntitySelectorParser> consumer) {
        if (!IS_INITIALED) {
            consumer.accept(new HasSkinParser());
            IS_INITIALED = true;
        }
    }

    public abstract void parse(EntitySelectorParser var1) throws CommandSyntaxException;

    public boolean canUse(EntitySelectorParser parser) {
        return true;
    }

    public String getName() {
        return this.name;
    }

    public Component getDescription() {
        return this.description;
    }

    private static class HasSkinParser
    extends AbstractEntitySelectorParser {
        protected HasSkinParser() {
            super("skin", (Component)Component.m_237113_((String)"commands.armourers_workshop.hasskin.description"));
        }

        @Override
        public void parse(EntitySelectorParser parser) throws CommandSyntaxException {
            boolean bl = parser.m_121330_();
            HasSkinArgumentType type = new HasSkinArgumentType();
            EntitySelectorPredicate predicate = type.parse(parser.m_121346_());
            parser.m_121272_(entity -> predicate.test(entity) != bl);
        }
    }
}

