/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import moe.plushie.armourers_workshop.api.common.IPaintable;
import moe.plushie.armourers_workshop.api.core.math.IVector3i;
import moe.plushie.armourers_workshop.api.skin.geometry.ISkinGeometryType;
import moe.plushie.armourers_workshop.api.skin.texture.ISkinPaintColor;
import moe.plushie.armourers_workshop.builder.block.SkinCubeBlock;
import moe.plushie.armourers_workshop.builder.other.CubeChangesCollector;
import moe.plushie.armourers_workshop.builder.other.CubeReplacingEvent;
import moe.plushie.armourers_workshop.builder.other.CubeTransform;
import moe.plushie.armourers_workshop.builder.other.CubeWrapper;
import moe.plushie.armourers_workshop.compatibility.core.AbstractDirection;
import moe.plushie.armourers_workshop.core.data.OptionalDirection;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3i;
import moe.plushie.armourers_workshop.core.math.OpenVector2i;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometrySet;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryTypes;
import moe.plushie.armourers_workshop.core.skin.geometry.collection.SkinGeometrySetV1;
import moe.plushie.armourers_workshop.core.skin.geometry.cube.SkinCube;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.serializer.exception.SkinSaveException;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureModel;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintData;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import moe.plushie.armourers_workshop.init.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public final class WorldUtils {
    public static Skin saveSkinFromWorld(Level level, CubeTransform transform, SkinProperties skinProps, SkinType skinType, SkinPaintData paintData) throws SkinSaveException {
        SkinPart testPart;
        ArrayList<SkinPart> parts = new ArrayList<SkinPart>();
        if (skinType == SkinTypes.BLOCK) {
            SkinPart skinPart;
            Object partType = SkinPartTypes.BLOCK;
            if (skinProps.get(SkinProperty.BLOCK_MULTIBLOCK).booleanValue()) {
                partType = SkinPartTypes.BLOCK_MULTI;
            }
            if ((skinPart = WorldUtils.saveArmourPart(level, transform, (SkinPartType)partType, true)) != null) {
                parts.add(skinPart);
            }
        } else {
            for (SkinPartType skinPartType : skinType.getParts()) {
                SkinPart skinPart = WorldUtils.saveArmourPart(level, transform, skinPartType, true);
                if (skinPart == null) continue;
                parts.add(skinPart);
            }
        }
        if (paintData != null) {
            SkinPaintData resolvedPaintData = SkinPaintData.v1();
            resolvedPaintData.copyFrom(paintData);
            paintData = resolvedPaintData;
        }
        Skin.Builder builder = new Skin.Builder(skinType);
        builder.properties(skinProps);
        builder.paintData(paintData);
        builder.parts(parts);
        Skin skin = builder.build();
        if (skin.getParts().isEmpty() && skin.getPaintData() == null) {
            throw SkinSaveException.Type.NO_DATA.build("noting", new Object[0]);
        }
        for (SkinPartType skinPartType : skinType.getParts()) {
            if (!skinPartType.isPartRequired()) continue;
            boolean havePart = false;
            for (SkinPart part : skin.getParts()) {
                if (skinPartType != part.getType()) continue;
                havePart = true;
                break;
            }
            if (havePart) continue;
            throw SkinSaveException.Type.MISSING_PARTS.build("missingPart", TranslateUtils.Name.of(skinPartType));
        }
        if (skinProps.get(SkinProperty.BLOCK_BED).booleanValue() && skinProps.get(SkinProperty.BLOCK_SEAT).booleanValue()) {
            throw SkinSaveException.Type.BED_AND_SEAT.build("conflictBedSeat", new Object[0]);
        }
        if (skinType == SkinTypes.BLOCK && skinProps.get(SkinProperty.BLOCK_MULTIBLOCK).booleanValue() && (testPart = WorldUtils.saveArmourPart(level, transform, SkinPartTypes.BLOCK, true)) == null) {
            throw SkinSaveException.Type.INVALID_MULTIBLOCK.build("missingMainBlock", new Object[0]);
        }
        return skin;
    }

    private static SkinPart saveArmourPart(Level level, CubeTransform transform, SkinPartType partType, boolean markerCheck) throws SkinSaveException {
        int cubeCount = WorldUtils.getNumberOfCubesInPart(level, transform, partType);
        if (cubeCount < 1) {
            return null;
        }
        SkinGeometrySetV1 geometries = new SkinGeometrySetV1(cubeCount);
        ArrayList<SkinMarker> markerBlocks = new ArrayList<SkinMarker>();
        OpenRectangle3i buildSpace = partType.getBuildingSpace();
        OpenVector3i offset = partType.getOffset();
        int i = 0;
        for (int ix = 0; ix < buildSpace.width(); ++ix) {
            for (int iy = 0; iy < buildSpace.height(); ++iy) {
                for (int iz = 0; iz < buildSpace.depth(); ++iz) {
                    BlockPos target = transform.mul(ix + -offset.x() + buildSpace.x(), iy + -offset.y(), iz + offset.z() + buildSpace.z());
                    int xOrigin = -ix + -buildSpace.x();
                    int yOrigin = -iy + -buildSpace.y();
                    int zOrigin = -iz + -buildSpace.z();
                    BlockState targetState = level.m_8055_(target);
                    if (!(targetState.m_60734_() instanceof SkinCubeBlock)) continue;
                    WorldUtils.saveArmourBlockToList(level, transform, target, xOrigin - 1, yOrigin - 1, -zOrigin, geometries.get(i), markerBlocks);
                    ++i;
                }
            }
        }
        if (markerCheck) {
            if (partType.getMinimumMarkersNeeded() > markerBlocks.size()) {
                throw SkinSaveException.Type.MARKER_ERROR.build("missingMarker", TranslateUtils.Name.of(partType));
            }
            if (markerBlocks.size() > partType.getMaximumMarkersNeeded()) {
                throw SkinSaveException.Type.MARKER_ERROR.build("tooManyMarkers", TranslateUtils.Name.of(partType));
            }
        }
        SkinPart.Builder builder = new SkinPart.Builder(partType);
        builder.geometries(geometries);
        builder.markers(markerBlocks);
        return builder.build();
    }

    private static void saveArmourBlockToList(Level level, CubeTransform transform, BlockPos pos, int ix, int iy, int iz, SkinCube cube, ArrayList<SkinMarker> markerBlocks) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof IPaintable)) {
            return;
        }
        IPaintable target = (IPaintable)blockEntity;
        BlockState blockState = blockEntity.m_58900_();
        OptionalDirection marker = SkinCubeBlock.getMarker(blockState);
        cube.setType(SkinGeometryTypes.byBlock(blockState.m_60734_()));
        cube.setBoundingBox(new OpenRectangle3f(ix, iy, iz, 1.0f, 1.0f, 1.0f));
        for (Direction dir : Direction.values()) {
            ISkinPaintColor paintColor = target.getColor(dir);
            Direction resolvedDir = transform.invRotate(dir);
            cube.setPaintColor(AbstractDirection.wrap(resolvedDir), SkinPaintColor.of(paintColor));
        }
        if (marker != OptionalDirection.NONE) {
            Direction markFacing = transform.invRotate(marker.getDirection());
            OptionalDirection resolvedMarker = OptionalDirection.of(markFacing);
            markerBlocks.add(new SkinMarker((byte)ix, (byte)iy, (byte)iz, (byte)resolvedMarker.ordinal()));
        }
    }

    public static void loadSkinIntoWorld(CubeChangesCollector collector, CubeTransform transform, Skin skin) {
        for (SkinPart part : skin.getParts()) {
            WorldUtils.loadSkinPartIntoWorld(collector, transform, part, false);
        }
    }

    private static void loadSkinPartIntoWorld(CubeChangesCollector collector, CubeTransform transform, SkinPart partData, boolean mirror) {
        SkinPartType skinPart = partData.getType();
        OpenRectangle3i buildSpace = skinPart.getBuildingSpace();
        OpenVector3i offset = skinPart.getOffset();
        for (SkinCube cube : Collections.collect(partData.getGeometries(), SkinCube.class)) {
            OpenVector3i blockPos = cube.getBlockPos();
            ISkinGeometryType geometryType = cube.getType();
            OptionalDirection markerFacing = OptionalDirection.NONE;
            for (SkinMarker marker : partData.getMarkers()) {
                OpenDirection dir = marker.getDirection();
                if (dir == null || !blockPos.equals(marker.getPosition())) continue;
                OptionalDirection resolvedMarker = OptionalDirection.of(WorldUtils.getResolvedDirection(dir, mirror));
                markerFacing = OptionalDirection.of(transform.rotate(resolvedMarker.getDirection()));
                break;
            }
            BlockPos origin = new BlockPos(-offset.x(), -offset.y() + -buildSpace.y(), offset.z());
            WorldUtils.loadSkinBlockIntoWorld(collector, transform, origin, geometryType, blockPos, markerFacing, cube, mirror);
        }
    }

    private static void loadSkinBlockIntoWorld(CubeChangesCollector collector, CubeTransform transform, BlockPos origin, ISkinGeometryType geometryType, IVector3i cubePos, OptionalDirection markerFacing, SkinCube cube, boolean mirror) {
        BlockPos target;
        CubeWrapper targetCube;
        int shiftX = -cubePos.x() - 1;
        int shiftY = cubePos.y() + 1;
        int shiftZ = cubePos.z();
        if (mirror) {
            shiftX = cubePos.x();
        }
        if ((targetCube = collector.getCube(target = transform.mul(shiftX + origin.m_123341_(), origin.m_123342_() - shiftY, shiftZ + origin.m_123343_()))).is((Block)ModBlocks.BOUNDING_BOX.get())) {
            targetCube.setBlockStateAndTag(Blocks.f_50016_.m_49966_(), null);
        }
        Block targetBlock = geometryType.getBlock();
        BlockState targetState = SkinCubeBlock.setMarker(targetBlock.m_49966_(), markerFacing);
        HashMap<Direction, ISkinPaintColor> colors = new HashMap<Direction, ISkinPaintColor>();
        for (OpenDirection dir : OpenDirection.values()) {
            SkinPaintColor paintColor = cube.getPaintColor(dir);
            OptionalDirection resolvedDir = OptionalDirection.of(WorldUtils.getResolvedDirection(dir, mirror));
            colors.put(transform.rotate(resolvedDir.getDirection()), paintColor);
        }
        targetCube.setBlockStateAndColors(targetState, colors);
    }

    public static void copyPaintData(SkinPaintData paintData, EntityTextureModel.Box srcBox, EntityTextureModel.Box destBox, boolean isMirrorX) {
        int srcX = srcBox.getBounds().x();
        int srcY = srcBox.getBounds().y();
        int srcZ = srcBox.getBounds().z();
        int destX = destBox.getBounds().x();
        int destY = destBox.getBounds().y();
        int destZ = destBox.getBounds().z();
        int destWidth = destBox.getBounds().width();
        HashMap<OpenVector2i, Integer> colors = new HashMap<OpenVector2i, Integer>();
        srcBox.forEach((texture, x, y, z, dir) -> {
            OpenVector2i newTexture;
            int ix = x - srcX;
            int iy = y - srcY;
            int iz = z - srcZ;
            if (isMirrorX) {
                ix = destWidth - ix - 1;
                dir = WorldUtils.getResolvedDirection(dir, true);
            }
            if ((newTexture = destBox.get(ix + destX, iy + destY, iz + destZ, dir)) == null) {
                return;
            }
            int color = paintData.getColor(texture);
            if (SkinPaintColor.isOpaque(color)) {
                colors.put(newTexture, color);
            }
        });
        colors.forEach(paintData::setColor);
    }

    public static void clearPaintData(SkinPaintData paintData, EntityTextureModel.Box srcBox) {
        srcBox.forEach((texturePos, x, y, z, dir) -> paintData.setColor(texturePos, 0));
    }

    public static void replaceCubes(CubeChangesCollector collector, CubeTransform transform, SkinType skinType, SkinProperties skinProps, CubeReplacingEvent event) {
        for (SkinPartType skinPartType : skinType.getParts()) {
            for (OpenVector3i offset : WorldUtils.getResolvedBuildingSpace2(skinPartType)) {
                WorldUtils.replaceCube(collector, transform.mul(offset), event);
            }
        }
    }

    public static void replaceCube(CubeChangesCollector collector, BlockPos pos, CubeReplacingEvent event) {
        CubeWrapper cube = collector.getCube(pos);
        if (event.accept(cube)) {
            event.apply(cube);
        }
    }

    public static void copyCubes(CubeChangesCollector collector, CubeTransform transform, SkinType skinType, SkinProperties skinProps, SkinPartType srcType, SkinPartType destType, boolean mirror) throws SkinSaveException {
        SkinPart skinPart = WorldUtils.saveArmourPart(collector.getLevel(), transform, srcType, false);
        if (skinPart != null) {
            SkinPart.Builder builder = new SkinPart.Builder(destType);
            builder.name(skinPart.getName());
            builder.transform(skinPart.getTransform());
            builder.geometries((SkinGeometrySet<?>)skinPart.getGeometries());
            builder.markers((List<SkinMarker>)skinPart.getMarkers());
            builder.children((List<SkinPart>)skinPart.getChildren());
            WorldUtils.loadSkinPartIntoWorld(collector, transform, builder.build(), mirror);
        }
    }

    public static int clearMarkers(CubeChangesCollector collector, CubeTransform transform, SkinType skinType, SkinProperties skinProps, SkinPartType partType) {
        int blockCount = 0;
        for (SkinPartType skinPartType : skinType.getParts()) {
            if (partType != SkinPartTypes.UNKNOWN && partType != skinPartType) continue;
            if (skinType == SkinTypes.BLOCK) {
                boolean multiblock = skinProps.get(SkinProperty.BLOCK_MULTIBLOCK);
                if (skinPartType == SkinPartTypes.BLOCK && !multiblock) {
                    blockCount += WorldUtils.clearMarkersForSkinPart(collector, transform, skinPartType);
                }
                if (skinPartType != SkinPartTypes.BLOCK_MULTI || !multiblock) continue;
                blockCount += WorldUtils.clearMarkersForSkinPart(collector, transform, skinPartType);
                continue;
            }
            blockCount += WorldUtils.clearMarkersForSkinPart(collector, transform, skinPartType);
        }
        return blockCount;
    }

    private static int clearMarkersForSkinPart(CubeChangesCollector collector, CubeTransform transform, SkinPartType skinPart) {
        int blockCount = 0;
        for (OpenVector3i offset : WorldUtils.getResolvedBuildingSpace2(skinPart)) {
            CubeWrapper cube = collector.getCube(transform.mul(offset));
            BlockState targetState = cube.getBlockState();
            if (!targetState.m_61138_((Property)SkinCubeBlock.MARKER) || SkinCubeBlock.getMarker(targetState) == OptionalDirection.NONE) continue;
            cube.setBlockState(SkinCubeBlock.setMarker(targetState, OptionalDirection.NONE));
            ++blockCount;
        }
        return blockCount;
    }

    public static int clearCubes(CubeChangesCollector collector, CubeTransform transform, SkinType skinType, SkinProperties skinProps, SkinPartType partType) {
        int blockCount = 0;
        for (SkinPartType skinPartType : skinType.getParts()) {
            if (partType != SkinPartTypes.UNKNOWN && partType != skinPartType) continue;
            if (skinType == SkinTypes.BLOCK) {
                boolean multiblock = skinProps.get(SkinProperty.BLOCK_MULTIBLOCK);
                if (skinPartType == SkinPartTypes.BLOCK && !multiblock) {
                    blockCount += WorldUtils.clearEquipmentCubesForSkinPart(collector, transform, skinPartType);
                }
                if (skinPartType != SkinPartTypes.BLOCK_MULTI || !multiblock) continue;
                blockCount += WorldUtils.clearEquipmentCubesForSkinPart(collector, transform, skinPartType);
                continue;
            }
            blockCount += WorldUtils.clearEquipmentCubesForSkinPart(collector, transform, skinPartType);
        }
        return blockCount;
    }

    private static int clearEquipmentCubesForSkinPart(CubeChangesCollector collector, CubeTransform transform, SkinPartType skinPart) {
        int blockCount = 0;
        for (OpenVector3i offset : WorldUtils.getResolvedBuildingSpace2(skinPart)) {
            CubeWrapper cube = collector.getCube(transform.mul(offset));
            if (!cube.is(SkinCubeBlock.class)) continue;
            cube.setBlockStateAndTag(Blocks.f_50016_.m_49966_(), null);
            ++blockCount;
        }
        return blockCount;
    }

    public static OpenRectangle3i getResolvedBuildingSpace(SkinPartType skinPart) {
        OpenVector3i origin = skinPart.getOffset();
        OpenRectangle3i buildSpace = skinPart.getBuildingSpace();
        int dx = -origin.x() + buildSpace.x();
        int dy = -origin.y();
        int dz = origin.z() + buildSpace.z();
        return new OpenRectangle3i(dx, dy, dz, buildSpace.width(), buildSpace.height(), buildSpace.depth());
    }

    private static Iterable<OpenVector3i> getResolvedBuildingSpace2(SkinPartType skinPart) {
        return WorldUtils.getResolvedBuildingSpace(skinPart).enumerateZYX();
    }

    private static int getNumberOfCubesInPart(Level level, CubeTransform transform, SkinPartType skinPart) {
        int cubeCount = 0;
        for (OpenVector3i offset : WorldUtils.getResolvedBuildingSpace2(skinPart)) {
            BlockState blockState = level.m_8055_(transform.mul(offset));
            if (!(blockState.m_60734_() instanceof SkinCubeBlock)) continue;
            ++cubeCount;
        }
        return cubeCount;
    }

    private static OpenDirection getResolvedDirection(OpenDirection dir, boolean mirror) {
        if (mirror && dir.getAxis() == OpenDirection.Axis.X) {
            return dir.getOpposite();
        }
        return dir;
    }
}

