/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.IPaintable;
import moe.plushie.armourers_workshop.api.skin.texture.ISkinPaintColor;
import moe.plushie.armourers_workshop.builder.other.CubeChanges;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.level.block.entity.BlockEntity.StorageAPI;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CubeWrapper
implements IPaintable {
    private final Consumer<CubeChanges> consumer;
    private final Level level;
    private BlockPos pos;
    private Supplier<BlockState> state;
    private Supplier<BlockEntity> blockEntity;
    private Supplier<IPaintable> target;
    private CubeChanges changes;

    public CubeWrapper(Level level, Consumer<CubeChanges> consumer) {
        this.consumer = consumer;
        this.level = level;
    }

    public boolean is(Class<?> clazz) {
        if (Block.class.isAssignableFrom(clazz)) {
            return clazz.isInstance(this.getBlock());
        }
        return clazz.isInstance(this.getBlockEntity());
    }

    public boolean is(Block block) {
        return this.getBlockState().m_60713_(block);
    }

    public Block getBlock() {
        return this.getBlockState().m_60734_();
    }

    public BlockState getBlockState() {
        if (this.state != null) {
            return this.state.get();
        }
        if (this.pos != null) {
            BlockState state = this.level.m_8055_(this.pos);
            this.state = () -> state;
            return state;
        }
        return Blocks.f_50016_.m_49966_();
    }

    public void setBlockState(BlockState state) {
        this.lastChanges().setBlockState(state);
    }

    public void setBlockStateAndTag(BlockState state, CompoundTag nbt) {
        this.lastChanges().setBlockState(state);
        this.lastChanges().setCompoundTag(nbt);
    }

    public void setBlockStateAndColors(BlockState state, Map<Direction, ISkinPaintColor> colors) {
        this.lastChanges().setBlockState(state);
        this.lastChanges().setColors(colors);
    }

    @Nullable
    public BlockEntity getBlockEntity() {
        if (this.blockEntity != null) {
            return this.blockEntity.get();
        }
        if (this.pos != null) {
            BlockEntity blockEntity = this.level.m_7702_(this.pos);
            this.blockEntity = () -> blockEntity;
            return blockEntity;
        }
        return null;
    }

    @Nullable
    public CompoundTag getBlockTag() {
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity != null) {
            return StorageAPI.saveFullData(blockEntity, this.level.m_9598_());
        }
        return null;
    }

    @Override
    public ISkinPaintColor getColor(Direction direction) {
        IPaintable target = this.getTarget();
        if (target != null) {
            return target.getColor(direction);
        }
        return null;
    }

    @Override
    public void setColor(Direction direction, ISkinPaintColor color) {
        this.lastChanges().setColor(direction, color);
    }

    @Override
    public void setColors(Map<Direction, ISkinPaintColor> colors) {
        this.lastChanges().setColors(colors);
    }

    @Override
    public boolean shouldChangeColor(Direction direction) {
        IPaintable target = this.getTarget();
        if (target != null) {
            return target.shouldChangeColor(direction);
        }
        return false;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        if (this.pos != pos) {
            this.submit();
        }
        this.pos = pos;
    }

    private IPaintable getTarget() {
        if (this.target != null) {
            return this.target.get();
        }
        IPaintable target = Objects.safeCast(this.getBlockEntity(), IPaintable.class);
        if (target != null) {
            this.target = () -> target;
            return target;
        }
        return null;
    }

    private CubeChanges lastChanges() {
        if (this.changes == null) {
            this.changes = new CubeChanges(this.level, this.pos);
        }
        return this.changes;
    }

    private void submit() {
        if (this.changes != null) {
            this.consumer.accept(this.changes);
            this.changes = null;
        }
        this.pos = null;
        this.state = null;
        this.blockEntity = null;
        this.target = null;
    }
}

