/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.HashMap;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.common.IItemColorProvider;
import moe.plushie.armourers_workshop.api.common.IPaintable;
import moe.plushie.armourers_workshop.api.skin.texture.ISkinPaintColor;
import moe.plushie.armourers_workshop.builder.block.SkinCubeBlock;
import moe.plushie.armourers_workshop.builder.item.SkinCubeItem;
import moe.plushie.armourers_workshop.builder.other.CubeWrapper;
import moe.plushie.armourers_workshop.core.data.color.BlockPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CubeReplacingEvent {
    public final ItemStack source;
    public final Block sourceBlock;
    public final BlockPaintColor sourceBlockColor;
    public final ItemStack destination;
    public final Block destinationBlock;
    public final BlockPaintColor destinationBlockColor;
    public final boolean isEmptySource;
    public final boolean isEmptyDestination;
    public final boolean isChangedBlock;
    public boolean keepColor = true;
    public boolean keepPaintType = true;
    public int changes = 0;
    public int blockChanges = 0;
    public int blockColorChanges = 0;

    public CubeReplacingEvent(ItemStack source, ItemStack destination) {
        this.source = source;
        this.sourceBlock = this.getBlock(source);
        this.sourceBlockColor = this.getBlockColor(source);
        this.destination = destination;
        this.destinationBlock = this.getBlock(destination);
        this.destinationBlockColor = this.getBlockColor(destination);
        this.isEmptySource = this.sourceBlock == null && this.sourceBlockColor == null;
        this.isEmptyDestination = this.destinationBlock == null && this.destinationBlockColor == null;
        this.isChangedBlock = this.isChangedBlock();
    }

    public boolean accept(CubeWrapper cube) {
        if (!cube.is(IPaintable.class)) {
            return false;
        }
        if (this.source.m_41619_()) {
            return true;
        }
        if (this.sourceBlock != null && !cube.is(this.sourceBlock)) {
            return false;
        }
        if (this.sourceBlockColor != null) {
            int diff = 0;
            for (Direction dir : Direction.values()) {
                ISkinPaintColor t;
                SkinPaintColor s = this.sourceBlockColor.getOrDefault(dir, SkinPaintColor.WHITE);
                if (Objects.equals(s, t = cube.getColor(dir))) continue;
                ++diff;
            }
            if (this.isChangedBlock) {
                return diff < 1;
            }
            return diff < 6;
        }
        return true;
    }

    public void apply(CubeWrapper cube) {
        if (!cube.is(IPaintable.class)) {
            return;
        }
        int oldBlockChanges = this.blockChanges;
        int oldBlockColorChanges = this.blockColorChanges;
        if (!this.destination.m_41619_() && this.destinationBlockColor != null) {
            this.applyColor(cube);
        }
        if (this.isChangedBlock) {
            this.applyBlock(cube);
        }
        if (oldBlockChanges != this.blockChanges || oldBlockColorChanges != this.blockColorChanges) {
            ++this.changes;
        }
    }

    private void applyColor(CubeWrapper cube) {
        if (this.keepColor && this.keepPaintType) {
            return;
        }
        HashMap<Direction, ISkinPaintColor> newColors = new HashMap<Direction, ISkinPaintColor>();
        for (Direction dir : Direction.values()) {
            SkinPaintColor sourceColor;
            SkinPaintColor targetColor = (SkinPaintColor)cube.getColor(dir);
            if (this.sourceBlockColor != null && !Objects.equals(sourceColor = this.sourceBlockColor.getOrDefault(dir, SkinPaintColor.WHITE), targetColor)) {
                newColors.put(dir, targetColor);
                continue;
            }
            SkinPaintColor newColor = this.destinationBlockColor.getOrDefault(dir, SkinPaintColor.WHITE);
            int color = newColor.getRGB();
            if (this.keepColor) {
                color = targetColor.getRGB();
            }
            SkinPaintType paintType = newColor.getPaintType();
            if (this.keepPaintType) {
                paintType = targetColor.getPaintType();
            }
            newColor = SkinPaintColor.of(color, paintType);
            newColors.put(dir, newColor);
        }
        cube.setColors(newColors);
        ++this.blockColorChanges;
    }

    private void applyBlock(CubeWrapper cube) {
        if (!cube.is(SkinCubeBlock.class)) {
            return;
        }
        CompoundTag newNBT = null;
        BlockState oldState = cube.getBlockState();
        BlockState newState = Blocks.f_50016_.m_49966_();
        if (this.destinationBlock != null) {
            newNBT = cube.getBlockTag();
            newState = this.destinationBlock.m_49966_();
            for (Property property : oldState.m_61147_()) {
                newState = this.applyBlockState(newState, oldState, property);
            }
        }
        cube.setBlockStateAndTag(newState, newNBT);
        ++this.blockChanges;
    }

    private <T extends Comparable<T>> BlockState applyBlockState(BlockState newState, BlockState oldState, Property<T> property) {
        if (newState.m_61138_(property)) {
            return (BlockState)newState.m_61124_(property, oldState.m_61143_(property));
        }
        return newState;
    }

    private Block getBlock(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof SkinCubeItem) {
            SkinCubeItem cubeItem = (SkinCubeItem)item;
            return cubeItem.m_40614_();
        }
        return null;
    }

    private BlockPaintColor getBlockColor(ItemStack itemStack) {
        IItemColorProvider provider;
        ISkinPaintColor paintColor;
        Item item = itemStack.m_41720_();
        if (item instanceof SkinCubeItem) {
            SkinCubeItem cubeItem = (SkinCubeItem)item;
            return cubeItem.getItemColors(itemStack);
        }
        if (item instanceof IItemColorProvider && (paintColor = (provider = (IItemColorProvider)item).getItemColor(itemStack)) != null) {
            return new BlockPaintColor((SkinPaintColor)paintColor);
        }
        return null;
    }

    private boolean isChangedBlock() {
        if (this.source.m_41619_() && this.destinationBlock != null) {
            return true;
        }
        if (this.destination.m_41619_() && this.sourceBlock != null) {
            return true;
        }
        return this.destinationBlock != null && !this.destinationBlock.equals(this.sourceBlock);
    }
}

