/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.HashMap;
import java.util.Random;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IPaintable;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.skin.texture.ISkinPaintColor;
import moe.plushie.armourers_workshop.builder.blockentity.BoundingBoxBlockEntity;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolAction;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolSelector;
import moe.plushie.armourers_workshop.builder.other.CubeChangesCollector;
import moe.plushie.armourers_workshop.builder.other.CubeSelector;
import moe.plushie.armourers_workshop.builder.other.CubeWrapper;
import moe.plushie.armourers_workshop.core.data.color.TexturedPaintColor;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.utils.ColorUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class CubePaintingEvent {
    private static final HashMap<Class<? extends Action>, ActionTypes> REVERSE_LOOKUP = new HashMap();
    final IPaintToolAction action;
    final IPaintToolSelector selector;
    final HashMap<Pair<BlockPos, Direction>, IPaintToolAction> overrides = new HashMap();
    private int targetCount = 0;

    public CubePaintingEvent(IPaintToolSelector selector, IPaintToolAction action) {
        this.selector = selector;
        this.action = action;
    }

    public CubePaintingEvent(IFriendlyByteBuf buffer) {
        int size;
        this.selector = CubeSelector.from(buffer);
        this.action = Action.fromBuffer(buffer);
        while ((size = buffer.readByte()) > 0) {
            BlockPos pos = buffer.readBlockPos();
            for (int i = 0; i < size; ++i) {
                Direction dir = buffer.readEnum(Direction.class);
                Action action = Action.fromBuffer(buffer);
                this.overrides.put((Pair<BlockPos, Direction>)Pair.of((Object)pos, (Object)dir), action);
            }
        }
    }

    public void encode(IFriendlyByteBuf buffer) {
        this.selector.encode(buffer);
        Action.writeBuffer(this.action, buffer);
        HashMap<BlockPos, HashMap> sorted = new HashMap<BlockPos, HashMap>();
        this.overrides.forEach((pair, action) -> sorted.computeIfAbsent((BlockPos)pair.getKey(), k -> new HashMap()).put((Direction)pair.getValue(), action));
        sorted.forEach((pos, items) -> {
            buffer.writeByte(items.size());
            buffer.writeBlockPos((BlockPos)pos);
            items.forEach((dir, action) -> {
                buffer.writeEnum((Enum<?>)dir);
                Action.writeBuffer(action, buffer);
            });
        });
        buffer.writeByte(0);
    }

    public boolean prepare(CubeChangesCollector collector, UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        this.selector.forEach(context, (target, dir) -> {
            IPaintToolAction action1;
            CubeWrapper cube = collector.getCube((BlockPos)target);
            if (cube.is(IPaintable.class)) {
                ++this.targetCount;
            }
            if ((action1 = this.action.build(level, (BlockPos)target, (Direction)dir, cube, player)) != this.action) {
                this.overrides.put((Pair<BlockPos, Direction>)Pair.of((Object)target, (Object)dir), action1);
            }
        });
        return this.targetCount != 0;
    }

    public void apply(CubeChangesCollector collector, UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        this.selector.forEach(context, (target, dir) -> {
            IPaintToolAction action1 = this.overrides.getOrDefault(Pair.of((Object)target, (Object)dir), this.action);
            action1.apply(level, (BlockPos)target, (Direction)dir, collector.getCube((BlockPos)target), player);
        });
    }

    public static abstract class Action
    implements IPaintToolAction {
        public static Action fromBuffer(IFriendlyByteBuf buffer) {
            ActionTypes type = buffer.readEnum(ActionTypes.class);
            return type.factory.apply(buffer);
        }

        public static void writeBuffer(IPaintToolAction action, IFriendlyByteBuf buffer) {
            buffer.writeEnum(ActionTypes.getType(action.getClass()));
            action.encode(buffer);
        }

        @Override
        public abstract void apply(Level var1, BlockPos var2, Direction var3, IPaintable var4, @Nullable Player var5);

        @Override
        public Action build(Level level, BlockPos pos, Direction dir, IPaintable provider, @Nullable Player player) {
            return this;
        }

        @Override
        public abstract void encode(IFriendlyByteBuf var1);
    }

    public static enum ActionTypes {
        SET_COLOR(SetAction.class, SetAction::new),
        SET_BRIGHTNESS(BrightnessAction.class, BrightnessAction::new),
        SET_NOISE(NoiseAction.class, NoiseAction::new),
        SET_HUE(HueAction.class, HueAction::new),
        SET_BLENDING(BlendingAction.class, BlendingAction::new),
        CLEAR_COLOR(ClearAction.class, ClearAction::new);

        private final Function<IFriendlyByteBuf, Action> factory;

        private ActionTypes(Class<? extends Action> packetClass, Function<IFriendlyByteBuf, Action> factory) {
            this.factory = factory;
            REVERSE_LOOKUP.put(packetClass, this);
        }

        public static ActionTypes getType(Class<?> c) {
            return REVERSE_LOOKUP.get(c);
        }
    }

    public static class BlendingAction
    extends MixedAction {
        final int intensity;
        final ISkinPaintColor destinationColor;

        public BlendingAction(ISkinPaintColor destinationColor, int intensity) {
            this.destinationColor = destinationColor;
            this.intensity = intensity;
        }

        public BlendingAction(IFriendlyByteBuf buffer) {
            this.destinationColor = SkinPaintColor.of(buffer.readInt());
            this.intensity = buffer.readInt();
        }

        @Override
        public void encode(IFriendlyByteBuf buffer) {
            buffer.writeInt(this.destinationColor.getRawValue());
            buffer.writeInt(this.intensity);
        }

        @Override
        public ISkinPaintColor resolve(BlockPos pos, Direction dir, ISkinPaintColor sourceColor) {
            int destRGB = this.destinationColor.getRGB();
            int destR = ColorUtils.getRed(destRGB);
            int destG = ColorUtils.getGreen(destRGB);
            int destB = ColorUtils.getBlue(destRGB);
            int sourceRGB = sourceColor.getRGB();
            int oldR = ColorUtils.getRed(sourceRGB);
            int oldG = ColorUtils.getGreen(sourceRGB);
            int oldB = ColorUtils.getBlue(sourceRGB);
            float newR = (float)destR / 100.0f * (float)this.intensity;
            newR += (float)oldR / 100.0f * (float)(100 - this.intensity);
            newR = OpenMath.clamp((int)newR, 0, 255);
            float newG = (float)destG / 100.0f * (float)this.intensity;
            newG += (float)oldG / 100.0f * (float)(100 - this.intensity);
            newG = OpenMath.clamp((int)newG, 0, 255);
            float newB = (float)destB / 100.0f * (float)this.intensity;
            newB += (float)oldB / 100.0f * (float)(100 - this.intensity);
            newB = OpenMath.clamp((int)newB, 0, 255);
            return sourceColor.withColor((int)newR, (int)newG, (int)newB);
        }
    }

    public static class HueAction
    extends MixedAction {
        final ISkinPaintColor destinationColor;
        final boolean changeHue;
        final boolean changeSaturation;
        final boolean changeBrightness;
        final boolean changePaintType;

        public HueAction(ISkinPaintColor paintColor, boolean hue, boolean saturation, boolean brightness, boolean paintType) {
            this.destinationColor = paintColor;
            this.changeHue = hue;
            this.changeSaturation = saturation;
            this.changeBrightness = brightness;
            this.changePaintType = paintType;
        }

        public HueAction(IFriendlyByteBuf buffer) {
            this.destinationColor = SkinPaintColor.of(buffer.readInt());
            this.changeHue = buffer.readBoolean();
            this.changeSaturation = buffer.readBoolean();
            this.changeBrightness = buffer.readBoolean();
            this.changePaintType = buffer.readBoolean();
        }

        @Override
        public void encode(IFriendlyByteBuf buffer) {
            buffer.writeInt(this.destinationColor.getRawValue());
            buffer.writeBoolean(this.changeHue);
            buffer.writeBoolean(this.changeSaturation);
            buffer.writeBoolean(this.changeBrightness);
            buffer.writeBoolean(this.changePaintType);
        }

        @Override
        public ISkinPaintColor resolve(BlockPos pos, Direction dir, ISkinPaintColor sourceColor) {
            float[] sourceHSB = ColorUtils.RGBtoHSB(sourceColor.getRGB());
            float[] destinationHSB = ColorUtils.RGBtoHSB(this.destinationColor.getRGB());
            if (!this.changeHue) {
                destinationHSB[0] = sourceHSB[0];
            }
            if (!this.changeSaturation) {
                destinationHSB[1] = sourceHSB[1];
            }
            if (!this.changeBrightness) {
                destinationHSB[2] = sourceHSB[2];
            }
            int rgb = ColorUtils.HSBtoRGB(destinationHSB);
            if (!this.changePaintType) {
                return sourceColor.withColor(rgb);
            }
            return this.destinationColor.withColor(rgb);
        }
    }

    public static class NoiseAction
    extends MixedAction {
        final int intensity;
        final boolean isShadeOnly;
        final int seed;
        final Random random = new Random();

        public NoiseAction(int intensity, boolean isShadeOnly) {
            this.intensity = intensity;
            this.isShadeOnly = isShadeOnly;
            this.seed = this.random.nextInt();
        }

        public NoiseAction(IFriendlyByteBuf buffer) {
            this.intensity = buffer.readInt();
            this.isShadeOnly = buffer.readBoolean();
            this.seed = buffer.readInt();
        }

        @Override
        public void encode(IFriendlyByteBuf buffer) {
            buffer.writeInt(this.intensity);
            buffer.writeBoolean(this.isShadeOnly);
            buffer.writeInt(this.seed);
        }

        @Override
        public ISkinPaintColor resolve(BlockPos pos, Direction dir, ISkinPaintColor sourceColor) {
            int rgb = sourceColor.getRGB();
            rgb = this.isShadeOnly ? ColorUtils.addShadeNoise(rgb, this.intensity, this.getRandom(pos, dir)) : ColorUtils.addColorNoise(rgb, this.intensity, this.getRandom(pos, dir));
            return sourceColor.withColor(rgb);
        }

        private Random getRandom(BlockPos pos, Direction dir) {
            this.random.setSeed(pos.m_121878_() + ((long)this.seed << dir.ordinal()));
            return this.random;
        }
    }

    public static class BrightnessAction
    extends MixedAction {
        final int intensity;

        public BrightnessAction(int intensity) {
            this.intensity = intensity;
        }

        public BrightnessAction(IFriendlyByteBuf buffer) {
            this.intensity = buffer.readInt();
        }

        @Override
        public void encode(IFriendlyByteBuf buffer) {
            buffer.writeInt(this.intensity);
        }

        @Override
        public ISkinPaintColor resolve(BlockPos pos, Direction dir, ISkinPaintColor sourceColor) {
            int rgb = sourceColor.getRGB();
            rgb = ColorUtils.makeColorBighter(rgb, this.intensity);
            return sourceColor.withColor(rgb);
        }
    }

    public static class ClearAction
    extends Action {
        public ClearAction() {
        }

        public ClearAction(IFriendlyByteBuf buffer) {
        }

        @Override
        public void encode(IFriendlyByteBuf buffer) {
        }

        @Override
        public void apply(Level level, BlockPos pos, Direction dir, IPaintable provider, @Nullable Player player) {
            if (provider.shouldChangeColor(dir)) {
                if (level.m_7702_(pos) instanceof BoundingBoxBlockEntity) {
                    provider.setColor(dir, SkinPaintColor.CLEAR);
                } else {
                    provider.setColor(dir, SkinPaintColor.WHITE);
                }
            }
        }
    }

    public static class SetAction
    extends Action {
        final ISkinPaintColor destinationColor;
        final boolean usePaintColor;
        final boolean usePaintType;

        public SetAction(ISkinPaintColor paintColor) {
            this(paintColor, true, true);
        }

        public SetAction(ISkinPaintColor paintColor, boolean usePaintColor, boolean usePaintType) {
            this.destinationColor = paintColor;
            this.usePaintColor = usePaintColor;
            this.usePaintType = usePaintType;
        }

        public SetAction(IFriendlyByteBuf buffer) {
            this.destinationColor = SkinPaintColor.of(buffer.readInt());
            this.usePaintColor = buffer.readBoolean();
            this.usePaintType = buffer.readBoolean();
        }

        @Override
        public void encode(IFriendlyByteBuf buffer) {
            buffer.writeInt(this.destinationColor.getRawValue());
            buffer.writeBoolean(this.usePaintColor);
            buffer.writeBoolean(this.usePaintType);
        }

        @Override
        public void apply(Level level, BlockPos pos, Direction dir, IPaintable provider, @Nullable Player player) {
            if (provider.shouldChangeColor(dir)) {
                provider.setColor(dir, this.resolve(pos, dir, provider));
            }
        }

        public ISkinPaintColor resolve(BlockPos pos, Direction dir, IPaintable provider) {
            if (this.usePaintType && this.usePaintColor) {
                return this.destinationColor;
            }
            ISkinPaintColor oldValue = provider.getColor(dir);
            if (this.usePaintColor) {
                return this.destinationColor.withPaintType(oldValue.getPaintType());
            }
            if (this.usePaintType) {
                return this.destinationColor.withColor(oldValue.getRed());
            }
            return oldValue;
        }
    }

    public static abstract class MixedAction
    extends Action {
        public abstract ISkinPaintColor resolve(BlockPos var1, Direction var2, ISkinPaintColor var3);

        @Override
        public Action build(Level level, BlockPos pos, Direction dir, IPaintable provider, @Nullable Player player) {
            ISkinPaintColor paintColor;
            if (provider.shouldChangeColor(dir) && (paintColor = provider.getColor(dir)) instanceof TexturedPaintColor) {
                return new SetAction(this.resolve(pos, dir, paintColor));
            }
            return this;
        }

        @Override
        public void apply(Level level, BlockPos pos, Direction dir, IPaintable provider, @Nullable Player player) {
            if (provider.shouldChangeColor(dir)) {
                provider.setColor(dir, this.resolve(pos, dir, provider.getColor(dir)));
            }
        }
    }
}

