/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import moe.plushie.armourers_workshop.api.common.IBlockSnapshot;
import moe.plushie.armourers_workshop.api.common.IPaintable;
import moe.plushie.armourers_workshop.api.core.IRegistryHolder;
import moe.plushie.armourers_workshop.builder.data.undo.UndoManager;
import moe.plushie.armourers_workshop.builder.data.undo.action.NamedUserAction;
import moe.plushie.armourers_workshop.builder.data.undo.action.SetBlockAction;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.init.ModBlocks;
import moe.plushie.armourers_workshop.init.event.common.BlockEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public final class BlockUtils {
    private static final Set<IRegistryHolder<Block>> SNAPSHOT_BLOCKS = Collections.immutableSet(builder -> {
        builder.add(ModBlocks.SKIN_CUBE);
        builder.add(ModBlocks.SKIN_CUBE_GLASS);
        builder.add(ModBlocks.SKIN_CUBE_GLASS_GLOWING);
        builder.add(ModBlocks.SKIN_CUBE_GLOWING);
        builder.add(ModBlocks.ADVANCED_SKIN_BUILDER);
    });
    private static final ThreadLocal<Map<BlockEntity, Runnable>> SNAPSHOT_QUEUE = ThreadLocal.withInitial(() -> null);

    public static void beginCombiner() {
        Map<BlockEntity, Runnable> queue = SNAPSHOT_QUEUE.get();
        if (queue == null) {
            SNAPSHOT_QUEUE.set(new IdentityHashMap());
        }
    }

    public static <T extends BlockEntity> void combine(T blockEntity, Runnable handler) {
        Map<BlockEntity, Runnable> queue = SNAPSHOT_QUEUE.get();
        if (queue == null) {
            handler.run();
            blockEntity.m_6596_();
            return;
        }
        queue.put(blockEntity, handler);
    }

    public static void snapshot(BlockEvent event) {
        ServerPlayer player;
        Entity entity;
        block5: {
            block4: {
                entity = event.getEntity();
                if (!(entity instanceof ServerPlayer)) break block4;
                player = (ServerPlayer)entity;
                entity = event.getLevel();
                if (entity instanceof Level) break block5;
            }
            return;
        }
        Level level = (Level)entity;
        ActionType actionType = ActionType.of(event);
        if (actionType == null) {
            return;
        }
        IBlockSnapshot snapshot = event.getSnapshot();
        NamedUserAction group = new NamedUserAction(actionType.getTitle());
        group.push(new SetBlockAction(level, event.getPos(), snapshot.getState(), snapshot.getTag()));
        UndoManager.of(player.m_20148_()).push(group);
    }

    public static void endCombiner() {
        Map<BlockEntity, Runnable> queue = SNAPSHOT_QUEUE.get();
        if (queue == null) {
            return;
        }
        queue.forEach((k, v) -> {
            v.run();
            k.m_6596_();
        });
        SNAPSHOT_QUEUE.remove();
    }

    public static void performBatch(Runnable handler) {
        try {
            BlockUtils.beginCombiner();
            handler.run();
        }
        finally {
            BlockUtils.endCombiner();
        }
    }

    public static ArrayList<BlockPos> findTouchingBlockFaces(Level level, BlockPos pos, Direction facing, int radius, boolean restrictPlane) {
        ArrayList<BlockPos> blockFaces = new ArrayList<BlockPos>();
        ArrayList<BlockPos> openList = new ArrayList<BlockPos>();
        HashSet<BlockPos> closedList = new HashSet<BlockPos>();
        BlockPos startPos = pos.m_121945_(facing);
        openList.add(startPos);
        Direction[] sides = Direction.values();
        boolean first = true;
        while (!openList.isEmpty()) {
            BlockPos loc = (BlockPos)openList.remove(0);
            BlockEntity blockEntity = level.m_7702_(loc);
            if (blockEntity instanceof IPaintable) {
                if (!restrictPlane) {
                    blockFaces.add(loc);
                } else if (BlockUtils.samePlane(loc, pos, facing)) {
                    blockFaces.add(loc);
                }
            }
            for (Direction side : sides) {
                BlockPos sideLoc = loc.m_121945_(side);
                if (closedList.contains(sideLoc)) continue;
                closedList.add(sideLoc);
                if (!(BlockUtils.getDistance(sideLoc, pos) < (double)radius & BlockUtils.hasPaintableBlock(level, sideLoc))) continue;
                openList.add(sideLoc);
            }
            if (closedList.size() <= 5000) continue;
            break;
        }
        return blockFaces;
    }

    public static double getDistance(BlockPos src, BlockPos dst) {
        double d0 = src.m_123341_() - dst.m_123341_();
        double d1 = src.m_123342_() - dst.m_123342_();
        double d2 = src.m_123343_() - dst.m_123343_();
        return Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
    }

    private static boolean hasPaintableBlock(Level level, BlockPos pos) {
        for (int ix = 0; ix < 3; ++ix) {
            for (int iy = 0; iy < 3; ++iy) {
                for (int iz = 0; iz < 3; ++iz) {
                    BlockEntity stateValid = level.m_7702_(pos.m_7918_(ix - 1, iy - 1, iz - 1));
                    if (!(stateValid instanceof IPaintable)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean samePlane(BlockPos src, BlockPos dst, Direction direction) {
        if (!(direction.m_122429_() != 0 && src.m_123341_() != dst.m_123341_() || direction.m_122430_() != 0 && src.m_123342_() != dst.m_123342_())) {
            return direction.m_122431_() == 0 || src.m_123343_() == dst.m_123343_();
        }
        return false;
    }

    private static boolean isSnapshotBlock(Block block) {
        return SNAPSHOT_BLOCKS.stream().anyMatch(it -> it.get() == block);
    }

    public static class ActionType {
        private final Component title;

        private ActionType(Component title) {
            this.title = title;
        }

        public static ActionType of(BlockEvent event) {
            BlockState blockState = event.getState();
            if (blockState != null && BlockUtils.isSnapshotBlock(blockState.m_60734_())) {
                return new ActionType((Component)Component.m_237115_((String)"chat.armourers_workshop.undo.placeBlock"));
            }
            IBlockSnapshot snapshot = event.getSnapshot();
            if (blockState == null && BlockUtils.isSnapshotBlock(snapshot.getState().m_60734_())) {
                return new ActionType((Component)Component.m_237115_((String)"chat.armourers_workshop.undo.breakBlock"));
            }
            return null;
        }

        public Component getTitle() {
            return this.title;
        }
    }
}

