/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import com.mojang.authlib.GameProfile;
import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.builder.blockentity.OutfitMakerBlockEntity;
import moe.plushie.armourers_workshop.builder.menu.OutfitMakerMenu;
import moe.plushie.armourers_workshop.builder.other.BlockUtils;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.data.GenericProperties;
import moe.plushie.armourers_workshop.core.data.GenericProperty;
import moe.plushie.armourers_workshop.core.data.GenericValue;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;

public class UpdateOutfitMakerPacket
extends CustomPacket {
    private final BlockPos pos;
    private final GenericValue<OutfitMakerBlockEntity, ?> fieldValue;

    public UpdateOutfitMakerPacket(IFriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.fieldValue = Field.TYPE.read(buffer);
    }

    public UpdateOutfitMakerPacket(OutfitMakerBlockEntity entity, GenericValue<OutfitMakerBlockEntity, ?> fieldValue) {
        this.pos = entity.m_58899_();
        this.fieldValue = fieldValue;
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        this.fieldValue.write(buffer);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        GenericProperty<OutfitMakerBlockEntity, ?> genericProperty;
        OutfitMakerBlockEntity blockEntity1;
        block3: {
            block2: {
                BlockEntity blockEntity = PropertyProvider.getLevel((Entity)player).m_7702_(this.pos);
                if (!(blockEntity instanceof OutfitMakerBlockEntity)) break block2;
                blockEntity1 = (OutfitMakerBlockEntity)blockEntity;
                genericProperty = this.fieldValue.getProperty();
                if (genericProperty instanceof Field) break block3;
            }
            return;
        }
        Field field = (Field)genericProperty;
        BlockUtils.performBatch(() -> {
            try {
                field.apply(this, blockEntity1, player);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        });
    }

    private void craftItem(OutfitMakerBlockEntity blockEntity, ServerPlayer player) {
        if (!ModPermissions.OUTFIT_MAKER_MAKE.accept((Player)player)) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof OutfitMakerMenu) {
            OutfitMakerMenu menu = (OutfitMakerMenu)abstractContainerMenu;
            CompoundTag nbt = (CompoundTag)this.fieldValue.getValue();
            GameProfile profile = DataSerializers.readGameProfile(nbt);
            menu.saveArmourItem((Player)player, profile);
        }
    }

    public static final class Field<T>
    extends GenericProperty<OutfitMakerBlockEntity, T> {
        private static final GenericProperties<OutfitMakerBlockEntity> TYPE = GenericProperties.of(OutfitMakerBlockEntity.class, UpdateOutfitMakerPacket::new);
        public static final Field<String> ITEM_NAME = Field.create(OutfitMakerBlockEntity::getItemName, OutfitMakerBlockEntity::setItemName, DataSerializers.STRING);
        public static final Field<String> ITEM_FLAVOUR = Field.create(OutfitMakerBlockEntity::getItemFlavour, OutfitMakerBlockEntity::setItemFlavour, DataSerializers.STRING);
        public static final Field<CompoundTag> ITEM_CRAFTING = Field.create(UpdateOutfitMakerPacket::craftItem, DataSerializers.COMPOUND_TAG);
        private FieldAction<T> action;

        private static <T> Field<T> create(FieldAction<T> action, IEntitySerializer<T> dataSerializer) {
            Field field = TYPE.create(dataSerializer).build(Field::new);
            field.action = action;
            return field;
        }

        private static <T> Field<T> create(Function<OutfitMakerBlockEntity, T> supplier, BiConsumer<OutfitMakerBlockEntity, T> applier, IEntitySerializer<T> dataSerializer) {
            return TYPE.create(dataSerializer).getter(supplier).setter(applier).build(Field::new);
        }

        private void apply(UpdateOutfitMakerPacket packet, OutfitMakerBlockEntity blockEntity, ServerPlayer player) throws Exception {
            if (this.action != null) {
                this.action.accept(packet, blockEntity, player);
            } else {
                packet.fieldValue.apply(blockEntity);
            }
        }
    }

    public static interface FieldAction<T> {
        public void accept(UpdateOutfitMakerPacket var1, OutfitMakerBlockEntity var2, ServerPlayer var3) throws Exception;
    }
}

