/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.item;

import java.util.List;
import moe.plushie.armourers_workshop.api.common.IItemColorProvider;
import moe.plushie.armourers_workshop.api.common.ITooltipContext;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.skin.texture.ISkinPaintColor;
import moe.plushie.armourers_workshop.compatibility.core.AbstractBlockItem;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.level.block.entity.BlockEntity.StorageAPI;
import moe.plushie.armourers_workshop.core.data.color.BlockPaintColor;
import moe.plushie.armourers_workshop.core.item.impl.IPaintProvider;
import moe.plushie.armourers_workshop.core.item.impl.IPaintToolPicker;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.utils.ColorUtils;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.core.utils.TypedRegistry;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class SkinCubeItem
extends AbstractBlockItem
implements IItemColorProvider,
IPaintToolPicker {
    public SkinCubeItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @Override
    public InteractionResult usePickTool(Level level, BlockPos pos, Direction dir, BlockEntity blockEntity, UseOnContext context) {
        ItemStack itemStack = context.m_43722_();
        if (blockEntity instanceof IPaintProvider) {
            IPaintProvider provider = (IPaintProvider)blockEntity;
            this.setItemColor(itemStack, provider.getColor());
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    protected boolean m_7274_(BlockPos pos, Level level, @Nullable Player player, ItemStack itemStack, BlockState blockState) {
        BlockEntity blockEntity = level.m_7702_(pos);
        CompoundTag entityTag = (CompoundTag)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.BLOCK_ENTITY_DATA.get());
        if (entityTag != null && blockEntity != null) {
            CompoundTag newNBT = StorageAPI.saveFullData(blockEntity, level.m_9598_());
            newNBT.m_128365_("Color", (Tag)entityTag.m_128469_("Color"));
            StorageAPI.loadFullData(blockEntity, newNBT, level.m_9598_());
        }
        return super.m_7274_(pos, level, player, itemStack, blockState);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemStack, List<Component> tooltips, ITooltipContext context) {
        super.appendHoverText(itemStack, tooltips, context);
        BlockPaintColor paintColor = this.getItemColors(itemStack);
        if (paintColor != null && paintColor.isPureColor()) {
            tooltips.addAll(ColorUtils.getColorTooltips(paintColor.get(Direction.NORTH), true));
        }
    }

    @Override
    public void setItemColor(ItemStack itemStack, ISkinPaintColor paintColor) {
        CompoundTag entityTag = new CompoundTag();
        CompoundTag oldEntityTag = (CompoundTag)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.BLOCK_ENTITY_DATA.get());
        if (oldEntityTag != null) {
            entityTag.m_128391_(oldEntityTag);
        }
        entityTag.m_128359_("id", TypedRegistry.findKey(this.m_40614_()).toString());
        BlockPaintColor color = new BlockPaintColor((SkinPaintColor)paintColor);
        TagSerializer serializer = new TagSerializer();
        color.serialize(serializer);
        entityTag.m_128365_("Color", (Tag)serializer.getTag());
        ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.TOOL_FLAGS.get(), 1);
        ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.BLOCK_ENTITY_DATA.get(), entityTag);
    }

    @Override
    public ISkinPaintColor getItemColor(ItemStack itemStack) {
        return ComponentAPI.getOrDefault(itemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get(), SkinPaintColor.WHITE);
    }

    @Nullable
    public BlockPaintColor getItemColors(ItemStack itemStack) {
        return ColorUtils.getBlockColor(itemStack);
    }
}

