/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.data.undo.action;

import java.util.HashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.api.action.IUserAction;
import moe.plushie.armourers_workshop.api.common.IPaintable;
import moe.plushie.armourers_workshop.api.skin.texture.ISkinPaintColor;
import moe.plushie.armourers_workshop.builder.data.undo.action.BlockUserAction;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SetBlockColorAction
extends BlockUserAction {
    private final Map<Direction, ISkinPaintColor> newValue;

    public SetBlockColorAction(Level level, BlockPos pos, Map<Direction, ISkinPaintColor> newValue) {
        super(level, pos);
        this.newValue = new HashMap<Direction, ISkinPaintColor>(newValue);
    }

    @Override
    public IUserAction apply() throws RuntimeException {
        IPaintable target = (IPaintable)this.getBlockEntity();
        HashMap<Direction, ISkinPaintColor> oldValue = new HashMap<Direction, ISkinPaintColor>();
        for (Direction direction : this.newValue.keySet()) {
            ISkinPaintColor paintColor = target.getColor(direction);
            if (paintColor == null) {
                paintColor = SkinPaintColor.CLEAR;
            }
            oldValue.put(direction, paintColor);
        }
        SetBlockColorAction revertAction = new SetBlockColorAction(this.level, this.blockPos, oldValue);
        target.setColors(this.newValue);
        return revertAction;
    }

    @Override
    public BlockEntity getBlockEntity() {
        BlockEntity blockEntity = super.getBlockEntity();
        if (blockEntity instanceof IPaintable) {
            return blockEntity;
        }
        return null;
    }
}

