/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.data.palette;

import java.util.Arrays;
import java.util.Objects;

public class Palette {
    public static final int MAX_COLORS_PER_PALETTE = 32;
    private final boolean locked;
    private String name;
    private final int[] colors;

    public Palette(String name, boolean locked, int[] colors) {
        this.name = name;
        this.locked = locked;
        this.colors = colors;
    }

    public Palette(String name) {
        this(name, false, new int[32]);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public int[] getColors() {
        return this.colors;
    }

    public void setColor(int index, int color) {
        this.colors[index] = color;
    }

    public int getColor(int index) {
        int color = this.colors[index];
        if (color != 0) {
            color |= 0xFF000000;
        }
        return color;
    }

    public String toString() {
        return "Palette [name=" + this.name + ", colors=" + Arrays.toString(this.colors) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Palette)) {
            return false;
        }
        Palette that = (Palette)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    protected Palette clone() {
        return new Palette(this.name, this.locked, (int[])this.colors.clone());
    }
}

