/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.render;

import com.apple.library.uikit.UIColor;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.builder.blockentity.AdvancedBuilderBlockEntity;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AdvancedAbstractGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AdvancedBackpackGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AdvancedBlockGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AdvancedBoatGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AdvancedHorseGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AdvancedHumanGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AdvancedItemGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AdvancedMinecartGuideRenderer;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBlockEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractBlockEntityRenderer;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.systems.RenderSystem.ModelView;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.model.ItemModel;
import moe.plushie.armourers_workshop.core.client.model.ItemModelManager;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderTesselator;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocument;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentSettings;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentType;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentTypes;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenItemDisplayContext;
import moe.plushie.armourers_workshop.core.utils.OpenItemTransforms;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedBuilderBlockRenderer<T extends AdvancedBuilderBlockEntity>
extends AbstractBlockEntityRenderer<T> {
    public static final float SCALE = 0.0625f;
    private static final Map<SkinDocumentType, AdvancedAbstractGuideRenderer> GUIDES = Collections.immutableMap(builder -> {
        builder.put((Object)SkinDocumentTypes.GENERAL_ARMOR_HEAD, (Object)new AdvancedHumanGuideRenderer());
        builder.put((Object)SkinDocumentTypes.GENERAL_ARMOR_CHEST, (Object)new AdvancedHumanGuideRenderer());
        builder.put((Object)SkinDocumentTypes.GENERAL_ARMOR_FEET, (Object)new AdvancedHumanGuideRenderer());
        builder.put((Object)SkinDocumentTypes.GENERAL_ARMOR_LEGS, (Object)new AdvancedHumanGuideRenderer());
        builder.put((Object)SkinDocumentTypes.GENERAL_ARMOR_WINGS, (Object)new AdvancedHumanGuideRenderer());
        builder.put((Object)SkinDocumentTypes.GENERAL_ARMOR_OUTFIT, (Object)new AdvancedHumanGuideRenderer());
        builder.put((Object)SkinDocumentTypes.ITEM, (Object)new AdvancedItemGuideRenderer());
        builder.put((Object)SkinDocumentTypes.ITEM_AXE, (Object)new AdvancedItemGuideRenderer());
        builder.put((Object)SkinDocumentTypes.ITEM_HOE, (Object)new AdvancedItemGuideRenderer());
        builder.put((Object)SkinDocumentTypes.ITEM_SHOVEL, (Object)new AdvancedItemGuideRenderer());
        builder.put((Object)SkinDocumentTypes.ITEM_PICKAXE, (Object)new AdvancedItemGuideRenderer());
        builder.put((Object)SkinDocumentTypes.ITEM_SWORD, (Object)new AdvancedItemGuideRenderer());
        builder.put((Object)SkinDocumentTypes.ITEM_SHIELD, (Object)new AdvancedItemGuideRenderer());
        builder.put((Object)SkinDocumentTypes.ITEM_BOW, (Object)new AdvancedItemGuideRenderer());
        builder.put((Object)SkinDocumentTypes.ITEM_TRIDENT, (Object)new AdvancedItemGuideRenderer());
        builder.put((Object)SkinDocumentTypes.ITEM_BACKPACK, (Object)new AdvancedBackpackGuideRenderer());
        builder.put((Object)SkinDocumentTypes.ENTITY_BOAT, (Object)new AdvancedBoatGuideRenderer());
        builder.put((Object)SkinDocumentTypes.ENTITY_MINECART, (Object)new AdvancedMinecartGuideRenderer());
        builder.put((Object)SkinDocumentTypes.ENTITY_HORSE, (Object)new AdvancedHorseGuideRenderer());
        builder.put((Object)SkinDocumentTypes.BLOCK, (Object)new AdvancedBlockGuideRenderer());
    });
    private static final Set<SkinType> USE_ITEM_TRANSFORMERS = Collections.immutableSet(builder -> {
        builder.add((Object)SkinTypes.ITEM);
        builder.add((Object)SkinTypes.ITEM_AXE);
        builder.add((Object)SkinTypes.ITEM_HOE);
        builder.add((Object)SkinTypes.ITEM_SHOVEL);
        builder.add((Object)SkinTypes.ITEM_PICKAXE);
        builder.add((Object)SkinTypes.ITEM_SWORD);
        builder.add((Object)SkinTypes.ITEM_SHIELD);
        builder.add((Object)SkinTypes.ITEM_BOW);
        builder.add((Object)SkinTypes.ITEM_TRIDENT);
    });
    public static ArrayList<OpenVector3f> OUTPUTS = new ArrayList();
    public static HashSet<BakedSkinPart> RESULTS = new HashSet();

    public static void setOutput(int i, OpenVector3f pt) {
        while (i >= OUTPUTS.size()) {
            OUTPUTS.add(OpenVector3f.ZERO);
        }
        OUTPUTS.set(i, pt);
    }

    public static void setResult(Collection<BakedSkinPart> results) {
        RESULTS.clear();
        RESULTS.addAll(results);
    }

    public AdvancedBuilderBlockRenderer(AbstractBlockEntityRendererProviderImpl.Context context) {
        super(context);
    }

    @Override
    public void render(T entity, float partialTicks, IPoseStack poseStack, IBufferSource bufferSource, int light, int overlay) {
        AdvancedAbstractGuideRenderer guideRenderer;
        poseStack.pushPose();
        poseStack.translate(((AdvancedBuilderBlockEntity)entity).offset.x(), ((AdvancedBuilderBlockEntity)entity).offset.y(), ((AdvancedBuilderBlockEntity)entity).offset.z());
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.scale(((AdvancedBuilderBlockEntity)entity).carmeScale.x(), ((AdvancedBuilderBlockEntity)entity).carmeScale.y(), ((AdvancedBuilderBlockEntity)entity).carmeScale.z());
        poseStack.scale(-0.0625f, -0.0625f, 0.0625f);
        SkinDocument document = ((AdvancedBuilderBlockEntity)entity).getDocument();
        SkinDocumentSettings settings = document.getSettings();
        if (settings.showsOrigin()) {
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            ShapeTesselator.vector(OpenVector3f.ZERO, 16.0f, poseStack, bufferSource);
            poseStack.scale(-1.0f, -1.0f, 1.0f);
        }
        if (settings.showsHelperModel() && (guideRenderer = GUIDES.get(document.getType())) != null) {
            guideRenderer.render(document, poseStack, light, overlay, bufferSource);
        }
        if (settings.showsHelperModel() && document.get(SkinProperty.OVERRIDE_ENTITY_SIZE).booleanValue()) {
            float width = (float)(document.get(SkinProperty.OVERRIDE_ENTITY_SIZE_WIDTH) * 16.0);
            float height = (float)(document.get(SkinProperty.OVERRIDE_ENTITY_SIZE_HEIGHT) * 16.0);
            float eyeHeight = (float)(document.get(SkinProperty.OVERRIDE_ENTITY_SIZE_EYE_HEIGHT) * 16.0);
            float radius = width / 2.0f;
            ShapeTesselator.stroke(-radius, 24.0f - height, -radius, radius, 24.0f, radius, UIColor.WHITE, poseStack, bufferSource);
            ShapeTesselator.stroke(-radius, 24.0f - eyeHeight, -radius, radius, 24.0f - eyeHeight, radius, UIColor.RED, poseStack, bufferSource);
        }
        if (USE_ITEM_TRANSFORMERS.contains(document.getType().getSkinType())) {
            this.applyTransform(poseStack, document.getType().getSkinType(), document.getItemTransforms());
        }
        BakedArmature armature = BakedArmature.defaultBy(document.getType().getSkinType());
        this.renderNode(document, document.getRoot(), armature, 0.0f, poseStack, bufferSource, light, overlay);
        poseStack.popPose();
        if (ModDebugger.advancedBuilder) {
            BlockState blockState = entity.m_58900_();
            BlockPos pos = entity.m_58899_();
            poseStack.pushPose();
            poseStack.translate(-pos.m_123341_(), -pos.m_123342_(), -pos.m_123343_());
            ShapeTesselator.stroke(((AdvancedBuilderBlockEntity)entity).getVisibleBox(blockState), UIColor.RED, poseStack, bufferSource);
            OpenVector3f origin = ((AdvancedBuilderBlockEntity)entity).getRenderOrigin();
            poseStack.translate(origin.x(), origin.y(), origin.z());
            ShapeTesselator.vector(OpenVector3f.ZERO, 1.0f, poseStack, bufferSource);
            poseStack.translate(((AdvancedBuilderBlockEntity)entity).carmeOffset.x(), ((AdvancedBuilderBlockEntity)entity).carmeOffset.y(), ((AdvancedBuilderBlockEntity)entity).carmeOffset.z());
            ShapeTesselator.vector(OpenVector3f.ZERO, 1.0f, poseStack, bufferSource);
            poseStack.popPose();
        }
    }

    protected void renderNode(SkinDocument document, SkinDocumentNode node, BakedArmature armature, float partialTicks, IPoseStack poseStack, IBufferSource bufferSource, int light, int overlay) {
        SkinDescriptor descriptor;
        SkinRenderTesselator tesselator;
        IJointTransform transform;
        if (!node.isEnabled()) {
            return;
        }
        poseStack.pushPose();
        if (armature != null && node.isLocked() && (transform = armature.getTransform(node.getType())) != null) {
            transform.apply(poseStack);
        }
        node.getTransform().apply(poseStack);
        if (node.isLocator()) {
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            ShapeTesselator.vector(OpenVector3f.ZERO, 16.0f, poseStack, bufferSource);
            poseStack.scale(-1.0f, -1.0f, 1.0f);
        }
        if ((tesselator = SkinRenderTesselator.create(descriptor = node.getSkin(), Tickets.RENDERER)) != null) {
            tesselator.setLightmap(0xF000F0);
            tesselator.setPartialTicks(partialTicks);
            tesselator.setAnimationTicks(0.0);
            tesselator.setPoseStack(poseStack);
            tesselator.setBufferSource(bufferSource);
            tesselator.setModelViewStack(AbstractPoseStack.create(ModelView.getExtendedModelViewStack(RenderSystem.class)));
            tesselator.draw();
        }
        for (SkinDocumentNode child : node.children()) {
            this.renderNode(document, child, armature, partialTicks, poseStack, bufferSource, light, overlay);
        }
        poseStack.popPose();
    }

    public void renderOutput(T entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int light, int overlay) {
        BlockPos pos = entity.m_58899_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)(-pos.m_123341_()), (float)(-pos.m_123342_()), (float)(-pos.m_123343_()));
        if (OUTPUTS.size() >= 2) {
            // empty if block
        }
        poseStack.m_85849_();
    }

    protected void applyTransform(IPoseStack poseStack, SkinType skinType, OpenItemTransforms itemTransforms) {
        OpenItemDisplayContext displayContext = OpenItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
        if (itemTransforms != null) {
            OpenTransform3f itemTransform = itemTransforms.get(displayContext);
            if (itemTransform != null) {
                poseStack.translate(0.0f, -2.0f, -2.0f);
                itemTransform.apply(poseStack);
            }
        } else {
            poseStack.translate(0.0f, -2.0f, -2.0f);
            ItemModel model = ItemModelManager.getInstance().getModel(skinType);
            model.getTransform(displayContext).apply(false, poseStack);
        }
    }

    public int m_142163_() {
        return 272;
    }

    public boolean shouldRenderOffScreen(T entity) {
        return true;
    }
}

