/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.widget;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.foundation.NSTextAlignment;
import com.apple.library.foundation.NSTextRange;
import com.apple.library.impl.InvokerResult;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UITextField;
import com.apple.library.uikit.UITextFieldDelegate;
import com.apple.library.uikit.UIView;
import com.apple.library.uikit.UIWindow;
import com.google.common.base.Objects;
import java.util.Optional;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.init.ModTextures;

public class NewSlider
extends UIControl
implements UITextFieldDelegate {
    private static final UIImage LEFT_ARROW_IMAGE = UIImage.of(ModTextures.LIST).uv(0.0f, 224.0f).fixed(8.0f, 8.0f).build();
    private static final UIImage RIGHT_ARROW_IMAGE = UIImage.of(ModTextures.LIST).uv(8.0f, 224.0f).fixed(8.0f, 8.0f).build();
    private static final UIImage NORMAL_IMAGE = UIImage.of(ModTextures.ADVANCED_SKIN_BUILDER).uv(28.0f, 28.0f).resizable(16.0f, 16.0f).build();
    private static final UIImage FOCUSED_IMAGE = UIImage.of(ModTextures.ADVANCED_SKIN_BUILDER).uv(52.0f, 28.0f).resizable(16.0f, 16.0f).build();
    private static final UIImage HIGHLIGHTED_IMAGE = UIImage.of(ModTextures.ADVANCED_SKIN_BUILDER).uv(76.0f, 28.0f).resizable(16.0f, 16.0f).build();
    private static final UIImage EDITING_IMAGE = UIImage.of(ModTextures.ADVANCED_SKIN_BUILDER).uv(100.0f, 28.0f).resizable(16.0f, 16.0f).build();
    protected final UIButton leftView = new UIButton(CGRect.ZERO);
    protected final UIButton rightView = new UIButton(CGRect.ZERO);
    protected final UIButton contentView = new UIButton(CGRect.ZERO);
    protected final UILabel valueView = new UILabel(CGRect.ZERO);
    protected final UITextField valueInputView = new UITextField(CGRect.ZERO);
    protected double value = 1.0;
    protected double minValue = Double.NEGATIVE_INFINITY;
    protected double maxValue = Double.POSITIVE_INFINITY;
    protected double stepValue = 0.01;
    private float multipler = 1.0f;
    private Formatter formatter = Formatter.DEFAULT;
    private boolean isEditing = false;
    private boolean isChangedValue = false;
    private CGPoint startDragLocation = null;

    public NewSlider(CGRect frame) {
        super(frame);
        this.setContents(NORMAL_IMAGE);
        this.addSubview(this.leftView);
        this.addSubview(this.contentView);
        this.addSubview(this.rightView);
        this.setup(this.leftView, LEFT_ARROW_IMAGE);
        this.setup(this.contentView, null);
        this.setup(this.rightView, RIGHT_ARROW_IMAGE);
        this.valueInputView.setAutoresizingMask(18);
        this.valueInputView.setContents(EDITING_IMAGE);
        this.valueInputView.setDelegate(this);
        this.valueInputView.setBordered(false);
        this.valueView.setFrame(this.bounds());
        this.valueView.setAutoresizingMask(18);
        this.valueView.setTextColor(UIColor.WHITE);
        this.valueView.setTextHorizontalAlignment(NSTextAlignment.Horizontal.CENTER);
        this.addSubview(this.valueView);
        this.update(1.0);
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        CGRect rect = this.bounds();
        float height = rect.height;
        float width = height * 3.0f / 4.0f;
        this.leftView.setFrame(new CGRect(0.0f, 0.0f, width, height));
        this.rightView.setFrame(new CGRect(rect.width - width, 0.0f, width, height));
        this.contentView.setFrame(new CGRect(width, 0.0f, rect.width - width * 2.0f, height));
    }

    @Override
    public boolean shouldBecomeFocused(UIView subview) {
        return false;
    }

    @Override
    public boolean canBecomeFocused() {
        return true;
    }

    @Override
    public void becomeFirstResponder() {
        this.inputBegin();
    }

    @Override
    public void resignFirstResponder() {
        this.valueInputView.resignFirstResponder();
    }

    @Override
    public void textFieldDidBeginEditing(UITextField textField) {
        this.updateEditing(true);
        this.leftView.setHidden(true);
        this.contentView.setHidden(true);
        this.rightView.setHidden(true);
        this.valueView.setHidden(true);
    }

    @Override
    public void textFieldDidEndEditing(UITextField textField) {
        this.valueView.setHidden(false);
        this.leftView.setHidden(false);
        this.contentView.setHidden(false);
        this.rightView.setHidden(false);
        this.inputEnd();
        this.updateEditing(false);
    }

    @Override
    public boolean textFieldShouldReturn(UITextField textField) {
        this.inputEnd();
        return true;
    }

    public double value() {
        return this.value;
    }

    public void setValue(double value) {
        this.update(value);
    }

    public double maxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
        this.update(this.value);
    }

    public double minValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
        this.update(this.value);
    }

    public double stepValue() {
        return this.stepValue;
    }

    public void setStepValue(double stepValue) {
        this.stepValue = stepValue;
    }

    public float multipler() {
        return this.multipler;
    }

    public void setMultipler(float multipler) {
        this.multipler = multipler;
    }

    public Formatter formatter() {
        return this.formatter;
    }

    public void setFormatter(Formatter formatter) {
        this.formatter = formatter;
    }

    private void setup(UIButton view, UIImage arrow) {
        view.setImage(arrow, 1);
        view.setImage(arrow, 2);
        view.setImage(arrow, 4);
        view.setBackgroundImage(NORMAL_IMAGE, 0);
        view.setBackgroundImage(HIGHLIGHTED_IMAGE, 1);
        view.setBackgroundImage(FOCUSED_IMAGE, 2);
        view.setBackgroundImage(HIGHLIGHTED_IMAGE, 3);
        view.setBackgroundImage(EDITING_IMAGE, 4);
        view.addTarget(this, UIControl.Event.MOUSE_ENTERED, NewSlider::buttonEnter);
        view.addTarget(this, UIControl.Event.MOUSE_EXITED, NewSlider::buttonExit);
        view.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, NewSlider::buttonDown);
    }

    private void buttonEnter(UIControl sender) {
        this.leftView.setSelected(true);
        this.contentView.setSelected(true);
        this.rightView.setSelected(true);
    }

    private void buttonExit(UIControl sender) {
        this.leftView.setSelected(false);
        this.contentView.setSelected(false);
        this.rightView.setSelected(false);
    }

    private void buttonDown(UIControl sender) {
        UIWindow window = this.window();
        if (window == null) {
            return;
        }
        window.addGlobalTarget(this, UIControl.Event.MOUSE_MOVED, NewSlider::buttonMove);
        window.addGlobalTarget(this, UIControl.Event.MOUSE_LEFT_UP, NewSlider::buttonUp);
        this.leftView.setEnabled(false);
        this.contentView.setEnabled(false);
        this.rightView.setEnabled(false);
        this.isChangedValue = false;
        this.startDragLocation = null;
        this.updateEditing(true);
    }

    private void buttonMove(UIEvent event) {
        event.cancel(InvokerResult.SUCCESS);
        CGPoint location = event.locationInWindow();
        if (this.startDragLocation == null) {
            this.startDragLocation = location.copy();
            return;
        }
        float dx = Math.round((location.x - this.startDragLocation.x) * this.multipler);
        if (dx == 0.0f) {
            return;
        }
        this.update(this.value + (double)dx * this.stepValue);
        this.sendEvent(UIControl.Event.VALUE_CHANGED);
        this.startDragLocation.x += dx / this.multipler;
        this.isChangedValue = true;
    }

    private void buttonUp(UIEvent event) {
        UIWindow window = this.window();
        if (window == null) {
            return;
        }
        window.removeGlobalTarget(this, UIControl.Event.MOUSE_MOVED);
        window.removeGlobalTarget(this, UIControl.Event.MOUSE_LEFT_UP);
        this.leftView.setEnabled(true);
        this.contentView.setEnabled(true);
        this.rightView.setEnabled(true);
        if (this.isChangedValue) {
            this.updateEditing(false);
            return;
        }
        UIView view = this.hitTest(event.locationInView(this), event);
        if (view == this.leftView) {
            this.update(this.value - this.stepValue);
            this.sendEvent(UIControl.Event.VALUE_CHANGED);
            this.updateEditing(false);
            return;
        }
        if (view == this.rightView) {
            this.update(this.value + this.stepValue);
            this.sendEvent(UIControl.Event.VALUE_CHANGED);
            this.updateEditing(false);
            return;
        }
        this.inputBegin();
    }

    private void inputDown(UIEvent event) {
        this.inputMove(event);
        if (event.isCancelled()) {
            this.inputEnd();
        }
    }

    private void inputMove(UIEvent event) {
        if (!this.pointInside(event.locationInView(this.valueInputView), event)) {
            event.cancel(InvokerResult.SUCCESS);
        }
    }

    private void inputBegin() {
        UIWindow window = this.window();
        if (window == null) {
            return;
        }
        this.valueInputView.setFrame(this.bounds());
        this.valueInputView.setSelectedTextRange(new NSTextRange(this.valueInputView.beginOfDocument(), this.valueInputView.endOfDocument()));
        this.addSubview(this.valueInputView);
        this.valueInputView.becomeFirstResponder();
        window.addGlobalTarget(this, UIControl.Event.MOUSE_MOVED, NewSlider::inputMove);
        window.addGlobalTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, NewSlider::inputDown);
    }

    private void inputEnd() {
        UIWindow window = this.window();
        if (window == null) {
            return;
        }
        window.removeGlobalTarget(this, UIControl.Event.MOUSE_LEFT_DOWN);
        window.removeGlobalTarget(this, UIControl.Event.MOUSE_MOVED);
        Optional<Double> newValue = this.formatter.parse(this.valueInputView.text());
        this.update(newValue.orElse(this.value));
        this.sendEvent(UIControl.Event.VALUE_CHANGED);
        this.valueInputView.resignFirstResponder();
        this.valueInputView.removeFromSuperview();
    }

    private void update(double newValue) {
        if (Math.abs(newValue) < 1.0E-6) {
            newValue = 0.0;
        }
        this.value = OpenMath.clamp(newValue, this.minValue, this.maxValue);
        this.valueView.setText(new NSString(this.formatter.display(this.value)));
        this.valueInputView.setText(this.formatter.input(this.value));
    }

    private void updateEditing(boolean value) {
        if (Objects.equal((Object)this.isEditing, (Object)value)) {
            return;
        }
        this.isEditing = value;
        if (value) {
            this.sendEvent(UIControl.Event.EDITING_DID_BEGIN);
        } else {
            this.sendEvent(UIControl.Event.EDITING_DID_END);
        }
    }

    public static interface Formatter {
        public static final Formatter DEFAULT = new Formatter(){

            @Override
            public String display(double input) {
                return String.format("%.3f", input);
            }

            @Override
            public Optional<Double> parse(String input) {
                try {
                    return Optional.of(Double.parseDouble(input));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return Optional.empty();
                }
            }
        };

        public String display(double var1);

        public Optional<Double> parse(String var1);

        default public String input(double value) {
            return this.display(value);
        }
    }
}

