/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.armourer;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.common.IItemColorProvider;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.ArmourerBaseSetting;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.dialog.ArmourerClearDialog;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.dialog.ArmourerCopyDialog;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.dialog.ArmourerReplaceDialog;
import moe.plushie.armourers_workshop.builder.menu.ArmourerMenu;
import moe.plushie.armourers_workshop.builder.network.UpdateArmourerPacket;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.Constructor;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArmourerBlockSetting
extends ArmourerBaseSetting {
    protected final ArmourerBlockEntity blockEntity;

    protected ArmourerBlockSetting(ArmourerMenu container) {
        super("armourer.blockUtils");
        this.blockEntity = (ArmourerBlockEntity)container.getBlockEntity();
    }

    @Override
    public void init() {
        super.init();
        UIButton clearBtn = new UIButton(new CGRect(10.0f, 20.0f, 70.0f, 20.0f));
        clearBtn.setTitle(this.getDisplayText("clear", new Object[0]), 7);
        clearBtn.setTitleColor(UIColor.WHITE, 7);
        clearBtn.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        clearBtn.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, ArmourerBlockSetting::clearAction);
        this.addSubview(clearBtn);
        UIButton copyBtn = new UIButton(new CGRect(10.0f, 45.0f, 70.0f, 20.0f));
        copyBtn.setTitle(this.getDisplayText("copy", new Object[0]), 7);
        copyBtn.setTitleColor(UIColor.WHITE, 7);
        copyBtn.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        copyBtn.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, ArmourerBlockSetting::copyAction);
        this.addSubview(copyBtn);
        UIButton replaceBtn = new UIButton(new CGRect(10.0f, 70.0f, 70.0f, 20.0f));
        replaceBtn.setTitle(this.getDisplayText("replace", new Object[0]), 7);
        replaceBtn.setTitleColor(UIColor.WHITE, 7);
        replaceBtn.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        replaceBtn.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, ArmourerBlockSetting::replaceAction);
        this.addSubview(replaceBtn);
    }

    private void clearAction(UIControl sender) {
        ArmourerClearDialog dialog = new ArmourerClearDialog(this.getPartTypes(true));
        dialog.setTitle(NSString.localizedString("armourer.dialog.clear.title", new Object[0]));
        dialog.showInView(this, () -> {
            if (dialog.isCancelled()) {
                return;
            }
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("Cubes", dialog.isClearBlocks());
            nbt.m_128379_("Paints", dialog.isClearPaints());
            nbt.m_128379_("Markers", dialog.isClearMarkers());
            nbt.m_128359_("PartType", dialog.getSelectedPartType().getRegistryName().toString());
            NetworkManager.sendToServer(UpdateArmourerPacket.Field.ITEM_CLEAR.buildPacket(this.blockEntity, nbt));
        });
    }

    private void copyAction(UIControl sender) {
        ArmourerCopyDialog dialog = new ArmourerCopyDialog(this.getPartTypes(false));
        dialog.setTitle(NSString.localizedString("armourer.dialog.copy.title", new Object[0]));
        dialog.showInView(this, () -> {
            if (dialog.isCancelled()) {
                return;
            }
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("Mirror", dialog.isMirror());
            nbt.m_128379_("Paints", dialog.isCopyPaintData());
            nbt.m_128359_("Source", dialog.getSourcePartType().getRegistryName().toString());
            nbt.m_128359_("Destination", dialog.getDestinationPartType().getRegistryName().toString());
            NetworkManager.sendToServer(UpdateArmourerPacket.Field.ITEM_COPY.buildPacket(this.blockEntity, nbt));
        });
    }

    private void replaceAction(UIControl sender) {
        ArmourerReplaceDialog dialog = new ArmourerReplaceDialog();
        dialog.setTitle(NSString.localizedString("armourer.dialog.replace.title", new Object[0]));
        dialog.showInView(this, () -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (dialog.isCancelled() || level == null) {
                return;
            }
            CompoundTag source = new CompoundTag();
            ItemStack selector = dialog.getSelector();
            if (selector.m_41720_() instanceof IItemColorProvider) {
                Constructor.save(selector, level.m_9598_(), source);
            }
            CompoundTag destination = new CompoundTag();
            ItemStack applier = dialog.getApplier();
            if (applier.m_41720_() instanceof IItemColorProvider) {
                Constructor.save(applier, level.m_9598_(), destination);
            }
            if (source.m_128456_() && destination.m_128456_()) {
                return;
            }
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("Source", (Tag)source);
            nbt.m_128365_("Destination", (Tag)destination);
            nbt.m_128379_("KeepColor", dialog.isKeepColor());
            nbt.m_128379_("KeepPaintType", dialog.isKeepPaintType());
            NetworkManager.sendToServer(UpdateArmourerPacket.Field.ITEM_REPLACE.buildPacket(this.blockEntity, nbt));
        });
    }

    public ArrayList<SkinPartType> getPartTypes(boolean usesAll) {
        SkinType skinType = this.blockEntity.getSkinType();
        SkinProperties skinProperties = this.blockEntity.getSkinProperties();
        ArrayList<SkinPartType> partTypes = new ArrayList<SkinPartType>();
        if (usesAll) {
            partTypes.add(0, SkinPartTypes.UNKNOWN);
        }
        if (skinType != SkinTypes.BLOCK) {
            partTypes.addAll(skinType.getParts());
        } else if (skinProperties.get(SkinProperty.BLOCK_MULTIBLOCK).booleanValue()) {
            partTypes.add(SkinPartTypes.BLOCK_MULTI);
        } else {
            partTypes.add(SkinPartTypes.BLOCK);
        }
        return partTypes;
    }
}

