/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.panel;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIScrollView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document.DocumentEditor;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.panel.AdvancedPanel;
import moe.plushie.armourers_workshop.builder.client.gui.widget.PropertySettingView;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.init.ModTextures;

public class AdvancedSettingPanel
extends AdvancedPanel {
    private static final Map<SkinType, Collection<SkinProperty<?>>> VALUES = Collections.immutableMap(builder -> {
        builder.put((Object)SkinTypes.OUTFIT, Collections.newList(SkinProperty.OVERRIDE_MODEL_HEAD, SkinProperty.OVERRIDE_MODEL_CHEST, SkinProperty.OVERRIDE_MODEL_LEFT_ARM, SkinProperty.OVERRIDE_MODEL_RIGHT_ARM, SkinProperty.OVERRIDE_MODEL_LEFT_LEG, SkinProperty.OVERRIDE_MODEL_RIGHT_LEG, SkinProperty.OVERRIDE_OVERLAY_HAT, SkinProperty.OVERRIDE_OVERLAY_CLOAK, SkinProperty.OVERRIDE_OVERLAY_JACKET, SkinProperty.OVERRIDE_OVERLAY_LEFT_SLEEVE, SkinProperty.OVERRIDE_OVERLAY_RIGHT_SLEEVE, SkinProperty.OVERRIDE_OVERLAY_LEFT_PANTS, SkinProperty.OVERRIDE_OVERLAY_RIGHT_PANTS, SkinProperty.OVERRIDE_EQUIPMENT_BOOTS, SkinProperty.OVERRIDE_EQUIPMENT_CHESTPLATE, SkinProperty.OVERRIDE_EQUIPMENT_HELMET, SkinProperty.OVERRIDE_EQUIPMENT_LEGGINGS, SkinProperty.LIMIT_LEGS_LIMBS, SkinProperty.USE_OVERLAY_COLOR, SkinProperty.OVERRIDE_ENTITY_SIZE, SkinProperty.OVERRIDE_ENTITY_SIZE_WIDTH, SkinProperty.OVERRIDE_ENTITY_SIZE_HEIGHT, SkinProperty.OVERRIDE_ENTITY_SIZE_EYE_HEIGHT));
        builder.put((Object)SkinTypes.ARMOR_HEAD, Collections.newList(SkinProperty.OVERRIDE_MODEL_HEAD, SkinProperty.OVERRIDE_OVERLAY_HAT, SkinProperty.OVERRIDE_EQUIPMENT_HELMET, SkinProperty.USE_OVERLAY_COLOR));
        builder.put((Object)SkinTypes.ARMOR_CHEST, Collections.newList(SkinProperty.OVERRIDE_MODEL_CHEST, SkinProperty.OVERRIDE_MODEL_LEFT_ARM, SkinProperty.OVERRIDE_MODEL_RIGHT_ARM, SkinProperty.OVERRIDE_OVERLAY_CLOAK, SkinProperty.OVERRIDE_OVERLAY_JACKET, SkinProperty.OVERRIDE_OVERLAY_LEFT_SLEEVE, SkinProperty.OVERRIDE_OVERLAY_RIGHT_SLEEVE, SkinProperty.OVERRIDE_EQUIPMENT_CHESTPLATE, SkinProperty.USE_OVERLAY_COLOR));
        builder.put((Object)SkinTypes.ARMOR_FEET, Collections.newList(SkinProperty.OVERRIDE_MODEL_LEFT_LEG, SkinProperty.OVERRIDE_MODEL_RIGHT_LEG, SkinProperty.OVERRIDE_OVERLAY_LEFT_PANTS, SkinProperty.OVERRIDE_OVERLAY_RIGHT_PANTS, SkinProperty.OVERRIDE_EQUIPMENT_LEGGINGS, SkinProperty.USE_OVERLAY_COLOR));
        builder.put((Object)SkinTypes.ARMOR_LEGS, Collections.newList(SkinProperty.OVERRIDE_MODEL_LEFT_LEG, SkinProperty.OVERRIDE_MODEL_RIGHT_LEG, SkinProperty.OVERRIDE_OVERLAY_LEFT_PANTS, SkinProperty.OVERRIDE_OVERLAY_RIGHT_PANTS, SkinProperty.OVERRIDE_EQUIPMENT_BOOTS, SkinProperty.LIMIT_LEGS_LIMBS, SkinProperty.USE_OVERLAY_COLOR));
        builder.put((Object)SkinTypes.ARMOR_WINGS, Collections.newList(SkinProperty.USE_OVERLAY_COLOR));
        builder.put((Object)SkinTypes.ITEM_SWORD, Collections.newList(new SkinProperty[0]));
        builder.put((Object)SkinTypes.ITEM_SHIELD, Collections.newList(new SkinProperty[0]));
        builder.put((Object)SkinTypes.ITEM_BOW, Collections.newList(new SkinProperty[0]));
        builder.put((Object)SkinTypes.ITEM_TRIDENT, Collections.newList(new SkinProperty[0]));
        builder.put((Object)SkinTypes.ITEM_PICKAXE, Collections.newList(new SkinProperty[0]));
        builder.put((Object)SkinTypes.ITEM_AXE, Collections.newList(new SkinProperty[0]));
        builder.put((Object)SkinTypes.ITEM_SHOVEL, Collections.newList(new SkinProperty[0]));
        builder.put((Object)SkinTypes.ITEM_HOE, Collections.newList(new SkinProperty[0]));
        builder.put((Object)SkinTypes.BLOCK, Collections.newList(SkinProperty.BLOCK_GLOWING, SkinProperty.BLOCK_LADDER, SkinProperty.BLOCK_NO_COLLISION, SkinProperty.BLOCK_SEAT, SkinProperty.BLOCK_MULTIBLOCK, SkinProperty.BLOCK_BED, SkinProperty.BLOCK_ENDER_INVENTORY, SkinProperty.BLOCK_INVENTORY, SkinProperty.BLOCK_INVENTORY_WIDTH, SkinProperty.BLOCK_INVENTORY_HEIGHT));
        builder.put((Object)SkinTypes.HORSE, Collections.newList(SkinProperty.OVERRIDE_MODEL_HEAD, SkinProperty.OVERRIDE_MODEL_CHEST, SkinProperty.OVERRIDE_MODEL_LEFT_FRONT_LEG, SkinProperty.OVERRIDE_MODEL_RIGHT_FRONT_LEG, SkinProperty.OVERRIDE_MODEL_LEFT_HIND_LEG, SkinProperty.OVERRIDE_MODEL_RIGHT_HIND_LEG, SkinProperty.OVERRIDE_MODEL_TAIL, SkinProperty.OVERRIDE_EQUIPMENT_CHESTPLATE, SkinProperty.USE_OVERLAY_COLOR, SkinProperty.OVERRIDE_ENTITY_SIZE, SkinProperty.OVERRIDE_ENTITY_SIZE_WIDTH, SkinProperty.OVERRIDE_ENTITY_SIZE_HEIGHT, SkinProperty.OVERRIDE_ENTITY_SIZE_EYE_HEIGHT));
        builder.put((Object)SkinTypes.MINECART, Collections.newList(SkinProperty.USE_OVERLAY_COLOR, SkinProperty.OVERRIDE_ENTITY_SIZE, SkinProperty.OVERRIDE_ENTITY_SIZE_WIDTH, SkinProperty.OVERRIDE_ENTITY_SIZE_HEIGHT, SkinProperty.OVERRIDE_ENTITY_SIZE_EYE_HEIGHT));
        builder.put((Object)SkinTypes.BOAT, Collections.newList(SkinProperty.USE_OVERLAY_COLOR, SkinProperty.OVERRIDE_ENTITY_SIZE, SkinProperty.OVERRIDE_ENTITY_SIZE_WIDTH, SkinProperty.OVERRIDE_ENTITY_SIZE_HEIGHT, SkinProperty.OVERRIDE_ENTITY_SIZE_EYE_HEIGHT));
    });
    private SkinProperties properties;
    private final ArrayList<UICheckBox> boxes = new ArrayList();
    private PropertySettingView settingView;
    private final UIScrollView scrollView = new UIScrollView(CGRect.ZERO);
    private CGSize cachedSize = CGSize.ZERO;

    public AdvancedSettingPanel(DocumentEditor editor) {
        super(editor);
        this.barItem.setImage(UIImage.of(ModTextures.TAB_ICONS).uv(208.0f, 0.0f).fixed(16.0f, 16.0f).build());
        this.setup();
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        CGSize size = this.bounds().size();
        if (this.settingView != null && !this.cachedSize.equals(size)) {
            CGRect rect = this.settingView.frame().copy();
            rect.setWidth(size.width - 20.0f);
            this.settingView.setFrame(rect);
            this.cachedSize = size;
        }
    }

    private void setup() {
        this.scrollView.setFrame(this.bounds());
        this.scrollView.setAutoresizingMask(18);
        this.insertViewAtIndex(this.scrollView, 0);
        this.editor.getConnector().addListener(this::update);
    }

    private void update(SkinDocumentNode node) {
        if (this.properties == this.document.getProperties()) {
            return;
        }
        this.properties = this.document.getProperties();
        this.addProperties(this.document.getType().getSkinType());
    }

    private void addProperties(SkinType skinType) {
        if (this.settingView != null) {
            this.settingView.removeFromSuperview();
        }
        CGRect rect = this.scrollView.frame();
        Collection<SkinProperty<?>> properties = VALUES.get(skinType);
        if (properties == null || properties.isEmpty()) {
            return;
        }
        this.settingView = new PropertySettingView(new CGRect(10.0f, 10.0f, rect.width - 20.0f, 0.0f), properties){

            @Override
            public void beginEditing() {
                AdvancedSettingPanel.this.editor.beginEditing();
            }

            @Override
            public <T> void putValue(SkinProperty<T> property, T value) {
                AdvancedSettingPanel.this.document.put(property, value);
            }

            @Override
            public <T> T getValue(SkinProperty<T> property) {
                return AdvancedSettingPanel.this.document.get(property);
            }

            @Override
            public void endEditing() {
                AdvancedSettingPanel.this.editor.endEditing();
            }
        };
        this.scrollView.addSubview(this.settingView);
        this.scrollView.setContentSize(new CGSize(0.0f, this.settingView.frame().maxY() + 10.0f));
    }
}

