/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.panel;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSMutableString;
import com.apple.library.foundation.NSString;
import com.apple.library.foundation.NSTextAlignment;
import com.apple.library.uikit.UIBarItem;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIEdgeInsets;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UIView;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document.DocumentEditor;
import moe.plushie.armourers_workshop.builder.client.gui.widget.NewSlider;
import moe.plushie.armourers_workshop.builder.data.properties.DataProperty;
import moe.plushie.armourers_workshop.builder.data.properties.Vector3fProperty;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocument;
import moe.plushie.armourers_workshop.init.ModTextures;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public abstract class AdvancedPanel
extends UIView {
    protected ArrayList<Section> sections = new ArrayList();
    protected UIBarItem barItem = new UIBarItem();
    protected final SkinDocument document;
    protected final DocumentEditor editor;

    public AdvancedPanel(DocumentEditor editor) {
        super(CGRect.ZERO);
        this.document = editor.getDocument();
        this.editor = editor;
    }

    @Override
    public void sizeToFit() {
        CGRect bounds = this.bounds();
        UIEdgeInsets edge = new UIEdgeInsets(8.0f, 8.0f, 8.0f, 8.0f);
        float width = bounds.width - edge.left - edge.right;
        float top = edge.top;
        float left = bounds.width * 0.4f;
        for (Section section : this.sections) {
            float h = section.layout(4.0f, left, left + 4.0f, width - 4.0f - 4.0f, 2.0f);
            section.setFrame(new CGRect(edge.left, top + section.headerSize(), width, h));
            section.setAutoresizingMask(34);
            top += section.headerSize() + h + section.footerSize();
        }
        this.setBounds(new CGRect(0.0f, 0.0f, bounds.width, top + edge.bottom));
    }

    @Override
    public CGSize sizeThatFits(CGSize size) {
        this.setBounds(new CGRect(0.0f, 0.0f, size.width, size.height));
        this.sizeToFit();
        return this.bounds().size();
    }

    public UIBarItem barItem() {
        return this.barItem;
    }

    protected NSString translatable(String key) {
        return new NSString(key);
    }

    protected void addGroup(NSString name, Consumer<Group> builder) {
        Group group = new Group(this.editor, name);
        builder.accept(group);
        this.addSection(group);
    }

    protected void addContent(UIView contentView) {
        this.addSection(new Content(contentView));
    }

    protected void addSection(Section section) {
        this.addSubview(section);
        this.sections.add(section);
    }

    public static abstract class Section
    extends UIView {
        public Section(CGRect frame) {
            super(frame);
        }

        public abstract float layout(float var1, float var2, float var3, float var4, float var5);

        public float headerSize() {
            return 0.0f;
        }

        public float footerSize() {
            return 4.0f;
        }
    }

    public static class Group
    extends Section {
        protected final UILabel titleView = new UILabel(CGRect.ZERO);
        protected final ArrayList<Pair<UIView, UIView>> lines = new ArrayList();

        public Group(DocumentEditor editor, NSString name) {
            super(CGRect.ZERO);
            this.titleView.setText(name);
            this.titleView.setTextColor(UIColor.WHITE);
            this.titleView.setFrame(new CGRect(8.0f, 4.0f, this.bounds().width(), 10.0f));
            this.titleView.setAutoresizingMask(34);
            this.setContents(UIImage.of(ModTextures.ADVANCED_SKIN_BUILDER).uv(24.0f, 24.0f).fixed(24.0f, 24.0f).clip(4.0f, 4.0f, 4.0f, 4.0f).build());
            this.addSubview(this.titleView);
        }

        @Override
        public float layout(float x0, float x1, float x2, float x3, float spacing) {
            float top = this.titleView.frame().maxY() + 4.0f + spacing;
            for (Pair<UIView, UIView> it : this.lines) {
                UIView rightView = (UIView)it.getValue();
                CGRect rightFrame = rightView.frame().copy();
                UIView leftView = (UIView)it.getLeft();
                float height = rightFrame.height;
                if (leftView != null) {
                    CGRect leftFrame = leftView.frame().copy();
                    height = Math.max(height, leftFrame.height);
                    leftFrame.x = x0;
                    leftFrame.y = top + (height - leftFrame.height) / 2.0f;
                    leftFrame.width = x1 - x0;
                    leftView.setFrame(leftFrame);
                    leftView.setAutoresizingMask(36);
                }
                rightFrame.x = x2;
                rightFrame.y = top + (height - rightFrame.height) / 2.0f;
                rightFrame.width = x3 - x2;
                rightView.setFrame(rightFrame);
                rightView.setAutoresizingMask(34);
                top += height + spacing;
            }
            return (top += 4.0f) - spacing;
        }

        public void bool(@Nullable NSString name, DataProperty<Boolean> property) {
            this.bool(name, null, property);
        }

        public void bool(@Nullable NSString name, @Nullable NSString desc, DataProperty<Boolean> property) {
            UICheckBox box = new UICheckBox(new CGRect(0.0f, 0.0f, 80.0f, 16.0f));
            box.setTitle(desc);
            box.addTarget(property, UIControl.Event.VALUE_CHANGED, (pro, ctrl) -> {
                UICheckBox checkBox = (UICheckBox)ctrl;
                pro.set(checkBox.isSelected());
            });
            property.addObserver(box::setSelected);
            this.addRow(name, box);
        }

        public void slider(@Nullable NSString name, DataProperty<Float> property, Unit unit) {
            NewSlider view = new NewSlider(new CGRect(0.0f, 0.0f, 80.0f, 16.0f));
            view.setFormatter(unit);
            view.setStepValue(unit.stepValue);
            view.setValue(unit.defaultValue);
            view.setMultipler(unit.multipler);
            view.addTarget(property, UIControl.Event.EDITING_DID_BEGIN, (pro, ctrl) -> pro.beginEditing());
            view.addTarget(property, UIControl.Event.EDITING_DID_END, (pro, ctrl) -> pro.endEditing());
            view.addTarget(property, UIControl.Event.VALUE_CHANGED, (pro, ctrl) -> {
                NewSlider slider = (NewSlider)ctrl;
                pro.set(Float.valueOf((float)slider.value()));
            });
            property.addObserver(view::setValue);
            this.addRow(name, view);
        }

        public void vector(NSString name, Vector3fProperty property, Unit unit) {
            NSMutableString name1 = new NSMutableString(name);
            name1.append(" ");
            name1.append("X");
            this.slider(name1, property.x(), unit);
            this.slider(new NSString("Y"), property.y(), unit);
            this.slider(new NSString("Z"), property.z(), unit);
        }

        private void addRow(@Nullable NSString name, UIView view) {
            if (name == null) {
                this.addView(null, view);
                return;
            }
            UILabel title = new UILabel(new CGRect(0.0f, 0.0f, 30.0f, 10.0f));
            title.setText(name);
            title.setTextColor(UIColor.WHITE);
            title.setTextHorizontalAlignment(NSTextAlignment.Horizontal.RIGHT);
            this.addView(title, view);
        }

        private void addView(@Nullable UIView leftView, UIView rightView) {
            this.lines.add((Pair<UIView, UIView>)Pair.of((Object)leftView, (Object)rightView));
            if (leftView != null) {
                this.addSubview(leftView);
            }
            this.addSubview(rightView);
        }

        public static enum Unit implements NewSlider.Formatter
        {
            POINT("#.####", "#.#####", 0.0, 0.01, 1.0f),
            DEGREES("#.#\u00b0", "#.#####", 0.0, 0.1, 10.0f),
            SCALE("0.000", "0.0####", 1.0, 0.01, 1.0f);

            public final double stepValue;
            public final double defaultValue;
            public final float multipler;
            public final DecimalFormat inputFormat;
            public final DecimalFormat displayFormat;

            private Unit(String displayFormat, String inputFormat, double defaultValue, double stepValue, float multipler) {
                this.stepValue = stepValue;
                this.defaultValue = defaultValue;
                this.multipler = multipler;
                this.displayFormat = new DecimalFormat(displayFormat);
                this.inputFormat = new DecimalFormat(inputFormat);
            }

            @Override
            public String display(double value) {
                return this.displayFormat.format(value);
            }

            @Override
            public String input(double value) {
                return this.inputFormat.format(value);
            }

            @Override
            public Optional<Double> parse(String value) {
                try {
                    return Optional.of(this.inputFormat.parse(value).doubleValue());
                }
                catch (Exception e) {
                    return Optional.empty();
                }
            }
        }
    }

    public static class Content
    extends Section {
        protected final UIView contentView;

        public Content(UIView contentView) {
            super(contentView.bounds());
            this.contentView = contentView;
            this.contentView.setFrame(this.bounds());
            this.contentView.setAutoresizingMask(18);
            this.addSubview(contentView);
        }

        @Override
        public float layout(float x0, float x1, float x2, float x3, float spacing) {
            return this.contentView.bounds().height();
        }

        @Override
        public float footerSize() {
            return 8.0f;
        }
    }
}

