/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide;

import moe.plushie.armourers_workshop.api.armature.IJoint;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.api.core.math.IRectangle3f;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AdvancedAbstractGuideRenderer;
import moe.plushie.armourers_workshop.core.armature.Armature;
import moe.plushie.armourers_workshop.core.armature.JointShape;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.math.OpenRectangle2f;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.skin.geometry.cube.SkinCubeFace;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocument;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureData;
import moe.plushie.armourers_workshop.core.utils.ColorUtils;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AdvancedEntityGuideRenderer
extends AdvancedAbstractGuideRenderer {
    protected final BakedArmature armature = this.getArmature();
    protected final SkinTextureData texture = this.getTexture();
    protected final RenderType renderType = this.getRenderType(this.texture);

    public abstract SkinTextureData getTexture();

    public abstract BakedArmature getArmature();

    public RenderType getRenderType(SkinTextureData texture) {
        return SkinRenderType.entityCutoutNoCull(OpenResourceLocation.parse(texture.getName()));
    }

    public void applyOffset(SkinDocument document, IPoseStack poseStack) {
    }

    @Override
    public void render(SkinDocument document, IPoseStack poseStack, int light, int overlay, IBufferSource bufferSource) {
        poseStack.pushPose();
        this.applyOffset(document, poseStack);
        IJointTransform[] transforms = this.armature.getTransforms();
        Armature armature1 = this.armature.getArmature();
        for (IJoint joint : armature1.allJoints()) {
            JointShape shape = armature1.getShape(joint.getId());
            IJointTransform transform = transforms[joint.getId()];
            if (shape == null || transform == null) continue;
            poseStack.pushPose();
            transform.apply(poseStack);
            this.renderShape(shape, ColorUtils.getPaletteColor(joint.getId()), poseStack, bufferSource);
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    protected void renderShape(JointShape shape, int color, IPoseStack poseStack, IBufferSource bufferSource) {
        poseStack.pushPose();
        OpenRectangle3f rect = shape.bounds();
        shape.transform().apply(poseStack);
        this.renderCube(shape, poseStack, 1.0f, 1.0f, 1.0f, 1.0f, bufferSource);
        this.renderOutline(rect, color, poseStack, bufferSource);
        poseStack.translate(rect.x(), rect.y(), rect.z());
        for (JointShape shape1 : shape.children()) {
            this.renderShape(shape1, color, poseStack, bufferSource);
        }
        poseStack.popPose();
    }

    protected void renderOutline(OpenRectangle3f rect, int color, IPoseStack poseStack, IBufferSource bufferSource) {
        ShapeTesselator.stroke((IRectangle3f)rect, color, poseStack, bufferSource);
    }

    protected void renderCube(JointShape shape, IPoseStack poseStack, float r, float g, float b, float a, IBufferSource bufferSource) {
        for (OpenDirection dir : OpenDirection.values()) {
            this.renderCube(shape, dir, poseStack, r, g, b, a, bufferSource);
        }
    }

    private void renderCube(JointShape shape, OpenDirection dir, IPoseStack poseStack, float r, float g, float b, float a, IBufferSource bufferSource) {
        OpenRectangle3f rect = shape.bounds();
        OpenRectangle2f uv = shape.getUV(dir);
        if (uv == null) {
            return;
        }
        IPoseStack.Pose entry = poseStack.last();
        IVertexConsumer builder = bufferSource.getBuffer(this.renderType);
        float x = rect.x();
        float y = rect.y();
        float z = rect.z();
        float w = rect.width();
        float h = rect.height();
        float d = rect.depth();
        float u = uv.x();
        float v = uv.y();
        float s = uv.width();
        float t = uv.height();
        float n = this.texture.getWidth();
        float m = this.texture.getHeight();
        float[][] uvs = SkinCubeFace.getBaseUVs(dir, 0);
        float[][] vertexes = SkinCubeFace.getBaseVertices(dir);
        for (int i = 0; i < 4; ++i) {
            builder.vertex(entry, x + w * vertexes[i][0], y + h * vertexes[i][1], z + d * vertexes[i][2]).color(r, g, b, a).uv((u + s * uvs[i][0]) / n, (v + t * uvs[i][1]) / m).overlayCoords(OverlayTexture.f_118083_).uv2(0xF000F0).normal(entry, vertexes[4][0], vertexes[4][1], vertexes[4][2]).endVertex();
        }
    }
}

