/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.armature.IJoint;
import moe.plushie.armourers_workshop.core.armature.Armature;
import moe.plushie.armourers_workshop.core.armature.Armatures;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.attachment.SkinAttachmentType;
import moe.plushie.armourers_workshop.core.skin.attachment.SkinAttachmentTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.utils.Collections;

public class DocumentPartMapper {
    private static final Set<SkinType> SINGLE_TYPES = Collections.immutableSet(builder -> {
        builder.add((Object)SkinTypes.ITEM_SWORD);
        builder.add((Object)SkinTypes.ITEM_SHIELD);
        builder.add((Object)SkinTypes.ITEM_TRIDENT);
        builder.add((Object)SkinTypes.ITEM_PICKAXE);
        builder.add((Object)SkinTypes.ITEM_AXE);
        builder.add((Object)SkinTypes.ITEM_SHOVEL);
        builder.add((Object)SkinTypes.ITEM_HOE);
        builder.add((Object)SkinTypes.ITEM_FISHING);
        builder.add((Object)SkinTypes.ITEM_BACKPACK);
        builder.add((Object)SkinTypes.ITEM);
        builder.add((Object)SkinTypes.BLOCK);
    });
    private static final Map<String, SkinPartType> BOW_PARTS = Collections.immutableMap(builder -> {
        builder.put((Object)"Arrow", (Object)SkinPartTypes.ITEM_ARROW);
        builder.put((Object)"Frame0", (Object)SkinPartTypes.ITEM_BOW0);
        builder.put((Object)"Frame1", (Object)SkinPartTypes.ITEM_BOW1);
        builder.put((Object)"Frame2", (Object)SkinPartTypes.ITEM_BOW2);
        builder.put((Object)"Frame3", (Object)SkinPartTypes.ITEM_BOW3);
    });
    private static final Map<String, SkinPartType> FINISHING_PARTS = Collections.immutableMap(builder -> {
        builder.put((Object)"Hook", (Object)SkinPartTypes.ITEM_FISHING_HOOK);
        builder.put((Object)"Frame0", (Object)SkinPartTypes.ITEM_FISHING_ROD);
        builder.put((Object)"Frame1", (Object)SkinPartTypes.ITEM_FISHING_ROD1);
    });
    private final SkinType type;
    private final Function<String, Entry> provider;
    private final Map<Node, Node> overrideNodes = new HashMap<Node, Node>();

    public DocumentPartMapper(SkinType type, Function<String, Entry> provider) {
        this.type = type;
        this.provider = provider;
        this.setup();
    }

    public static DocumentPartMapper of(SkinType type) {
        if (type == SkinTypes.ITEM_BOW) {
            return DocumentPartMapper.of(type, BOW_PARTS);
        }
        if (type == SkinTypes.ITEM_FISHING) {
            return DocumentPartMapper.of(type, FINISHING_PARTS);
        }
        return DocumentPartMapper.of(type, Armatures.byType(type));
    }

    private static DocumentPartMapper of(SkinType type, Armature armature) {
        return new DocumentPartMapper(type, name -> {
            SkinPartType partType;
            IJoint joint = armature.getJoint((String)name);
            if (joint != null && (partType = armature.getPartType(joint)) != null) {
                return new Entry(joint, partType);
            }
            return null;
        });
    }

    private static DocumentPartMapper of(SkinType type, Map<String, SkinPartType> map) {
        return new DocumentPartMapper(type, name -> {
            SkinPartType partType = (SkinPartType)map.get(name);
            if (partType != null) {
                return new Entry(null, partType);
            }
            return null;
        });
    }

    public Entry get(String name) {
        Entry entry = this.provider.apply(name);
        if (entry != null) {
            return entry;
        }
        return Entry.NONE;
    }

    public Entry getRoot() {
        Iterator<? extends SkinPartType> iterator;
        if (SINGLE_TYPES.contains(this.type) && (iterator = this.type.getParts().iterator()).hasNext()) {
            SkinPartType partType = iterator.next();
            return new Entry(null, partType);
        }
        return null;
    }

    public Node resolve(String name, SkinPartType partType) {
        Node node = new Node(name, partType);
        Node overridedNode = this.overrideNodes.get(node);
        if (overridedNode != null) {
            return overridedNode;
        }
        Entry overrideEntry = this.provider.apply(name);
        if (overrideEntry != null) {
            return new Node(name, overrideEntry.type);
        }
        return node;
    }

    public boolean isEmpty() {
        return false;
    }

    private void setup() {
        this.register(Node.bone("LeftHandLocator"), SkinAttachmentTypes.LEFT_HAND);
        this.register(Node.bone("RightHandLocator"), SkinAttachmentTypes.RIGHT_HAND);
        this.register(Node.bone("LeftShoulderLocator"), SkinAttachmentTypes.LEFT_SHOULDER);
        this.register(Node.bone("RightShoulderLocator"), SkinAttachmentTypes.RIGHT_SHOULDER);
        this.register(Node.bone("LeftWaistLocator"), SkinAttachmentTypes.LEFT_WAIST);
        this.register(Node.bone("RightWaistLocator"), SkinAttachmentTypes.RIGHT_WAIST);
        this.register(Node.bone("BackpackLocator"), SkinAttachmentTypes.BACKPACK);
        this.register(Node.bone("ViewLocator"), SkinAttachmentTypes.VIEW);
        this.register(Node.bone("ElytraLocator"), SkinAttachmentTypes.ELYTRA);
        this.register(Node.bone("NameLocator"), SkinAttachmentTypes.NAME);
        this.register(Node.bone("RidingLocator"), SkinAttachmentTypes.RIDING);
        this.register(Node.locator("hand_l"), SkinAttachmentTypes.LEFT_HAND);
        this.register(Node.locator("hand_r"), SkinAttachmentTypes.RIGHT_HAND);
        this.registerMultiple(9, Node.bone("LeftHandLocator"), SkinAttachmentTypes.LEFT_HAND);
        this.registerMultiple(9, Node.bone("RightHandLocator"), SkinAttachmentTypes.RIGHT_HAND);
        this.registerMultiple(16, Node.bone("RidingLocator"), SkinAttachmentTypes.RIDING);
    }

    private void register(Node node, SkinAttachmentType attachmentType) {
        this.overrideNodes.put(node, Node.locator(attachmentType.getRegistryName().toString()));
    }

    private void registerMultiple(int count, Node node, SkinAttachmentType attachmentType) {
        for (int i = 0; i < count; ++i) {
            Node s1 = new Node(node.name + (i + 1), node.type);
            Node s2 = Node.locator(attachmentType.getRegistryName().toString() + "." + i);
            this.overrideNodes.put(s1, s2);
        }
    }

    public static class Entry {
        public static final Entry NONE = new Entry(null, SkinPartTypes.ADVANCED);
        private final SkinPartType type;

        public Entry(IJoint joint, SkinPartType type) {
            this.type = type;
        }

        public boolean isRootPart() {
            return this.type != SkinPartTypes.ADVANCED;
        }

        public OpenVector3f getOffset() {
            if (this.type == SkinPartTypes.BIPPED_CHEST || this.type == SkinPartTypes.BIPPED_TORSO) {
                return new OpenVector3f(0.0f, 6.0f, 0.0f);
            }
            return OpenVector3f.ZERO;
        }

        public SkinPartType getType() {
            return this.type;
        }
    }

    public static class Node {
        private final String name;
        private final SkinPartType type;

        public Node(String name, SkinPartType type) {
            this.name = name;
            this.type = type;
        }

        public static Node bone(String name) {
            return new Node(name, SkinPartTypes.ADVANCED);
        }

        public static Node locator(String name) {
            return new Node(name, SkinPartTypes.ADVANCED_LOCATOR);
        }

        public String getName() {
            return this.name;
        }

        public SkinPartType getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node node = (Node)o;
            return Objects.equals(this.name, node.name) && Objects.equals(this.type, node.type);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }
    }
}

