/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder;

import com.apple.library.coregraphics.CGAffineTransform;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSString;
import com.apple.library.impl.StringImpl;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIMenuController;
import com.apple.library.uikit.UIMenuItem;
import com.apple.library.uikit.UIScreen;
import com.apple.library.uikit.UIView;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.ArrayList;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.builder.blockentity.AdvancedBuilderBlockEntity;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document.DocumentEditor;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document.DocumentImporter;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document.DocumentMinimapNode;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document.DocumentMinimapView;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document.DocumentTypeListView;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.panel.AdvancedCameraPanel;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.panel.AdvancedLeftCardPanel;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.panel.AdvancedRightCardPanel;
import moe.plushie.armourers_workshop.builder.menu.AdvancedBuilderMenu;
import moe.plushie.armourers_workshop.builder.network.AdvancedExportPacket;
import moe.plushie.armourers_workshop.builder.network.AdvancedImportPacket;
import moe.plushie.armourers_workshop.core.client.gui.notification.UserNotificationCenter;
import moe.plushie.armourers_workshop.core.client.gui.widget.ConfirmDialog;
import moe.plushie.armourers_workshop.core.client.gui.widget.FileProviderDialog;
import moe.plushie.armourers_workshop.core.client.gui.widget.MenuWindow;
import moe.plushie.armourers_workshop.core.client.gui.widget.TreeIndexPath;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocument;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentListener;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentType;
import moe.plushie.armourers_workshop.init.ModMenuOptions;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedBuilderWindow
extends MenuWindow<AdvancedBuilderMenu>
implements SkinDocumentListener {
    private static final int CARD_WIDTH = 100;
    private final ArrayList<NSString> helps = new ArrayList();
    private final UIButton helpView = new UIButton(new CGRect(0.0f, 0.0f, 7.0f, 8.0f));
    private final AdvancedCameraPanel cameraView;
    private final AdvancedLeftCardPanel leftCard;
    private final AdvancedRightCardPanel rightCard;
    private final DocumentMinimapView minimapView;
    private final DocumentTypeListView typeListView;
    private final SkinDocument doc;
    private final DocumentEditor editor;
    private CGSize cachedTitleSize;

    public AdvancedBuilderWindow(AdvancedBuilderMenu container, Inventory inventory, NSString title) {
        this(container, (AdvancedBuilderBlockEntity)container.getBlockEntity(), inventory, title);
    }

    public AdvancedBuilderWindow(AdvancedBuilderMenu container, AdvancedBuilderBlockEntity blockEntity, Inventory inventory, NSString title) {
        super(container, inventory, title);
        this.editor = new DocumentEditor(blockEntity);
        this.doc = this.editor.getDocument();
        this.cameraView = new AdvancedCameraPanel(this.editor);
        this.leftCard = new AdvancedLeftCardPanel(this.editor, new CGRect(0.0f, 0.0f, 200.0f, UIScreen.bounds().height() * 2.0f));
        this.rightCard = new AdvancedRightCardPanel(this.editor, new CGRect(0.0f, 0.0f, 200.0f, UIScreen.bounds().height() * 2.0f));
        this.inventoryView.setHidden(true);
        this.minimapView = this.rightCard.getMinimapView();
        this.typeListView = this.rightCard.getTypeListView();
        this.setup();
        this.cameraView.reset();
        this.documentDidReload();
    }

    private void setup() {
        CGRect bounds = UIScreen.bounds();
        this.setFrame(bounds);
        this.setupCameraView();
        this.setupLeftCard(bounds);
        this.setupRightCard(bounds);
        this.setupShortcuts();
        this.setupHelp();
    }

    private void setupCameraView() {
        this.cameraView.setFrame(this.bounds());
        this.cameraView.setAutoresizingMask(18);
        this.addSubview(this.cameraView);
    }

    private void setupLeftCard(CGRect rect) {
        float offset = -100.0f;
        if (Options.SHOWS_LEFT_CARD.get()) {
            offset = 0.0f;
        }
        this.leftCard.setAutoresizingMask(20);
        this.leftCard.setBackgroundColor(new UIColor(0x1D1D1D));
        this.leftCard.setTransform(CGAffineTransform.createScale(0.5f, 0.5f));
        this.leftCard.setFrame(new CGRect(offset, 0.0f, 100.0f, rect.height));
        this.addSubview(this.leftCard);
    }

    private void setupRightCard(CGRect rect) {
        float offset = 0.0f;
        if (Options.SHOWS_RIGHT_CARD.get()) {
            offset = 100.0f;
        }
        this.rightCard.setAutoresizingMask(17);
        this.rightCard.setBackgroundColor(new UIColor(0x1D1D1D));
        this.rightCard.setTransform(CGAffineTransform.createScale(0.5f, 0.5f));
        this.rightCard.setFrame(new CGRect(rect.width - offset, 0.0f, 100.0f, rect.height));
        this.addSubview(this.rightCard);
        UIMenuController menuController = new UIMenuController();
        menuController.setTransform(CGAffineTransform.createScale(0.5f, 0.5f));
        this.rightCard.setMenuController(menuController);
    }

    private void setupHelp() {
        this.helpView.setBackgroundImage(ModTextures.helpButtonImage(), 7);
        this.helpView.setTooltip(StringImpl.join(this.helps, "\n"));
        this.helpView.setCanBecomeFocused(false);
        this.addSubview(this.helpView);
    }

    private void setupHelpLayout(CGRect rect) {
        if (this.cachedTitleSize == null) {
            this.cachedTitleSize = this.titleView.sizeThatFits(CGSize.ZERO);
        }
        CGRect target = this.titleView.frame();
        CGRect frame = this.helpView.frame().copy();
        frame.setX(target.x + (target.width - this.cachedTitleSize.width) / 2.0f + this.cachedTitleSize.width + 2.0f);
        frame.setY(target.y);
        this.helpView.setFrame(frame);
    }

    private void setupShortcuts() {
        this.addShortcut("show1", this::toggleLeftCard, "key.keyboard.control", "key.keyboard.1");
        this.addShortcut("show2", this::toggleRightCard, "key.keyboard.control", "key.keyboard.2");
        this.addShortcut("import", this::importAction, "key.keyboard.control", "key.keyboard.i");
        this.addShortcut("export", this::exportAction, "key.keyboard.control", "key.keyboard.e");
    }

    private void toggleLeftCard() {
        float value = 0.0f;
        if (Options.SHOWS_LEFT_CARD.get()) {
            Options.SHOWS_LEFT_CARD.set(false);
            value = -100.0f;
        } else {
            Options.SHOWS_LEFT_CARD.set(true);
            value = 100.0f;
        }
        CGPoint oldValue = this.leftCard.center();
        CGPoint newValue = new CGPoint(oldValue.x + value, oldValue.y);
        UIView.animationWithDuration(0.35, () -> this.leftCard.setCenter(newValue));
    }

    private void toggleRightCard() {
        float value = 0.0f;
        if (Options.SHOWS_RIGHT_CARD.get()) {
            Options.SHOWS_RIGHT_CARD.set(false);
            value = 100.0f;
        } else {
            Options.SHOWS_RIGHT_CARD.set(true);
            value = -100.0f;
        }
        CGPoint oldValue = this.rightCard.center();
        CGPoint newValue = new CGPoint(oldValue.x + value, oldValue.y);
        UIView.animationWithDuration(0.35, () -> this.rightCard.setCenter(newValue));
    }

    private void importAction() {
        SkinDocumentType documentType = this.rightCard.getTypeListView().selectedType();
        if (documentType == null) {
            return;
        }
        this.importNewSkin(documentType.getSkinType(), skin -> {
            AdvancedBuilderBlockEntity blockEntity = this.editor.getBlockEntity();
            NetworkManager.sendToServer(new AdvancedImportPacket(blockEntity, (Skin)skin, ""));
        });
    }

    private void exportAction() {
        SkinDocumentType documentType = this.rightCard.getTypeListView().selectedType();
        if (documentType == null) {
            return;
        }
        ConfirmDialog alert = new ConfirmDialog();
        alert.setTitle(NSString.localizedString("advanced-skin-builder.dialog.exporter.title", new Object[0]));
        alert.setMessage(NSString.localizedString("advanced-skin-builder.dialog.exporter.message", new Object[0]));
        alert.showInView(this, () -> {
            if (!alert.isCancelled()) {
                GameProfile origin = Minecraft.m_91087_().m_91094_().m_92548_();
                CompoundTag nbt = DataSerializers.writeGameProfile(new CompoundTag(), origin);
                AdvancedExportPacket packet = new AdvancedExportPacket(this.editor.getBlockEntity(), nbt);
                NetworkManager.sendToServer(packet);
            }
        });
    }

    private void addShortcut(String name, Runnable action, String ... keys) {
        UIMenuItem.Builder builder = UIMenuItem.of(name);
        builder.keyDown(keys);
        builder.execute(action);
        UIMenuItem item = builder.build();
        this.helps.add(NSString.localizedString("advanced-skin-builder.shortcut." + name, item.key()));
        this.addMenuItem(item);
    }

    public void importNewSkin(SkinType skinType, Consumer<Skin> consumer) {
        NSString title = NSString.localizedString("advanced-skin-builder.dialog.importer.title", new Object[0]);
        SkinLibraryManager.Client libraryManager = SkinLibraryManager.getClient();
        if (!libraryManager.shouldUploadFile(this.inventory.f_35978_)) {
            NSString message = NSString.localizedString("skin-library.error.illegalOperation", new Object[0]);
            UserNotificationCenter.showToast(message, UIColor.RED, title, null);
            return;
        }
        File rootPath = new File(EnvironmentManager.getRootDirectory(), "model-imports");
        if (!rootPath.exists() && !rootPath.mkdirs()) {
            NSString message = new NSString("Can't create directory");
            UserNotificationCenter.showToast(message, UIColor.RED, title, null);
            return;
        }
        FileProviderDialog alert = new FileProviderDialog(rootPath, "bbmodel");
        alert.setTitle(title);
        alert.showInView(this, () -> {
            if (!alert.isCancelled()) {
                DocumentImporter importer = new DocumentImporter(alert.getSelectedFile(), skinType);
                SkinProperties properties = alert.getProperties();
                importer.setAdaptMode(properties.get(SkinProperty.USE_ADAPT_MODE));
                importer.setKeepItemTransforms(properties.get(SkinProperty.USE_ITEM_TRANSFORMS));
                importer.execute(consumer);
            }
        });
    }

    @Override
    public void init() {
        super.init();
        this.doc.addListener(this);
        this.cameraView.connect();
        this.editor.connect();
    }

    @Override
    public void deinit() {
        this.editor.disconnect();
        this.cameraView.disconnect();
        this.doc.removeListener(this);
        super.deinit();
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        this.setupHelpLayout(this.bounds());
    }

    @Override
    public void documentDidSelectNode(SkinDocumentNode node) {
        TreeIndexPath indexPath = this.minimapView.findNodePath(node);
        this.minimapView.setSelectedIndex(indexPath);
    }

    @Override
    public void documentDidReload() {
        this.documentDidChangeType(this.editor.getDocument().getType());
        this.documentDidChangeSettings(new CompoundTag());
        this.documentDidChangeProperties(new CompoundTag());
    }

    @Override
    public void documentDidChangeType(SkinDocumentType type) {
        this.typeListView.setSelectedType(type);
        TreeIndexPath indexPath = this.minimapView.getSelectedIndex();
        this.minimapView.reloadData(this.editor.getDocument().getRoot());
        this.minimapView.setSelectedIndex(indexPath);
    }

    @Override
    public void documentDidChangeSettings(CompoundTag tag) {
        this.editor.getConnector().update(this.editor.getDocument().getSettings());
    }

    @Override
    public void documentDidChangeProperties(CompoundTag tag) {
        this.editor.getConnector().update(this.editor.getDocument().getProperties());
    }

    @Override
    public void documentDidInsertNode(SkinDocumentNode node, SkinDocumentNode target, int index) {
        DocumentMinimapNode nodeView = this.minimapView.findNode(node);
        if (nodeView != null) {
            DocumentMinimapNode targetView = new DocumentMinimapNode(target);
            nodeView.insertAtIndex(targetView, index);
        }
    }

    @Override
    public void documentDidUpdateNode(SkinDocumentNode node, CompoundTag tag) {
        DocumentMinimapNode nodeView;
        this.rightCard.documentDidUpdateNode(node, tag);
        if (tag.m_128441_("Name") && (nodeView = this.minimapView.findNode(node)) != null) {
            nodeView.setTitle(node.getName());
        }
    }

    @Override
    public void documentDidRemoveNode(SkinDocumentNode node) {
        DocumentMinimapNode nodeView = this.minimapView.findNode(node);
        if (nodeView != null) {
            TreeIndexPath indexPath = this.minimapView.getSelectedIndex();
            nodeView.removeFromParent();
            this.minimapView.setSelectedIndex(indexPath);
        }
    }

    @Override
    public void documentDidMoveNode(SkinDocumentNode node, SkinDocumentNode target, int index) {
        DocumentMinimapNode nodeView = this.minimapView.findNode(node);
        DocumentMinimapNode targetView = this.minimapView.findNode(target);
        if (nodeView != null && targetView != null) {
            nodeView.moveTo(targetView, index);
        }
    }

    @Override
    public void screenWillResize(CGSize size) {
        this.setFrame(new CGRect(0.0f, 0.0f, size.width, size.height));
    }

    @Override
    public boolean shouldRenderBackground() {
        return false;
    }

    public static class Options {
        public static final Options SHOWS_LEFT_CARD = new Options("advanced.showLeftCard");
        public static final Options SHOWS_RIGHT_CARD = new Options("advanced.showRightCard");
        private final String key;
        private boolean value;

        public Options(String key) {
            this.key = key;
            this.value = ModMenuOptions.getInstance().getBoolean(key, true);
        }

        public void set(boolean value) {
            this.value = value;
            ModMenuOptions.getInstance().putBoolean(this.key, value);
        }

        public boolean get() {
            return this.value;
        }
    }
}

