/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.blockentity;

import java.util.Arrays;
import java.util.Map;
import moe.plushie.armourers_workshop.api.common.IPaintable;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.api.skin.texture.ISkinPaintColor;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.data.BoundingBox;
import moe.plushie.armourers_workshop.builder.other.BlockUtils;
import moe.plushie.armourers_workshop.core.blockentity.UpdatableBlockEntity;
import moe.plushie.armourers_workshop.core.math.OpenVector2i;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.utils.TextureUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BoundingBoxBlockEntity
extends UpdatableBlockEntity
implements IPaintable {
    protected OpenVector3i guide = OpenVector3i.ZERO;
    protected BlockPos parent = null;
    protected SkinPartType partType = SkinPartTypes.UNKNOWN;
    private ArmourerBlockEntity cachedParentBlockEntity;
    private boolean customRenderer = false;

    public BoundingBoxBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    public void readAdditionalData(IDataSerializer serializer) {
        this.parent = serializer.read(CodingKeys.REFER);
        this.guide = serializer.read(CodingKeys.OFFSET);
        this.partType = serializer.read(CodingKeys.PART_TYPE);
        this.customRenderer = Arrays.stream(Direction.values()).anyMatch(this::shouldChangeColor);
        this.cachedParentBlockEntity = null;
    }

    @Override
    public void writeAdditionalData(IDataSerializer serializer) {
        serializer.write(CodingKeys.REFER, this.parent);
        serializer.write(CodingKeys.OFFSET, this.guide);
        serializer.write(CodingKeys.PART_TYPE, this.partType);
    }

    public SkinPartType getPartType() {
        return this.partType;
    }

    public void setPartType(SkinPartType partType) {
        this.partType = partType;
    }

    public BlockPos getParent() {
        return this.parent;
    }

    public void setParent(BlockPos parent) {
        this.cachedParentBlockEntity = null;
        this.parent = parent;
    }

    public OpenVector3i getGuide() {
        return this.guide;
    }

    public void setGuide(OpenVector3i guide) {
        this.guide = guide;
    }

    public boolean isValid() {
        ArmourerBlockEntity blockEntity = this.getParentBlockEntity();
        if (blockEntity != null && blockEntity.getSkinType() != null) {
            return blockEntity.getSkinType().getParts().contains(this.partType);
        }
        return false;
    }

    public boolean hasColors() {
        ArmourerBlockEntity blockEntity = this.getParentBlockEntity();
        if (blockEntity == null) {
            return false;
        }
        for (Direction dir : Direction.values()) {
            SkinPaintColor paintColor = this.getArmourerTextureColor(blockEntity, this.getTexturePos(blockEntity, dir));
            if (paintColor == SkinPaintColor.CLEAR) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldChangeColor(Direction direction) {
        return this.getTexturePos(this.getParentBlockEntity(), direction) != null;
    }

    @Override
    public ISkinPaintColor getColor(Direction direction) {
        OpenVector2i texturePos;
        ArmourerBlockEntity blockEntity = this.getParentBlockEntity();
        SkinPaintColor color = this.getArmourerTextureColor(blockEntity, texturePos = this.getTexturePos(blockEntity, direction));
        if (color != null && color.getPaintType() != SkinPaintTypes.NONE) {
            return color;
        }
        Level level = this.m_58904_();
        if (level != null && level.m_5776_()) {
            return this.getTextureColor(blockEntity, texturePos);
        }
        return SkinPaintColor.CLEAR;
    }

    @Override
    public void setColor(Direction direction, ISkinPaintColor color) {
    }

    @Override
    public void setColors(Map<Direction, ISkinPaintColor> colors) {
        ArmourerBlockEntity blockEntity = this.getParentBlockEntity();
        colors.forEach((dir, color) -> this.setArmourerTextureColor(blockEntity, this.getTexturePos(blockEntity, (Direction)dir), (SkinPaintColor)color));
    }

    @Override
    public boolean hasColor(Direction direction) {
        return this.getColor(direction) != SkinPaintColor.CLEAR;
    }

    public void clearArmourerTextureColors() {
        ArmourerBlockEntity blockEntity = this.getParentBlockEntity();
        if (blockEntity == null || this.m_58904_() == null) {
            return;
        }
        for (Direction dir : Direction.values()) {
            this.setArmourerTextureColor(blockEntity, this.getTexturePos(blockEntity, dir), SkinPaintColor.CLEAR);
        }
    }

    public SkinPaintColor getArmourerTextureColor(ArmourerBlockEntity blockEntity, OpenVector2i texturePos) {
        SkinPaintColor color;
        if (texturePos != null && blockEntity != null && (color = blockEntity.getPaintColor(texturePos)) != null) {
            return color;
        }
        return SkinPaintColor.CLEAR;
    }

    public void setArmourerTextureColor(ArmourerBlockEntity blockEntity, OpenVector2i texturePos, SkinPaintColor color) {
        if (texturePos != null && blockEntity != null) {
            blockEntity.setPaintColor(texturePos, color);
            BlockUtils.combine(blockEntity, blockEntity::sendBlockUpdates);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private SkinPaintColor getTextureColor(ArmourerBlockEntity blockEntity, OpenVector2i texturePos) {
        SkinPaintColor color;
        if (texturePos != null && blockEntity != null && (color = TextureUtils.getPlayerTextureModelColor(blockEntity.getTextureDescriptor(), texturePos)) != null) {
            return color;
        }
        return SkinPaintColor.CLEAR;
    }

    private OpenVector2i getTexturePos(ArmourerBlockEntity blockEntity, Direction direction) {
        return BoundingBox.getTexturePos(this.partType, this.guide, this.getResolvedDirection(blockEntity, direction));
    }

    private Direction getResolvedDirection(ArmourerBlockEntity blockEntity, Direction dir) {
        if (blockEntity == null) {
            return dir;
        }
        return switch (blockEntity.getFacing()) {
            case Direction.SOUTH -> Rotation.CLOCKWISE_180.m_55954_(dir);
            case Direction.WEST -> Rotation.CLOCKWISE_90.m_55954_(dir);
            case Direction.EAST -> Rotation.COUNTERCLOCKWISE_90.m_55954_(dir);
            default -> dir;
        };
    }

    private ArmourerBlockEntity getParentBlockEntity() {
        if (this.cachedParentBlockEntity != null) {
            if (this.cachedParentBlockEntity.m_58901_()) {
                return null;
            }
            return this.cachedParentBlockEntity;
        }
        Level level = this.m_58904_();
        if (level == null || this.parent == null) {
            return null;
        }
        BlockPos target = this.m_58899_().m_121996_((Vec3i)this.parent);
        BlockEntity blockEntity = level.m_7702_(target);
        if (blockEntity instanceof ArmourerBlockEntity) {
            ArmourerBlockEntity blockEntity2;
            this.cachedParentBlockEntity = blockEntity2 = (ArmourerBlockEntity)blockEntity;
            return this.cachedParentBlockEntity;
        }
        return null;
    }

    public boolean isCustomRenderer() {
        if (this.customRenderer) {
            return this.isValid();
        }
        return false;
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<BlockPos> REFER = IDataSerializerKey.create("Refer", IDataCodec.BLOCK_POS, null);
        public static final IDataSerializerKey<OpenVector3i> OFFSET = IDataSerializerKey.create("Offset", OpenVector3i.CODEC, OpenVector3i.ZERO);
        public static final IDataSerializerKey<SkinPartType> PART_TYPE = IDataSerializerKey.create("PartType", SkinPartTypes.CODEC, SkinPartTypes.UNKNOWN);

        private CodingKeys() {
        }
    }
}

