/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.blockentity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.common.IWorldUpdateTask;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.builder.block.ArmourerBlock;
import moe.plushie.armourers_workshop.builder.blockentity.BoundingBoxBlockEntity;
import moe.plushie.armourers_workshop.builder.data.BoundingBox;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolSelector;
import moe.plushie.armourers_workshop.builder.other.BlockUtils;
import moe.plushie.armourers_workshop.builder.other.CubeChangesCollector;
import moe.plushie.armourers_workshop.builder.other.CubeReplacingEvent;
import moe.plushie.armourers_workshop.builder.other.CubeSelector;
import moe.plushie.armourers_workshop.builder.other.CubeTransform;
import moe.plushie.armourers_workshop.builder.other.WorldBlockUpdateTask;
import moe.plushie.armourers_workshop.builder.other.WorldUpdater;
import moe.plushie.armourers_workshop.builder.other.WorldUtils;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.level.block.state.BlockState.PropertyProvider;
import moe.plushie.armourers_workshop.core.blockentity.UpdatableBlockEntity;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3i;
import moe.plushie.armourers_workshop.core.math.OpenVector2i;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureModel;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintData;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.init.ModBlocks;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class ArmourerBlockEntity
extends UpdatableBlockEntity
implements IPaintToolSelector.Provider {
    private static final Map<SkinPartType, SkinProperty<Boolean>> PART_TO_MODEL = Collections.immutableMap(builder -> {
        builder.put((Object)SkinPartTypes.BIPPED_HEAD, SkinProperty.OVERRIDE_MODEL_HEAD);
        builder.put((Object)SkinPartTypes.BIPPED_CHEST, SkinProperty.OVERRIDE_MODEL_CHEST);
        builder.put((Object)SkinPartTypes.BIPPED_LEFT_ARM, SkinProperty.OVERRIDE_MODEL_LEFT_ARM);
        builder.put((Object)SkinPartTypes.BIPPED_RIGHT_ARM, SkinProperty.OVERRIDE_MODEL_RIGHT_ARM);
        builder.put((Object)SkinPartTypes.BIPPED_LEFT_THIGH, SkinProperty.OVERRIDE_MODEL_LEFT_LEG);
        builder.put((Object)SkinPartTypes.BIPPED_RIGHT_THIGH, SkinProperty.OVERRIDE_MODEL_RIGHT_LEG);
        builder.put((Object)SkinPartTypes.BIPPED_LEFT_FOOT, SkinProperty.OVERRIDE_MODEL_LEFT_LEG);
        builder.put((Object)SkinPartTypes.BIPPED_RIGHT_FOOT, SkinProperty.OVERRIDE_MODEL_RIGHT_LEG);
    });
    protected int flags = 0;
    protected int version = 0;
    protected SkinType skinType = SkinTypes.ARMOR_HEAD;
    protected SkinProperties skinProperties = SkinProperties.EMPTY;
    protected EntityTextureDescriptor textureDescriptor = EntityTextureDescriptor.EMPTY;
    protected SkinPaintData paintData;
    protected AABB renderBoundingBox;

    public ArmourerBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    public void readAdditionalData(IDataSerializer serializer) {
        this.skinType = serializer.read(CodingKeys.SKIN_TYPE);
        this.skinProperties = serializer.read(CodingKeys.SKIN_PROPERTIES);
        this.textureDescriptor = serializer.read(CodingKeys.PLAYER_TEXTURE);
        this.flags = serializer.read(CodingKeys.FLAGS);
        this.version = serializer.read(CodingKeys.VERSION);
        this.paintData = serializer.read(CodingKeys.PAINT_DATA);
        if (this.skinType == SkinTypes.UNKNOWN) {
            this.skinType = SkinTypes.ARMOR_HEAD;
        }
    }

    @Override
    public void writeAdditionalData(IDataSerializer serializer) {
        serializer.write(CodingKeys.SKIN_TYPE, this.skinType);
        serializer.write(CodingKeys.SKIN_PROPERTIES, this.skinProperties);
        serializer.write(CodingKeys.PLAYER_TEXTURE, this.textureDescriptor);
        serializer.write(CodingKeys.FLAGS, this.flags);
        serializer.write(CodingKeys.VERSION, this.version);
        serializer.write(CodingKeys.PAINT_DATA, this.paintData);
    }

    public void onPlace(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity) {
        this.remakeBoundingBoxes(null, this.getBoundingBoxes(), true);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.setTextureDescriptor(EntityTextureDescriptor.fromProfile(player.m_36316_()));
        }
    }

    public void onRemove(Level level, BlockPos pos, BlockState state) {
        if (!this.m_58900_().m_60713_((Block)ModBlocks.ARMOURER.get())) {
            return;
        }
        this.remakeBoundingBoxes(this.getBoundingBoxes(), null, true);
    }

    public SkinType getSkinType() {
        return this.skinType;
    }

    public void setSkinType(SkinType skinType) {
        if (this.skinType == skinType) {
            return;
        }
        Collection<BoundingBox> boxes = this.getBoundingBoxes();
        this.skinType = skinType;
        this.setPaintData(null);
        this.remakeSkinProperties();
        this.remakeBoundingBoxes(boxes, this.getBoundingBoxes(), true);
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public SkinProperties getSkinProperties() {
        return this.skinProperties;
    }

    public void setSkinProperties(SkinProperties skinProperties) {
        Collection<BoundingBox> boxes = this.getBoundingBoxes();
        this.skinProperties = skinProperties;
        this.remakeBoundingBoxes(boxes, this.getBoundingBoxes(), false);
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        Collection<BoundingBox> boxes = this.getBoundingBoxes();
        this.flags = flags;
        this.remakeBoundingBoxes(boxes, this.getBoundingBoxes(), false);
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public EntityTextureDescriptor getTextureDescriptor() {
        return this.textureDescriptor;
    }

    public void setTextureDescriptor(EntityTextureDescriptor textureDescriptor) {
        this.textureDescriptor = textureDescriptor;
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public SkinPaintData getPaintData() {
        return this.paintData;
    }

    public void setPaintData(SkinPaintData paintData) {
        if (this.paintData == paintData) {
            return;
        }
        if (paintData != null) {
            this.paintData = SkinPaintData.v2();
            this.paintData.copyFrom(paintData);
        } else {
            this.paintData = null;
        }
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public SkinPaintColor getPaintColor(OpenVector2i pos) {
        if (this.paintData != null) {
            return SkinPaintColor.of(this.paintData.getColor(pos));
        }
        return null;
    }

    public void setPaintColor(OpenVector2i pos, SkinPaintColor paintColor) {
        if (this.paintData == null) {
            this.paintData = SkinPaintData.v2();
        }
        this.paintData.setColor(pos, paintColor.getRawValue());
        this.m_6596_();
    }

    @Override
    public void m_6596_() {
        super.m_6596_();
        ++this.version;
    }

    public boolean isShowGuides() {
        return (this.flags & 1) == 0;
    }

    public void setShowGuides(boolean value) {
        this.flags = value ? (this.flags &= 0xFFFFFFFE) : (this.flags |= 1);
        this.m_6596_();
    }

    public boolean isShowHelper() {
        return (this.flags & 2) == 0;
    }

    public void setShowHelper(boolean value) {
        this.flags = value ? (this.flags &= 0xFFFFFFFD) : (this.flags |= 2);
        this.m_6596_();
    }

    public boolean isShowModelGuides() {
        return (this.flags & 4) == 0;
    }

    public void setShowModelGuides(boolean value) {
        this.flags = value ? (this.flags &= 0xFFFFFFFB) : (this.flags |= 4);
        this.m_6596_();
    }

    public boolean isUseHelper() {
        if (this.skinType == SkinTypes.ARMOR_WINGS) {
            return true;
        }
        return this.skinType.isTool();
    }

    @Override
    public IPaintToolSelector createPaintToolSelector(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null || !player.m_36341_()) {
            return null;
        }
        ArrayList<OpenRectangle3i> rects = new ArrayList<OpenRectangle3i>();
        CubeTransform transform = this.getTransform();
        for (SkinPartType skinPartType : this.getSkinType().getParts()) {
            OpenRectangle3i box = WorldUtils.getResolvedBuildingSpace(skinPartType);
            BlockPos p1 = transform.mul(box.minX(), box.minY(), box.minZ());
            BlockPos p2 = transform.mul(box.maxX(), box.maxY(), box.maxZ());
            int minX = Math.min(p1.m_123341_(), p2.m_123341_());
            int minY = Math.min(p1.m_123342_(), p2.m_123342_());
            int minZ = Math.min(p1.m_123343_(), p2.m_123343_());
            int maxX = Math.max(p1.m_123341_(), p2.m_123341_());
            int maxY = Math.max(p1.m_123342_(), p2.m_123342_());
            int maxZ = Math.max(p1.m_123343_(), p2.m_123343_());
            rects.add(new OpenRectangle3i(minX, minY, minZ, maxX - minX, maxY - minY, maxZ - minZ));
        }
        return CubeSelector.all(rects);
    }

    public void copyPaintData(CubeChangesCollector collector, SkinPartType srcPart, SkinPartType destPart, boolean mirror) {
        if (this.paintData == null) {
            return;
        }
        EntityTextureModel textureModel = BoundingBox.MODEL;
        EntityTextureModel.Box srcBox = textureModel.get(srcPart);
        EntityTextureModel.Box destBox = textureModel.get(destPart);
        if (srcBox != null && destBox != null) {
            WorldUtils.copyPaintData(this.paintData, srcBox, destBox, mirror);
            BlockUtils.combine(this, this::sendBlockUpdates);
        }
    }

    public void clearPaintData(CubeChangesCollector collector, SkinPartType partType) {
        if (this.paintData == null) {
            return;
        }
        if (partType == SkinPartTypes.UNKNOWN) {
            this.setPaintData(null);
            return;
        }
        EntityTextureModel textureModel = BoundingBox.MODEL;
        EntityTextureModel.Box srcBox = textureModel.get(partType);
        if (srcBox != null) {
            WorldUtils.clearPaintData(this.paintData, srcBox);
            BlockUtils.combine(this, this::sendBlockUpdates);
        }
    }

    public void clearCubes(CubeChangesCollector collector, SkinPartType partType) {
        WorldUtils.clearCubes(collector, this.getTransform(), this.getSkinType(), this.getSkinProperties(), partType);
        if (partType != SkinPartTypes.UNKNOWN) {
            return;
        }
        Boolean isMultiBlock = this.skinProperties.get(SkinProperty.BLOCK_MULTIBLOCK);
        this.skinProperties = new SkinProperties();
        this.skinProperties.put(SkinProperty.BLOCK_MULTIBLOCK, isMultiBlock);
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public void replaceCubes(CubeChangesCollector collector, SkinPartType partType, CubeReplacingEvent event) throws Exception {
        WorldUtils.replaceCubes(collector, this.getTransform(), this.getSkinType(), this.getSkinProperties(), event);
    }

    public void copyCubes(CubeChangesCollector collector, SkinPartType srcPart, SkinPartType destPart, boolean mirror) throws Exception {
        WorldUtils.copyCubes(collector, this.getTransform(), this.getSkinType(), this.getSkinProperties(), srcPart, destPart, mirror);
    }

    public void clearMarkers(CubeChangesCollector collector, SkinPartType partType) {
        WorldUtils.clearMarkers(collector, this.getTransform(), this.getSkinType(), this.getSkinProperties(), partType);
        this.m_6596_();
    }

    public boolean isModelOverridden(SkinPartType partType) {
        SkinProperty<Boolean> property = PART_TO_MODEL.get(partType);
        if (property != null) {
            return this.getSkinProperties().get(property);
        }
        return false;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public AABB getVisibleBox(BlockState blockState) {
        if (this.renderBoundingBox == null) {
            this.renderBoundingBox = new AABB(-32.0, -32.0, -44.0, 64.0, 64.0, 64.0);
            this.renderBoundingBox = this.renderBoundingBox.m_82338_(this.m_58899_());
        }
        return this.renderBoundingBox;
    }

    private void remakeSkinProperties() {
        String name = this.skinProperties.get(SkinProperty.ALL_CUSTOM_NAME);
        String flavour = this.skinProperties.get(SkinProperty.ALL_FLAVOUR_TEXT);
        this.skinProperties = new SkinProperties();
        this.skinProperties.put(SkinProperty.ALL_CUSTOM_NAME, name);
        this.skinProperties.put(SkinProperty.ALL_FLAVOUR_TEXT, flavour);
    }

    private boolean shouldAddBoundingBoxes(SkinPartType partType) {
        if (this.isUseHelper()) {
            return this.isShowHelper();
        }
        return !this.isModelOverridden(partType);
    }

    private void remakeBoundingBoxes(Collection<BoundingBox> oldBoxes, Collection<BoundingBox> newBoxes, boolean forced) {
        Level level = this.m_58904_();
        if (level == null || level.m_5776_()) {
            return;
        }
        if (!forced && Objects.equals(oldBoxes, newBoxes)) {
            return;
        }
        this.applyBoundingBoxes(oldBoxes, (partType, pos, offset) -> {
            WorldBlockUpdateTask task = new WorldBlockUpdateTask(level, pos, Blocks.f_50016_.m_49966_());
            task.setValidator(state -> state.m_60713_((Block)ModBlocks.BOUNDING_BOX.get()));
            return task;
        });
        this.applyBoundingBoxes(newBoxes, (partType, pos, offset) -> {
            WorldBlockUpdateTask task = new WorldBlockUpdateTask(level, pos, ((Block)ModBlocks.BOUNDING_BOX.get()).m_49966_());
            task.setValidator(state -> PropertyProvider.isReplaceable(state) || state.m_60713_((Block)ModBlocks.BOUNDING_BOX.get()));
            task.setModifier(state -> this.setupBoundingBox(level, pos, offset, partType));
            return task;
        });
    }

    private void setupBoundingBox(Level level, BlockPos pos, OpenVector3i offset, SkinPartType partType) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BoundingBoxBlockEntity) {
            BoundingBoxBlockEntity blockEntity2 = (BoundingBoxBlockEntity)blockEntity;
            blockEntity2.setPartType(partType);
            blockEntity2.setGuide(offset);
            blockEntity2.setParent(pos.m_121996_((Vec3i)this.m_58899_()));
            BlockUtils.combine(blockEntity2, blockEntity2::sendBlockUpdates);
        }
    }

    private void applyBoundingBoxes(@Nullable Collection<BoundingBox> boxes, IUpdateTaskBuilder builder) {
        if (boxes == null || boxes.isEmpty()) {
            return;
        }
        CubeTransform transform = this.getTransform();
        boxes.forEach(box -> box.forEach((ix, iy, iz) -> {
            BlockPos target = transform.mul(ix + box.x(), iy + box.y(), iz + box.z());
            ix = box.width() - ix - 1;
            iy = box.height() - iy - 1;
            SkinPartType partType = box.getPartType();
            IWorldUpdateTask task = builder.build(partType, target, new OpenVector3i(ix, iy, iz));
            if (task != null) {
                WorldUpdater.getInstance().submit(task);
            }
        }));
    }

    private Collection<BoundingBox> getBoundingBoxes() {
        ArrayList<BoundingBox> boxes = new ArrayList<BoundingBox>();
        for (SkinPartType skinPartType : this.skinType.getParts()) {
            if (!this.shouldAddBoundingBoxes(skinPartType)) continue;
            OpenVector3i offset = skinPartType.getOffset();
            OpenRectangle3i bounds = skinPartType.getBuildingSpace();
            OpenRectangle3i rect = new OpenRectangle3i(skinPartType.getGuideSpace());
            rect = rect.offset(-offset.x(), -offset.y() - bounds.minY(), offset.z());
            boxes.add(new BoundingBox(skinPartType, rect));
        }
        return boxes;
    }

    private Collection<BoundingBox> getFullBoundingBoxes() {
        ArrayList<BoundingBox> boxes = new ArrayList<BoundingBox>();
        for (SkinPartType skinPartType : this.skinType.getParts()) {
            if (!this.shouldAddBoundingBoxes(skinPartType)) continue;
            OpenVector3i origin = skinPartType.getOffset();
            OpenRectangle3i buildSpace = skinPartType.getBuildingSpace();
            int dx = -origin.x() + buildSpace.x();
            int dy = -origin.y();
            int dz = origin.z() + buildSpace.z();
            OpenRectangle3i rect = new OpenRectangle3i(dx, dy, dz, buildSpace.width(), buildSpace.height(), buildSpace.depth());
            boxes.add(new BoundingBox(skinPartType, rect));
        }
        return boxes;
    }

    public Direction getFacing() {
        return this.m_58900_().m_61145_((Property)ArmourerBlock.f_54117_).orElse(Direction.NORTH);
    }

    public CubeTransform getTransform() {
        BlockPos pos = this.m_58899_().m_7918_(0, 1, 0);
        return new CubeTransform(this.m_58904_(), pos, this.getFacing());
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<SkinType> SKIN_TYPE = IDataSerializerKey.create("SkinType", SkinTypes.CODEC, SkinTypes.UNKNOWN);
        public static final IDataSerializerKey<SkinProperties> SKIN_PROPERTIES = IDataSerializerKey.create("SkinProperties", SkinProperties.CODEC, SkinProperties.EMPTY, SkinProperties.EMPTY::copy);
        public static final IDataSerializerKey<EntityTextureDescriptor> PLAYER_TEXTURE = IDataSerializerKey.create("Texture", EntityTextureDescriptor.CODEC, EntityTextureDescriptor.EMPTY);
        public static final IDataSerializerKey<SkinPaintData> PAINT_DATA = IDataSerializerKey.create("PaintData", DataSerializers.COMPRESSED_PAINT_DATA, null);
        public static final IDataSerializerKey<Integer> FLAGS = IDataSerializerKey.create("Flags", IDataCodec.INT, 0);
        public static final IDataSerializerKey<Integer> VERSION = IDataSerializerKey.create("DataVersion", IDataCodec.INT, 0);

        private CodingKeys() {
        }
    }

    public static interface IUpdateTaskBuilder {
        public IWorldUpdateTask build(SkinPartType var1, BlockPos var2, OpenVector3i var3);
    }
}

