/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.blockentity;

import com.mojang.authlib.GameProfile;
import java.util.Collection;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.builder.other.BlockUtils;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.player.Player.ABI;
import moe.plushie.armourers_workshop.core.blockentity.UpdatableBlockEntity;
import moe.plushie.armourers_workshop.core.data.UserNotifications;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocument;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentExporter;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentImporter;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentListeners;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentProvider;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentSynchronizer;
import moe.plushie.armourers_workshop.core.skin.serializer.exception.TranslatableException;
import moe.plushie.armourers_workshop.core.utils.OpenItemTransforms;
import moe.plushie.armourers_workshop.core.utils.SkinUtils;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class AdvancedBuilderBlockEntity
extends UpdatableBlockEntity
implements SkinDocumentProvider {
    private AABB renderBoundingBox;
    public final OpenVector3f carmeOffset = new OpenVector3f();
    public final OpenVector3f carmeRot = new OpenVector3f();
    public final OpenVector3f carmeScale = new OpenVector3f(1.0f, 1.0f, 1.0f);
    public OpenVector3f offset = new OpenVector3f(0.0f, 12.0f, 0.0f);
    private final SkinDocument document = new SkinDocument();

    public OpenVector3f getRenderOrigin() {
        BlockPos pos = this.m_58899_();
        return new OpenVector3f((float)pos.m_123341_() + this.offset.x() + 0.5f, (float)pos.m_123342_() + this.offset.y() + 0.5f, (float)pos.m_123343_() + this.offset.z() + 0.5f);
    }

    public AdvancedBuilderBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
        this.document.addListener(new SkinDocumentListeners.Updater(this));
    }

    @Override
    public void readAdditionalData(IDataSerializer serializer) {
        this.document.deserialize(serializer);
    }

    @Override
    public void writeAdditionalData(IDataSerializer serializer) {
        this.document.serialize(serializer);
    }

    public void importToNode(String identifier, Skin skin, SkinDocumentNode node) {
        SkinDocumentSynchronizer synchronizer = new SkinDocumentSynchronizer(this, false);
        this.document.addListener(synchronizer);
        node.setSkin(new SkinDescriptor(identifier, skin.getType()));
        this.document.removeListener(synchronizer);
        if (skin.getItemTransforms() != null) {
            this.importToSettings(skin.getItemTransforms(), node);
        }
    }

    private void importToSettings(OpenItemTransforms itemTransforms, SkinDocumentNode node) {
        Collection<String> overrideNames;
        OpenItemTransforms newItemTransforms = new OpenItemTransforms();
        if (this.document.getItemTransforms() != null) {
            newItemTransforms.putAll(this.document.getItemTransforms());
        }
        if (!(overrideNames = SkinUtils.getItemOverrides(node.getType())).isEmpty()) {
            overrideNames.forEach(name -> itemTransforms.forEach((type, transform) -> newItemTransforms.put(name + ";" + type, transform)));
        } else {
            newItemTransforms.putAll(itemTransforms);
        }
        SkinDocumentSynchronizer synchronizer = new SkinDocumentSynchronizer(this, false);
        this.document.addListener(synchronizer);
        this.document.setItemTransforms(newItemTransforms);
        this.document.removeListener(synchronizer);
    }

    public void importToDocument(String identifier, Skin skin) {
        BlockUtils.performBatch(() -> {
            SkinDocumentImporter importer = new SkinDocumentImporter(this.document);
            this.document.reset();
            this.document.setItemTransforms(skin.getItemTransforms());
            importer.execute(identifier, skin);
        });
    }

    public void exportFromDocument(ServerPlayer player, GameProfile profile) {
        SkinDocumentExporter exporter = new SkinDocumentExporter(this.document);
        exporter.setItemTransforms(this.document.getItemTransforms());
        EnvironmentExecutor.runOnBackground(() -> () -> {
            try {
                Skin skin = exporter.execute((Player)player, profile);
                player.f_8924_.execute(() -> {
                    String identifier = SkinLoader.getInstance().saveSkin("", skin);
                    SkinDescriptor descriptor = new SkinDescriptor(identifier, skin.getType());
                    ItemStack itemStack = descriptor.asItemStack();
                    ABI.giveItem((Player)player, itemStack);
                });
            }
            catch (TranslatableException exception) {
                UserNotifications.sendErrorMessage(exception.getComponent(), (Player)player);
            }
        });
    }

    @Override
    public SkinDocument getDocument() {
        return this.document;
    }

    @Override
    public AABB getVisibleBox(BlockState blockState) {
        if (this.renderBoundingBox != null) {
            return this.renderBoundingBox;
        }
        float s = 16.0f;
        OpenVector3f origin = this.getRenderOrigin();
        OpenRectangle3f rect = new OpenRectangle3f(origin.x() - s / 2.0f, origin.y() - s / 2.0f, origin.z() - s / 2.0f, s, s, s);
        this.renderBoundingBox = new AABB((double)rect.minX(), (double)rect.minY(), (double)rect.minZ(), (double)rect.maxX(), (double)rect.maxY(), (double)rect.maxZ());
        return this.renderBoundingBox;
    }
}

