/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.block;

import moe.plushie.armourers_workshop.api.common.IBlockEntityType;
import moe.plushie.armourers_workshop.api.common.IBlockTintColorProvider;
import moe.plushie.armourers_workshop.api.common.IPaintable;
import moe.plushie.armourers_workshop.api.skin.texture.ISkinPaintColor;
import moe.plushie.armourers_workshop.compatibility.core.AbstractBlockEntityProvider;
import moe.plushie.armourers_workshop.compatibility.core.AbstractHorizontalBlock;
import moe.plushie.armourers_workshop.core.data.OptionalDirection;
import moe.plushie.armourers_workshop.init.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class SkinCubeBlock
extends AbstractHorizontalBlock
implements AbstractBlockEntityProvider,
IBlockTintColorProvider {
    public static final DirectionProperty MARKER = DirectionProperty.m_61549_((String)"marker", (Direction[])Direction.values());
    public static final BooleanProperty HAS_MARKER = BooleanProperty.m_61465_((String)"has_marker");

    public SkinCubeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HAS_MARKER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)MARKER, (Comparable)Direction.NORTH));
    }

    public static OptionalDirection getMarker(BlockState blockState) {
        if (blockState.m_61145_((Property)HAS_MARKER).orElse(false).booleanValue()) {
            return OptionalDirection.of((Direction)blockState.m_61143_((Property)MARKER));
        }
        return OptionalDirection.NONE;
    }

    public static BlockState setMarker(BlockState blockState, OptionalDirection direction) {
        Direction dir = direction.getDirection();
        if (dir != null) {
            return (BlockState)((BlockState)blockState.m_61124_((Property)HAS_MARKER, (Comparable)Boolean.valueOf(true))).m_61124_((Property)MARKER, (Comparable)dir);
        }
        return (BlockState)blockState.m_61124_((Property)HAS_MARKER, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public BlockEntity createBlockEntity(BlockGetter level, BlockPos blockPos, BlockState blockState) {
        return ((IBlockEntityType)ModBlockEntityTypes.SKIN_CUBE.get()).create(level, blockPos, blockState);
    }

    public boolean m_6104_(BlockState state, BlockState state1, Direction dir) {
        return state.m_60734_() == state1.m_60734_();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{MARKER});
        builder.m_61104_(new Property[]{HAS_MARKER});
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        Direction facing = rotation.m_55954_((Direction)blockState.m_61143_((Property)f_54117_));
        Direction marker = rotation.m_55954_((Direction)blockState.m_61143_((Property)MARKER));
        return (BlockState)((BlockState)blockState.m_61124_((Property)f_54117_, (Comparable)facing)).m_61124_((Property)MARKER, (Comparable)marker);
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return this.m_6843_(blockState, mirror.m_54846_((Direction)blockState.m_61143_((Property)f_54117_)));
    }

    public boolean m_7420_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return true;
    }

    @Override
    public int getTintColor(BlockState blockState, @Nullable BlockGetter reader, @Nullable BlockPos blockPos, int index) {
        IPaintable paintable;
        ISkinPaintColor paintColor;
        BlockEntity blockEntity;
        if (reader == null || blockPos == null) {
            return -1;
        }
        Direction direction = Direction.NORTH;
        if (index > 0 && index < 7) {
            direction = Direction.values()[index - 1];
        }
        if ((blockEntity = reader.m_7702_(blockPos)) instanceof IPaintable && (paintColor = (paintable = (IPaintable)blockEntity).getColor(direction)) != null) {
            return paintColor.getRGB() | 0xFF000000;
        }
        return -1;
    }
}

