/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.api.core;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.compatibility.core.data.AbstractDataSerializer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public interface IDataCodec<A> {
    public static final IDataCodec<Boolean> BOOL = IDataCodec.wrap(Codec.BOOL);
    public static final IDataCodec<Byte> BYTE = IDataCodec.wrap(Codec.BYTE);
    public static final IDataCodec<Short> SHORT = IDataCodec.wrap(Codec.SHORT);
    public static final IDataCodec<Integer> INT = IDataCodec.wrap(Codec.INT);
    public static final IDataCodec<Long> LONG = IDataCodec.wrap(Codec.LONG);
    public static final IDataCodec<Float> FLOAT = IDataCodec.wrap(Codec.FLOAT);
    public static final IDataCodec<Double> DOUBLE = IDataCodec.wrap(Codec.DOUBLE);
    public static final IDataCodec<String> STRING = IDataCodec.wrap(Codec.STRING);
    public static final IDataCodec<ByteBuffer> BYTE_BUFFER = IDataCodec.wrap(Codec.BYTE_BUFFER);
    public static final IDataCodec<UUID> UUID = INT.listOf().xmap(it -> {
        long l = (long)((Integer)it.get(0)).intValue() << 32 | (long)((Integer)it.get(1)).intValue() & 0xFFFFFFFFL;
        long m = (long)((Integer)it.get(2)).intValue() << 32 | (long)((Integer)it.get(3)).intValue() & 0xFFFFFFFFL;
        return new UUID(l, m);
    }, it -> {
        ArrayList<Integer> result = new ArrayList<Integer>();
        long l = it.getMostSignificantBits();
        long m = it.getLeastSignificantBits();
        result.add((int)(l >> 32));
        result.add((int)l);
        result.add((int)(m >> 32));
        result.add((int)m);
        return result;
    });
    public static final IDataCodec<BlockPos> BLOCK_POS = IDataCodec.wrap(BlockPos.f_121852_).alternative(LONG, BlockPos::m_122022_);
    public static final IDataCodec<GlobalPos> GLOBAL_POS = IDataCodec.wrap(GlobalPos.f_122633_);
    public static final IDataCodec<CompoundTag> COMPOUND_TAG = IDataCodec.wrap(CompoundTag.f_128325_);
    public static final IDataCodec<ItemStack> ITEM_STACK = IDataCodec.wrap(ItemStack.f_41582_);

    public Codec<A> codec();

    public static <T> IDataCodec<T> wrap(Codec<T> codec) {
        return () -> codec;
    }

    public static <T> Field<T> wrap(MapCodec<T> codec) {
        return () -> IDataCodec.wrap(codec.codec());
    }

    public static <F, S> IDataCodec<Pair<F, S>> pair(IDataCodec<F> first, IDataCodec<S> second) {
        return IDataCodec.wrap(Codec.pair(first.codec(), second.codec()));
    }

    public static <F, S> IDataCodec<Either<F, S>> either(IDataCodec<F> first, IDataCodec<S> second) {
        return IDataCodec.wrap(Codec.either(first.codec(), second.codec()));
    }

    default public IDataCodec<List<A>> listOf() {
        return IDataCodec.wrap(this.codec().listOf());
    }

    default public <S> IDataCodec<S> xmap(Function<? super A, ? extends S> to, Function<? super S, ? extends A> from) {
        return IDataCodec.wrap(this.codec().xmap(to, from));
    }

    default public <T> IDataCodec<A> alternative(IDataCodec<T> alternative, Function<T, A> converter) {
        return IDataCodec.either(this, alternative).xmap(either -> either.map(v -> v, converter), Either::left);
    }

    default public <T extends IDataSerializable.Immutable> IDataCodec<T> serializer(Function<? super IDataSerializer, ? extends T> factory) {
        return this.xmap(tag -> {
            AbstractDataSerializer serializer = AbstractDataSerializer.wrap((CompoundTag)tag);
            return (IDataSerializable.Immutable)factory.apply(serializer);
        }, it -> {
            CompoundTag tag = new CompoundTag();
            it.serialize(AbstractDataSerializer.wrap(tag));
            return tag;
        });
    }

    default public Field<A> fieldOf(String name) {
        return IDataCodec.wrap(this.codec().fieldOf(name));
    }

    default public Field<Optional<A>> optionalFieldOf(String name) {
        return IDataCodec.wrap(this.codec().optionalFieldOf(name));
    }

    default public Field<A> optionalFieldOf(String name, A defaultValue) {
        return IDataCodec.wrap(this.codec().optionalFieldOf(name, defaultValue));
    }

    public static interface Field<A> {
        public IDataCodec<A> codec();
    }
}

