/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.uikit;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSRange;
import com.apple.library.foundation.NSString;
import com.apple.library.foundation.NSTextPosition;
import com.apple.library.foundation.NSTextRange;
import com.apple.library.impl.AppearanceImpl;
import com.apple.library.impl.DelegateImpl;
import com.apple.library.impl.TextInputImpl;
import com.apple.library.impl.TextInputTraits;
import com.apple.library.impl.TextStorageImpl;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIEdgeInsets;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIFont;
import com.apple.library.uikit.UIScreen;
import com.apple.library.uikit.UITextFieldDelegate;
import com.apple.library.uikit.UIWindow;

public class UITextField
extends UIControl
implements TextInputTraits {
    private final TextStorageImpl storage = new TextStorageImpl();
    private final TextInputImpl input = new TextInputImpl(this.storage);
    private final DelegateImpl<UITextFieldDelegate> delegate = DelegateImpl.of(new UITextFieldDelegate(){});
    private UIEdgeInsets contentInsets = new UIEdgeInsets(2.0f, 4.0f, 2.0f, 4.0f);
    private boolean isBordered = true;

    public UITextField(CGRect frame) {
        super(frame);
        this.storage.setBoundingSize(CGSize.ZERO);
        this.storage.setLineSpacing(1);
        this.storage.maxLength = 32;
        this.storage.sizeDidChange = this::sizeDidChange;
        this.storage.selectionDidChange = this::selectionDidChange;
        this.storage.valueDidChange = this::valueDidChange;
        this.storage.valueShouldChange = this::valueShouldChange;
        this.input.returnHandler = this::shouldReturn;
    }

    @Override
    public void mouseDown(UIEvent event) {
        if (!this.storage.isFocused()) {
            this.becomeFirstResponder();
        }
        if (this.shouldInputText()) {
            this.input.mouseDown(event.locationInView(this));
        }
    }

    @Override
    public void keyDown(UIEvent event) {
        if (this.shouldInputText() && this.input.keyDown(event.key)) {
            return;
        }
        if (this.isFocused() && event.key == 256) {
            this.resignFirstResponder();
            return;
        }
        super.keyDown(event);
    }

    @Override
    public void charTyped(UIEvent event) {
        if (this.shouldInputText() && this.input.charTyped((char)event.key)) {
            return;
        }
        super.charTyped(event);
    }

    @Override
    public void render(CGPoint point, CGGraphicsContext context) {
        super.render(point, context);
        CGRect bounds = this.bounds();
        CGRect fixedBounds = bounds.insetBy(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.isBordered) {
            context.fillRect(bounds, this.getBorderColor());
            context.fillRect(fixedBounds, this.getFillColor());
        }
        context.addClip(UIScreen.convertRectFromView(fixedBounds, this));
        this.storage.render(point, context);
        context.removeClip();
    }

    public boolean isEditable() {
        return this.input.isEditable();
    }

    public void setEditable(boolean isEditable) {
        this.input.setEditable(isEditable);
    }

    public UIFont font() {
        return this.storage.font();
    }

    public void setFont(UIFont font) {
        this.storage.setFont(font);
    }

    public NSString placeholder() {
        return this.storage.placeholder();
    }

    public void setPlaceholder(NSString placeholder) {
        this.storage.setPlaceholder(placeholder);
    }

    public UIColor placeholderColor() {
        return this.storage.placeholderColor();
    }

    public void setPlaceholderColor(UIColor placeholderColor) {
        this.storage.setPlaceholderColor(placeholderColor);
    }

    public String text() {
        return this.storage.value();
    }

    public void setText(String text) {
        this.storage.setValue(text);
        this.storage.checkCursorAndHighlightPos();
    }

    public UIColor textColor() {
        return this.storage.textColor();
    }

    public void setTextColor(UIColor textColor) {
        this.storage.setTextColor(textColor);
    }

    public NSTextRange selectedTextRange() {
        return this.storage.selectedTextRange();
    }

    public void setSelectedTextRange(NSTextRange range) {
        this.storage.setSelectedTextRange(range);
    }

    public UITextFieldDelegate delegate() {
        return this.delegate.get();
    }

    public void setDelegate(UITextFieldDelegate delegate) {
        this.delegate.set(delegate);
    }

    public boolean isEditing() {
        return this.storage.isFocused();
    }

    @Override
    public void becomeFirstResponder() {
        if (this.storage.isFocused() || !this.isEditable()) {
            return;
        }
        UIWindow window = this.window();
        if (window != null) {
            if (!this.delegate.invoker().textFieldShouldBeginEditing(this)) {
                return;
            }
            window.setFirstInputResponder(this);
            this.storage.setFocused(true);
            this.sendEvent(UIControl.Event.EDITING_DID_BEGIN);
            this.delegate.invoker().textFieldDidBeginEditing(this);
        }
    }

    @Override
    public void resignFirstResponder() {
        if (!this.storage.isFocused()) {
            return;
        }
        if (!this.delegate.invoker().textFieldShouldEndEditing(this)) {
            return;
        }
        UIWindow window = this.window();
        if (window != null) {
            window.setFirstInputResponder(null);
        }
        this.storage.setFocused(false);
        this.sendEvent(UIControl.Event.EDITING_DID_END);
        this.delegate.invoker().textFieldDidEndEditing(this);
    }

    public NSTextPosition beginOfDocument() {
        return this.storage.beginOfDocument();
    }

    public NSTextPosition endOfDocument() {
        return this.storage.endOfDocument();
    }

    public int maxLength() {
        return this.storage.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.storage.maxLength = maxLength;
    }

    public UIEdgeInsets contentInsets() {
        return this.contentInsets;
    }

    public void setContentInsets(UIEdgeInsets contentInsets) {
        this.contentInsets = contentInsets;
    }

    @Override
    public boolean canBecomeFocused() {
        return !this._ignoresTouchEvents(this) && this.input.isEditable();
    }

    public void setBordered(boolean bordered) {
        this.isBordered = bordered;
    }

    private boolean shouldReturn(String value) {
        return this.delegate.invoker().textFieldShouldReturn(this);
    }

    private boolean valueShouldChange(NSRange range, String newValue) {
        return this.delegate.invoker().textFieldShouldChangeCharacters(this, range, newValue);
    }

    private void valueDidChange(String oldValue, String newValue) {
        this.sendEvent(UIControl.Event.VALUE_CHANGED);
    }

    private void selectionDidChange() {
        this.delegate.invoker().textFieldDidChangeSelection(this);
    }

    private void sizeDidChange(CGRect rect, CGSize size) {
        CGRect bounds = this.bounds().insetBy(this.contentInsets);
        CGRect cursorRect = rect.insetBy(0.0f, 0.0f, 0.0f, -5.0f);
        float offsetX = this.storage.offset.x;
        float offsetY = (bounds.height - size.height) / 2.0f;
        float contentWidth = size.width + cursorRect.width;
        CGRect visibleRect = bounds.offset(-offsetX, 0.0f);
        if (visibleRect.maxX() > contentWidth || !this.isSameRange(visibleRect, cursorRect)) {
            float x1 = Math.min(cursorRect.x + visibleRect.width / 2.0f, contentWidth);
            float x0 = Math.max(x1 - visibleRect.width, 0.0f);
            offsetX = this.contentInsets.left - x0;
        }
        this.storage.offset = new CGPoint(offsetX, this.contentInsets.top + offsetY + 1.0f);
    }

    private boolean isSameRange(CGRect rect, CGRect other) {
        return rect.minX() <= other.minX() && other.maxX() <= rect.maxX();
    }

    private UIColor getFillColor() {
        return AppearanceImpl.TEXT_BACKGROUND_COLOR;
    }

    private UIColor getBorderColor() {
        if (this.storage.isFocused()) {
            return AppearanceImpl.TEXT_FOCUSED_BORDER_COLOR;
        }
        return AppearanceImpl.TEXT_BORDER_COLOR;
    }

    private boolean shouldInputText() {
        return !this.isHidden() && this.storage.isFocused() && this.isUserInteractionEnabled() && this.isEditable();
    }
}

