/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.impl;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSTextAlignment;
import com.apple.library.uikit.UIEdgeInsets;
import java.util.ArrayList;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class SimpleContentLayoutImpl {
    private float contentWidth = 0.0f;
    private float contentHeight = 0.0f;
    private final ArrayList<Pair<CGRect, UIEdgeInsets>> rects = new ArrayList();
    private final ArrayList<CGRect> results = new ArrayList();

    public <T> void add(T target, UIEdgeInsets edg, Function<T, CGRect> transform) {
        if (target != null) {
            this.add(transform.apply(target), edg);
        } else {
            this.add(null, edg);
        }
    }

    public void add(@Nullable CGRect rect, UIEdgeInsets edg) {
        if (rect == null) {
            this.rects.add(null);
        } else {
            this.rects.add((Pair<CGRect, UIEdgeInsets>)Pair.of((Object)rect, (Object)edg));
        }
    }

    public void applyHorizontalLayout(CGRect bounds, UIEdgeInsets contentInsets, NSTextAlignment.Horizontal horizontalAlignment, NSTextAlignment.Vertical verticalAlignment) {
        this.results.clear();
        this.contentWidth = 0.0f;
        this.contentHeight = 0.0f;
        for (Pair<CGRect, UIEdgeInsets> pair : this.rects) {
            if (pair == null) continue;
            CGRect rect = (CGRect)pair.getKey();
            UIEdgeInsets edg = (UIEdgeInsets)pair.getValue();
            this.contentWidth = this.contentWidth + edg.left + rect.x + rect.width + edg.right;
            this.contentHeight = Math.max(this.contentHeight, edg.top + rect.y + rect.height + edg.bottom);
        }
        float x = bounds.x + contentInsets.left;
        float y = bounds.y + contentInsets.top;
        float width = bounds.width - contentInsets.left - contentInsets.right;
        float height = bounds.height - contentInsets.top - contentInsets.bottom;
        if (bounds == CGRect.ZERO) {
            width = this.contentWidth;
            height = this.contentHeight;
        }
        float dx = x + this.sel(width, this.contentWidth, horizontalAlignment);
        for (Pair<CGRect, UIEdgeInsets> pair : this.rects) {
            if (pair != null) {
                CGRect rect = (CGRect)pair.getKey();
                UIEdgeInsets edg = (UIEdgeInsets)pair.getValue();
                float dy = y + this.sel(height - edg.top - edg.bottom, rect.y + rect.height, verticalAlignment);
                this.results.add(new CGRect(dx + edg.left + rect.x, dy + edg.top + rect.y, rect.width, rect.height));
                dx += rect.width + edg.left + edg.right;
                continue;
            }
            this.results.add(null);
        }
        this.contentWidth = contentInsets.left + this.contentWidth + contentInsets.right;
        this.contentHeight = contentInsets.top + this.contentHeight + contentInsets.bottom;
    }

    public void applyVerticalLayout(CGRect bounds, UIEdgeInsets contentInsets, NSTextAlignment.Horizontal horizontalAlignment, NSTextAlignment.Vertical verticalAlignment) {
        this.results.clear();
        this.contentWidth = 0.0f;
        this.contentHeight = 0.0f;
        for (Pair<CGRect, UIEdgeInsets> pair : this.rects) {
            if (pair == null) continue;
            CGRect rect = (CGRect)pair.getKey();
            UIEdgeInsets edg = (UIEdgeInsets)pair.getValue();
            this.contentWidth = Math.max(this.contentWidth, edg.left + rect.x + rect.width + edg.right);
            this.contentHeight = this.contentHeight + edg.top + rect.y + rect.height + edg.bottom;
        }
        float x = bounds.x + contentInsets.left;
        float y = bounds.y + contentInsets.top;
        float width = bounds.width - contentInsets.left - contentInsets.right;
        float height = bounds.height - contentInsets.top - contentInsets.bottom;
        if (bounds == CGRect.ZERO) {
            width = this.contentWidth;
            height = this.contentHeight;
        }
        float dy = y + this.sel(height, this.contentHeight, verticalAlignment);
        for (Pair<CGRect, UIEdgeInsets> pair : this.rects) {
            if (pair != null) {
                CGRect rect = (CGRect)pair.getKey();
                UIEdgeInsets edg = (UIEdgeInsets)pair.getValue();
                float dx = x + this.sel(width - edg.left - edg.right, rect.x + rect.width, horizontalAlignment);
                this.results.add(new CGRect(dx + edg.left + rect.x, dy + edg.top + rect.y, rect.width, rect.height));
                dy += rect.height + edg.top + edg.bottom;
                continue;
            }
            this.results.add(null);
        }
        this.contentWidth = contentInsets.left + this.contentWidth + contentInsets.right;
        this.contentHeight = contentInsets.top + this.contentHeight + contentInsets.bottom;
    }

    public CGSize contentSize() {
        return new CGSize(this.contentWidth, this.contentHeight);
    }

    @Nullable
    public CGRect getOrDefault(int index, CGRect defaultValue) {
        CGRect rect;
        if (index >= 0 && index < this.results.size() && (rect = this.results.get(index)) != null) {
            return rect;
        }
        return defaultValue;
    }

    private float sel(float height, float value, NSTextAlignment.Vertical alignment) {
        return switch (alignment) {
            case NSTextAlignment.Vertical.BOTTOM -> height - value;
            case NSTextAlignment.Vertical.CENTER -> (height - value) / 2.0f;
            default -> 0.0f;
        };
    }

    private float sel(float width, float value, NSTextAlignment.Horizontal alignment) {
        return switch (alignment) {
            case NSTextAlignment.Horizontal.RIGHT -> width - value;
            case NSTextAlignment.Horizontal.CENTER -> (width - value) / 2.0f;
            default -> 0.0f;
        };
    }
}

