/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.impl;

import com.apple.library.coregraphics.CGGraphicsState;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIFont;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.systems.RenderSystem.Fix18;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.gui.Font.MatrixSupport;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.utils.RectangleTesselator;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.gui.Font;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface GraphicsContextImpl {
    public CGGraphicsState state();

    default public void drawText(NSString text, float x, float y, int textColor) {
        this.drawText(Collections.singleton(text), x, y, textColor, false, UIFont.systemFont(), 0.0f);
    }

    default public void drawText(NSString text, float x, float y, int textColor, UIFont font) {
        this.drawText(Collections.singleton(text), x, y, textColor, false, font, 0.0f);
    }

    default public void drawText(NSString text, float x, float y, int textColor, boolean shadow, UIFont font, float zLevel) {
        this.drawText(Collections.singleton(text), x, y, textColor, shadow, font, 0.0f);
    }

    default public void drawText(Collection<NSString> lines, float x, float y, int textColor, boolean shadow, UIFont font, float zLevel) {
        IPoseStack poseStack = this.state().ctm();
        float scale = font._getScale();
        poseStack.pushPose();
        poseStack.translate(x, y, zLevel);
        poseStack.scale(scale, scale, scale);
        PoseStack.Pose pose = AbstractPoseStack.unwrap(poseStack).m_85850_();
        AbstractBufferSource buffers = AbstractBufferSource.tesselator();
        Font renderer = font.impl();
        int dx = 0;
        int dy = 0;
        for (NSString line : lines) {
            int qx = MatrixSupport.drawInBatch(renderer, line.characters(), dx, dy, textColor, shadow, pose.m_252922_(), buffers.bufferSource(), false, 0, 0xF000F0);
            if (qx == dx) {
                dy += 7;
                continue;
            }
            dy += 10;
        }
        buffers.endBatch();
        poseStack.popPose();
        RenderSystem.disableBlend();
        Fix18.enableAlphaTest(RenderSystem.class);
        RenderSystem.defaultBlendFunc();
    }

    default public void drawMultilineText(NSString text, float x, float y, float maxWidth, int textColor, UIFont font) {
        this.drawMultilineText(Collections.singleton(text), x, y, maxWidth, textColor, false, font, 0.0f);
    }

    default public void drawMultilineText(NSString text, float x, float y, float maxWidth, int textColor, boolean shadow, UIFont font, float zLevel) {
        this.drawMultilineText(Collections.singleton(text), x, y, maxWidth, textColor, shadow, font, zLevel);
    }

    default public void drawMultilineText(Collection<NSString> lines, float x, float y, float maxWidth, int textColor, boolean shadow, UIFont font, float zLevel) {
        float scale = font.fontSize() / 9.0f;
        ArrayList<NSString> wrappedTextLines = new ArrayList<NSString>();
        for (NSString line : lines) {
            wrappedTextLines.addAll(line.split(font, maxWidth / scale));
        }
        this.drawText(wrappedTextLines, x, y, textColor, shadow, font, zLevel);
    }

    default public void drawImage(IResourceLocation texture, float x, float y, float width, float height, float u, float v, float texWidth, float texHeight) {
        this.drawResizableImage(texture, x, y, width, height, u, v, width, height, texWidth, texHeight, 0.0f);
    }

    default public void drawImage(IResourceLocation texture, float x, float y, float width, float height, float u, float v, float texWidth, float texHeight, float zLevel) {
        this.drawResizableImage(texture, x, y, width, height, u, v, width, height, texWidth, texHeight, zLevel);
    }

    default public void drawResizableImage(IResourceLocation rl, float x, float y, float width, float height, float u, float v, float sourceWidth, float sourceHeight, float texWidth, float texHeight) {
        this.drawResizableImage(rl, x, y, width, height, u, v, sourceWidth, sourceHeight, texWidth, texHeight, 0.0f);
    }

    default public void drawResizableImage(IResourceLocation rl, float x, float y, float width, float height, float u, float v, float sourceWidth, float sourceHeight, float texWidth, float texHeight, float zLevel) {
        RectangleTesselator tesselator = new RectangleTesselator(this.state());
        tesselator.begin(SkinRenderType.GUI_IMAGE, rl, texWidth, texHeight);
        tesselator.blit(x, y, width, height, u, v, sourceWidth, sourceHeight, zLevel);
        tesselator.end();
    }

    default public void drawTilableImage(IResourceLocation rl, float x, float y, float width, float height, float u, float v, float sourceWidth, float sourceHeight, float topBorder, float bottomBorder, float leftBorder, float rightBorder) {
        this.drawTilableImage(rl, x, y, width, height, u, v, sourceWidth, sourceHeight, 256.0f, 256.0f, topBorder, bottomBorder, leftBorder, rightBorder, 0.0f);
    }

    default public void drawTilableImage(IResourceLocation rl, float x, float y, float width, float height, float u, float v, float sourceWidth, float sourceHeight, float topBorder, float bottomBorder, float leftBorder, float rightBorder, float zLevel) {
        this.drawTilableImage(rl, x, y, width, height, u, v, sourceWidth, sourceHeight, 256.0f, 256.0f, topBorder, bottomBorder, leftBorder, rightBorder, zLevel);
    }

    default public void drawTilableImage(IResourceLocation rl, float x, float y, float width, float height, float u, float v, float sourceWidth, float sourceHeight, float texWidth, float texHeight, float topBorder, float bottomBorder, float leftBorder, float rightBorder, float zLevel) {
        float x0 = x + 0.0f;
        float y0 = y + 0.0f;
        float x3 = x0 + width;
        float y3 = y0 + height;
        float x1 = x0 + leftBorder;
        float y1 = y0 + topBorder;
        float x2 = x3 - rightBorder;
        float y2 = y3 - bottomBorder;
        float u0 = u + 0.0f;
        float v0 = v + 0.0f;
        float u3 = u0 + sourceWidth;
        float v3 = v0 + sourceHeight;
        float u1 = u0 + leftBorder;
        float v1 = v0 + topBorder;
        float u2 = u3 - rightBorder;
        float v2 = v3 - bottomBorder;
        RectangleTesselator tesselator = new RectangleTesselator(this.state());
        tesselator.begin(SkinRenderType.GUI_IMAGE, rl, texWidth, texHeight);
        tesselator.blit(x0, y0, x1 - x0, y1 - y0, u0, v0, zLevel);
        tesselator.blit(x2, y0, x3 - x2, y1 - y0, u2, v0, zLevel);
        tesselator.blit(x0, y2, x1 - x0, y3 - y2, u0, v2, zLevel);
        tesselator.blit(x2, y2, x3 - x2, y3 - y2, u2, v2, zLevel);
        tesselator.tile(x1, y0, x2 - x1, y1 - y0, u1, v0, u2 - u1, v1 - v0, zLevel);
        tesselator.tile(x1, y2, x2 - x1, y3 - y2, u1, v2, u2 - u1, v3 - v2, zLevel);
        tesselator.tile(x0, y1, x1 - x0, y2 - y1, u0, v1, u1 - u0, v2 - v1, zLevel);
        tesselator.tile(x2, y1, x3 - x2, y2 - y1, u2, v1, u3 - u2, v2 - v1, zLevel);
        tesselator.tile(x1, y1, x2 - x1, y2 - y1, u1, v1, u2 - u1, v2 - v1, zLevel);
        tesselator.end();
    }

    default public void drawColor(float minX, float minY, float maxX, float maxY, float zLevel, int color1, int color2) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        CGGraphicsState state = this.state();
        IPoseStack.Pose pose = state.ctm().last();
        IVertexConsumer buffer = state.bufferSource().getBuffer(SkinRenderType.GUI_COLOR);
        buffer.vertex(pose, minX, minY, zLevel).color(r1, g1, b1, a1).endVertex();
        buffer.vertex(pose, minX, maxY, zLevel).color(r2, g2, b2, a2).endVertex();
        buffer.vertex(pose, maxX, maxY, zLevel).color(r2, g2, b2, a2).endVertex();
        buffer.vertex(pose, maxX, minY, zLevel).color(r1, g1, b1, a1).endVertex();
        state.flush();
    }

    default public void drawBorder(float minX, float minY, float maxX, float maxY, float zLevel, int color) {
        int a1 = color >> 24 & 0xFF;
        int r1 = color >> 16 & 0xFF;
        int g1 = color >> 8 & 0xFF;
        int b1 = color & 0xFF;
        CGGraphicsState state = this.state();
        IPoseStack.Pose pose = state.ctm().last();
        IVertexConsumer buffer = state.bufferSource().getBuffer(SkinRenderType.lineStrip());
        buffer.vertex(pose, minX, minY, zLevel).color(r1, g1, b1, a1).endVertex();
        buffer.vertex(pose, minX, maxY, zLevel).color(r1, g1, b1, a1).endVertex();
        buffer.vertex(pose, maxX, maxY, zLevel).color(r1, g1, b1, a1).endVertex();
        buffer.vertex(pose, maxX, minY, zLevel).color(r1, g1, b1, a1).endVertex();
        buffer.vertex(pose, minX, minY, zLevel).color(r1, g1, b1, a1).endVertex();
        state.flush();
    }

    default public void drawBorder(float minX, float minY, float maxX, float maxY, float zLevel, float height, int color) {
        int a1 = color >> 24 & 0xFF;
        int r1 = color >> 16 & 0xFF;
        int g1 = color >> 8 & 0xFF;
        int b1 = color & 0xFF;
        float sp = height * 0.5f;
        CGGraphicsState state = this.state();
        IPoseStack.Pose pose = state.ctm().last();
        IVertexConsumer buffer = state.bufferSource().getBuffer(SkinRenderType.GUI_COLOR);
        buffer.vertex(pose, minX - sp, minY - sp, zLevel).color(r1, g1, b1, a1).endVertex();
        buffer.vertex(pose, minX - sp, maxY + sp, zLevel).color(r1, g1, b1, a1).endVertex();
        buffer.vertex(pose, minX + sp, maxY + sp, zLevel).color(r1, g1, b1, a1).endVertex();
        buffer.vertex(pose, minX + sp, minY - sp, zLevel).color(r1, g1, b1, a1).endVertex();
        buffer.vertex(pose, maxX - sp, minY - sp, zLevel).color(r1, g1, b1, a1).endVertex();
        buffer.vertex(pose, maxX - sp, maxY + sp, zLevel).color(r1, g1, b1, a1).endVertex();
        buffer.vertex(pose, maxX + sp, maxY + sp, zLevel).color(r1, g1, b1, a1).endVertex();
        buffer.vertex(pose, maxX + sp, minY - sp, zLevel).color(r1, g1, b1, a1).endVertex();
        buffer.vertex(pose, minX + sp, minY - sp, zLevel).color(r1, g1, b1, a1).endVertex();
        buffer.vertex(pose, minX + sp, minY + sp, zLevel).color(r1, g1, b1, a1).endVertex();
        buffer.vertex(pose, maxX - sp, minY + sp, zLevel).color(r1, g1, b1, a1).endVertex();
        buffer.vertex(pose, maxX - sp, minY - sp, zLevel).color(r1, g1, b1, a1).endVertex();
        buffer.vertex(pose, minX + sp, maxY - sp, zLevel).color(r1, g1, b1, a1).endVertex();
        buffer.vertex(pose, minX + sp, maxY + sp, zLevel).color(r1, g1, b1, a1).endVertex();
        buffer.vertex(pose, maxX - sp, maxY + sp, zLevel).color(r1, g1, b1, a1).endVertex();
        buffer.vertex(pose, maxX - sp, maxY - sp, zLevel).color(r1, g1, b1, a1).endVertex();
        state.flush();
    }
}

