/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.network;

import dev.quarris.ppfluids.misc.FluidFilter;
import dev.quarris.ppfluids.network.PacketHandler;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.util.TriConsumer;

public class FluidButtonPacket {
    private BlockPos pos;
    private ButtonResult result;
    private int[] data;

    public FluidButtonPacket(BlockPos pos, ButtonResult result, int ... data) {
        this.pos = pos;
        this.result = result;
        this.data = data;
    }

    private FluidButtonPacket() {
    }

    public static FluidButtonPacket decode(FriendlyByteBuf buf) {
        FluidButtonPacket packet = new FluidButtonPacket();
        packet.pos = buf.m_130135_();
        packet.result = ButtonResult.values()[buf.readByte()];
        packet.data = buf.m_130100_();
        return packet;
    }

    public static void encode(FluidButtonPacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.pos);
        buf.writeByte(packet.result.ordinal());
        buf.m_130089_(packet.data);
    }

    public static void handle(FluidButtonPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            message.result.action.accept((Object)message.pos, (Object)message.data, (Object)player);
        });
        ctx.get().setPacketHandled(true);
    }

    public static void sendAndExecute(BlockPos pos, ButtonResult result, int ... data) {
        PacketHandler.sendToServer(new FluidButtonPacket(pos, result, data));
        result.action.accept((Object)pos, (Object)data, (Object)Minecraft.m_91087_().f_91074_);
    }

    public static enum ButtonResult {
        FILTER_CHANGE((TriConsumer<BlockPos, int[], Player>)((TriConsumer)(pos, data, player) -> {
            FluidFilter.IFluidFilteredContainer container = (FluidFilter.IFluidFilteredContainer)player.f_36096_;
            FluidFilter filter = container.getFilter();
            filter.onButtonPacket(container, data[0]);
        }));

        public final TriConsumer<BlockPos, int[], Player> action;

        private ButtonResult(TriConsumer<BlockPos, int[], Player> action) {
            this.action = action;
        }
    }
}

