/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.util;

import com.direwolf20.buildinggadgets2.common.blocks.RenderBlock;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import com.direwolf20.buildinggadgets2.datagen.BG2BlockTags;
import com.direwolf20.buildinggadgets2.setup.Registration;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GadgetUtils {
    private static final ImmutableList<Property<?>> DENY_PROPERTIES = ImmutableList.of((Object)BlockStateProperties.f_61405_, (Object)BlockStateProperties.f_61406_, (Object)BlockStateProperties.f_61407_, (Object)BlockStateProperties.f_222999_, (Object)BlockStateProperties.f_61408_, (Object)BlockStateProperties.f_61409_, (Object)BlockStateProperties.f_61410_, (Object)BlockStateProperties.f_61411_, (Object)DoublePlantBlock.f_52858_, (Object)BlockStateProperties.f_61362_, (Object)BlockStateProperties.f_61443_, (Object)BlockStateProperties.f_61439_, (Object[])new Property[]{BlockStateProperties.f_61440_, BlockStateProperties.f_61446_, BlockStateProperties.f_61387_});

    public static boolean isValidBlockState(BlockState blockState, Level level, BlockPos blockPos) {
        if (blockState.m_204336_(BG2BlockTags.BG2DENY)) {
            return false;
        }
        if (blockState.m_60800_((BlockGetter)level, blockPos) < 0.0f) {
            return false;
        }
        return blockState.m_60819_().m_76178_() || blockState.m_60819_().m_76170_();
    }

    public static boolean isValidDestroyBlockState(BlockState blockState, Level level, BlockPos blockPos) {
        if (blockState.m_60795_()) {
            return false;
        }
        if (blockState.m_60800_((BlockGetter)level, blockPos) < 0.0f) {
            return false;
        }
        return !(blockState.m_60734_() instanceof RenderBlock);
    }

    public static boolean setBlockState(ItemStack gadget, BlockState blockState) {
        BlockState placeState = GadgetUtils.cleanBlockState(blockState);
        GadgetNBT.setGadgetBlockState(gadget, placeState);
        return true;
    }

    public static ItemStack getSimpleItemForBlock(BlockState blockState) {
        return new ItemStack((ItemLike)blockState.m_60734_());
    }

    public static ItemStack getItemForBlock(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        return blockState.getCloneItemStack((HitResult)new BlockHitResult(Vec3.f_82478_, Direction.UP, blockPos, false), (BlockGetter)level, blockPos, player);
    }

    public static List<ItemStack> getDropsForBlockState(ServerLevel level, BlockPos blockPos, BlockState blockState, Player player) {
        ItemStack tempStack = new ItemStack((ItemLike)Registration.Exchanging_Gadget.get());
        tempStack.m_41663_(Enchantments.f_44985_, 1);
        ArrayList<ItemStack> drops = new ArrayList();
        try {
            drops = new ArrayList<ItemStack>(GadgetUtils.getDropsForBlockStateGadget(level, blockPos, blockState, tempStack));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ItemStack baseItem = player != null ? GadgetUtils.getItemForBlock(blockState, (Level)level, blockPos, player) : GadgetUtils.getSimpleItemForBlock(blockState);
        if (drops.stream().filter(e -> ItemStack.m_41656_((ItemStack)e, (ItemStack)baseItem)).toList().isEmpty()) {
            drops = new ArrayList();
            if (!baseItem.m_41619_()) {
                drops.add(baseItem);
            }
            return drops;
        }
        return drops;
    }

    public static List<ItemStack> getDropsForBlockStateGadget(ServerLevel level, BlockPos blockPos, BlockState blockState, ItemStack gadget) {
        LootParams.Builder builder = new LootParams.Builder(level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockPos)).m_287286_(LootContextParams.f_81463_, (Object)gadget);
        return blockState.m_287290_(builder);
    }

    public static BlockState cleanBlockState(BlockState sourceState) {
        BlockState placeState = sourceState.m_60734_().m_49966_();
        for (Property prop : sourceState.m_61147_()) {
            if (DENY_PROPERTIES.contains((Object)prop)) continue;
            placeState = GadgetUtils.applyProperty(placeState, sourceState, prop);
        }
        return placeState;
    }

    public static void addToUndoList(Level level, ItemStack gadget, ArrayList<StatePos> buildList, UUID uuid) {
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(level.m_7654_()).m_129783_());
        bg2Data.addToUndoList(uuid, buildList, level);
        GadgetNBT.addToUndoList(gadget, uuid, bg2Data);
    }

    public static void addToUndoList(Level level, ItemStack gadget, ArrayList<StatePos> buildList) {
        GadgetUtils.addToUndoList(level, gadget, buildList, UUID.randomUUID());
    }

    private static <T extends Comparable<T>> BlockState applyProperty(BlockState state, BlockState from, Property<T> prop) {
        return (BlockState)state.m_61124_(prop, from.m_61143_(prop));
    }

    public static AABB getSquareArea(BlockPos pos, Direction face, int range) {
        switch (face) {
            case UP: 
            case DOWN: {
                return new AABB((double)(pos.m_123341_() - range), (double)pos.m_123342_(), (double)(pos.m_123343_() - range), (double)(pos.m_123341_() + range), (double)pos.m_123342_(), (double)(pos.m_123343_() + range));
            }
            case NORTH: 
            case SOUTH: {
                return new AABB((double)(pos.m_123341_() - range), (double)(pos.m_123342_() - range), (double)pos.m_123343_(), (double)(pos.m_123341_() + range), (double)(pos.m_123342_() + range), (double)pos.m_123343_());
            }
            case EAST: 
            case WEST: {
                return new AABB((double)pos.m_123341_(), (double)(pos.m_123342_() - range), (double)(pos.m_123343_() - range), (double)pos.m_123341_(), (double)(pos.m_123342_() + range), (double)(pos.m_123343_() + range));
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf(face));
    }

    public static ArrayList<StatePos> getDestructionArea(Level level, BlockPos pos, Direction face, Player player, ItemStack gadget) {
        int depth = GadgetNBT.getToolValue(gadget, "depth");
        if (gadget.m_41619_() || depth == 0 || !player.m_36326_()) {
            return new ArrayList<StatePos>();
        }
        boolean vertical = face.m_122434_().m_122478_();
        Direction up = vertical ? player.m_6350_() : Direction.UP;
        Direction down = up.m_122424_();
        Direction right = vertical ? up.m_122427_() : face.m_122428_();
        Direction left = right.m_122424_();
        BlockPos first = pos.m_5484_(left, GadgetNBT.getToolValue(gadget, "left")).m_5484_(up, GadgetNBT.getToolValue(gadget, "up"));
        BlockPos second = pos.m_5484_(right, GadgetNBT.getToolValue(gadget, "right")).m_5484_(down, GadgetNBT.getToolValue(gadget, "down")).m_5484_(face.m_122424_(), depth - 1);
        AABB box = new AABB(first, second);
        ArrayList<StatePos> returnList = new ArrayList<StatePos>();
        BlockPos.m_121921_((AABB)box).map(BlockPos::m_7949_).forEach(blockPos -> {
            BlockState blockState = level.m_8055_(blockPos);
            if (blockState.m_155947_() && !GadgetNBT.getSetting(gadget, "affecttiles")) {
                return;
            }
            if (GadgetUtils.isValidDestroyBlockState(blockState, level, blockPos)) {
                returnList.add(new StatePos(blockState, (BlockPos)blockPos));
            }
        });
        return returnList;
    }

    public static boolean direContains(AABB aabb, double x, double y, double z) {
        return x >= aabb.f_82288_ && x <= aabb.f_82291_ && y >= aabb.f_82289_ && y <= aabb.f_82292_ && z >= aabb.f_82290_ && z <= aabb.f_82293_;
    }

    public static boolean direContains(AABB aabb, BlockPos pos) {
        return GadgetUtils.direContains(aabb, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }
}

