/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.collectibles.world;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Random;
import java.util.Scanner;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.language.IModInfo;
import xxrexraptorxx.collectibles.main.Collectibles;
import xxrexraptorxx.collectibles.registry.ModItems;
import xxrexraptorxx.collectibles.utils.CollectibleHelper;
import xxrexraptorxx.collectibles.utils.Config;

@Mod.EventBusSubscriber(modid="collectibles", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Events {
    private static boolean hasShownUp = false;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (Config.UPDATE_CHECKER.get() != null && ((Boolean)Config.UPDATE_CHECKER.get()).booleanValue() && !hasShownUp && Minecraft.m_91087_().f_91080_ == null) {
            if (VersionChecker.getResult((IModInfo)((ModContainer)ModList.get().getModContainerById("collectibles").get()).getModInfo()).status() == VersionChecker.Status.OUTDATED || VersionChecker.getResult((IModInfo)((ModContainer)ModList.get().getModContainerById("collectibles").get()).getModInfo()).status() == VersionChecker.Status.BETA_OUTDATED) {
                MutableComponent url = Component.m_237113_((String)(ChatFormatting.GREEN + "Click here to update!"));
                url.m_130948_(url.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/collectibles")));
                Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237113_((String)(ChatFormatting.BLUE + "A newer version of " + ChatFormatting.YELLOW + "Collectibles" + ChatFormatting.BLUE + " is available!")), false);
                Minecraft.m_91087_().f_91074_.m_5661_((Component)url, false);
                hasShownUp = true;
            } else if (VersionChecker.getResult((IModInfo)((ModContainer)ModList.get().getModContainerById("collectibles").get()).getModInfo()).status() == VersionChecker.Status.FAILED) {
                Collectibles.LOGGER.error("Collectibles's version checker failed!");
                hasShownUp = true;
            }
        }
    }

    @SubscribeEvent
    public static void onBlockDestroyed(BlockEvent.BreakEvent event) {
        Random random = new Random();
        Level level = event.getPlayer().m_9236_();
        BlockState block = event.getState();
        BlockPos pos = event.getPos();
        if (!level.f_46443_) {
            if (block.m_204336_(BlockTags.f_13061_) || block.m_204336_(Tags.Blocks.STONE)) {
                if (random.nextInt((Integer)Config.FRAGMENT_COLLECTIBLE_RARITY.get()) == 1) {
                    level.m_5594_((Player)null, pos, SoundEvents.f_12275_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.15f + 0.0f);
                    ItemEntity drop = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, CollectibleHelper.getRandomFragment());
                    level.m_7967_((Entity)drop);
                }
            } else if (block.m_204336_(BlockTags.f_144274_) || block.m_204336_(BlockTags.f_13029_)) {
                if (random.nextInt((Integer)Config.COIN_COLLECTIBLE_RARITY.get()) == 1) {
                    level.m_5594_((Player)null, pos, SoundEvents.f_12275_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.15f + 0.0f);
                    ItemEntity drop = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, CollectibleHelper.getRandomCoin());
                    level.m_7967_((Entity)drop);
                }
            } else if (block.m_204336_(BlockTags.f_13062_) && random.nextInt((Integer)Config.FOSSIL_COLLECTIBLE_RARITY.get()) == 1) {
                level.m_5594_((Player)null, pos, SoundEvents.f_12275_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.15f + 0.0f);
                ItemEntity drop = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, CollectibleHelper.getRandomFossil());
                level.m_7967_((Entity)drop);
            }
        }
    }

    @SubscribeEvent
    public static void addCustomWanderingTrades(WandererTradesEvent event) {
        List trades = event.getRareTrades();
        ItemStack reward = new ItemStack((ItemLike)Items.f_42616_, 30);
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.GOLD_COIN.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.SILVER_COIN.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.PLATINUM_COIN.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.NETHERITE_COIN.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.COPPER_COIN.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.BRONZE_COIN.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.BRASS_COIN.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.IRON_COIN.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.STONE_COIN.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.DIAMOND_FRAGMENT.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.EMERALD_FRAGMENT.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.AMETHYST_FRAGMENT.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.RUBY_FRAGMENT.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.SAPPHIRE_FRAGMENT.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.TOPAZ_FRAGMENT.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.CRYSTAL_FRAGMENT.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.HEMATITE_FRAGMENT.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.TOURMALINE_FRAGMENT.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.OLD_BOOK.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.NECRONOMICON_BOOK.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.KNOWLEDGE_BOOK.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.NOTCHS_BOOK.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.DARKHOLD_BOOK.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.MONSTER_BOOK.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.GRIMOIRE_BOOK.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.CURSED_BOOK.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.HEROBRINES_BOOK.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.CLAW_FOSSIL.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.LEG_FOSSIL.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.AMMONITE_FOSSIL.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.CRINOID_FOSSIL.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.TRILOBITE_FOSSIL.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.SKULL_FOSSIL.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.SPINE_FOSSIL.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.RIP_FOSSIL.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.THORAX_FOSSIL.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.AMULET_JEWELRY.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.HAIRPIN_JEWELRY.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.BRACELET_JEWELRY.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.BROOCH_JEWELRY.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.EARRING_JEWELRY.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.DIADEM_JEWELRY.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.CROWN_JEWELRY.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.CHAIN_JEWELRY.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.RING_JEWELRY.get()), reward, 1, 5, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 10), new ItemStack((ItemLike)ModItems.LOOT_BAG.get()), 1, 10, 0.05f));
        trades.add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 60), new ItemStack((ItemLike)ModItems.EPIC_LOOT_BAG.get()), 1, 15, 0.05f));
    }

    @SubscribeEvent
    public static void SupporterRewards(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        Level level = player.m_9236_();
        if (Config.PATREON_REWARDS.get() != null && ((Boolean)Config.PATREON_REWARDS.get()).booleanValue()) {
            try {
                ServerPlayer serverPlayer;
                URL SUPPORTER_URL = new URL("https://raw.githubusercontent.com/XxRexRaptorxX/Patreons/main/Supporter");
                URL PREMIUM_SUPPORTER_URL = new URL("https://raw.githubusercontent.com/XxRexRaptorxX/Patreons/main/Premium%20Supporter");
                URL ELITE_URL = new URL("https://raw.githubusercontent.com/XxRexRaptorxX/Patreons/main/Elite");
                if (!player.m_150109_().m_36063_(new ItemStack((ItemLike)Items.f_42516_)) && (serverPlayer = (ServerPlayer)player).m_8951_().m_13017_(Stats.f_12988_, (Object)Stats.f_144255_) < 5) {
                    if (Events.SupporterCheck(SUPPORTER_URL, player)) {
                        ItemStack certificate = new ItemStack((ItemLike)Items.f_42516_).m_41714_((Component)Component.m_237113_((String)"Thank you for supporting me in my work!").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)" - XxRexRaptorxX").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GREEN)));
                        CompoundTag ownerNBT = new CompoundTag();
                        ItemStack reward = new ItemStack((ItemLike)Items.f_42680_);
                        ownerNBT.m_128359_("SkullOwner", player.m_7755_().getString());
                        reward.m_41751_(ownerNBT);
                        level.m_5594_((Player)null, player.m_20183_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 0.5f, level.f_46441_.m_188501_() * 0.15f + 0.8f);
                        player.m_36356_(reward);
                        player.m_36356_(certificate);
                    }
                    if (Events.SupporterCheck(PREMIUM_SUPPORTER_URL, player)) {
                        ItemStack reward = new ItemStack((ItemLike)Items.f_42388_, 1).m_41714_((Component)Component.m_237113_((String)"Rex's Night Sword").m_130940_(ChatFormatting.DARK_GRAY));
                        reward.m_41663_(Enchantments.f_44962_, 1);
                        reward.m_41663_(Enchantments.f_44977_, 3);
                        player.m_36356_(reward);
                    }
                    if (Events.SupporterCheck(ELITE_URL, player)) {
                        player.m_36356_(new ItemStack((ItemLike)Items.f_42686_).m_41714_((Component)Component.m_237113_((String)"Elite Star")));
                    }
                }
            }
            catch (Exception e) {
                Collectibles.LOGGER.error((Object)e);
            }
        }
    }

    private static boolean SupporterCheck(URL url, Player player) {
        try {
            Scanner scanner = new Scanner(url.openStream());
            List<String> supporterList = scanner.tokens().toList();
            for (String name : supporterList) {
                if (!player.m_7755_().getString().equals(name)) continue;
                return true;
            }
            scanner.close();
        }
        catch (MalformedURLException e) {
            Collectibles.LOGGER.error("Supporter list URL not found! >>" + url);
        }
        catch (Exception e) {
            Collectibles.LOGGER.error((Object)e);
        }
        return false;
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Path configDir = FMLPaths.CONFIGDIR.get();
        Path marker = configDir.resolve("#STOP_MOD_REPOSTS.txt");
        try {
            if (Files.notExists(marker, new LinkOption[0])) {
                String fileContent = "    Sites like 9minecraft.net, mc-mod.net, and many others, are known for reuploading mod files without permission from the authors. These sites will also contain a bunch of ads, to try to make money from mods they did not create.\n\n    These sites will use various methods to appear higher in Google when you search for the mod name, so a lot of people will download mods from them instead of the proper place. If you were linked to this site, you're one of these people.\n\n    FOR YOU, AS A PLAYER, THIS CAN MEAN ANY OF THE FOLLOWING:\n    > Getting versions of the mods advertised for the wrong Minecraft versions, which will 100% crash when you load them.\n    > Getting old, and broken, versions of the mods, possibly causing problems in your game.\n    > Getting modified versions of the mods, which may contain malware and viruses.\n    > Having your information stolen from malicious ads in the sites.\n    > Taking money and views away from the official authors, which may cause them to stop making new mods.\n\n    WHAT DO I DO NOW?\n    The most important thing to do now is to make sure you stop visiting these sites, and get the mods from official sources. We also recommend you do the following:\n\n    > Delete all the mods you've downloaded from these sites.\n    > Install the StopModReposts plugin, which makes sure you never visit them again.\n    > Run a virus/malware scan. We recommend MalwareBytes.\n    > Check out the #StopModReposts campaign, that tries to put an end to these sites. (https://stopmodreposts.org/)\n    > Spread the word. If you have any friends that use these sites, inform them to keep them safe.\n\n    WHERE DO I GET MODS NOW?\n    Here's a bunch of links to places where you can download official versions of mods, hosted by their real authors:\n\n    > CurseForge, where most modders host their mods. If it exists, it's probably there.\n    > Modrinth, a new hosting platform for mods that's also legit and more popular by the day.\n    > OptiFine.net, the official OptiFine site.\n    > Neoforged.net, which you need for any other Neoforge mods.\n    > FabricMC.net, which you need for any other Fabric mods.\n    > MinecraftForge Files, which you need for any other Forge mods.\n\n    This doesn't mean other sites aren't legit. In general, the first place to look for a mod is CurseForge and Modrinth, so look there first.\n\n    FAQ\n    Q: What if I've never had problems before?\n    > Just because you've never had problems with these sites before doesn't mean they're good. You should still avoid them for all the reasons listed above.\n\n    Q: Is there a list of these sites I can check out?\n    > Yes, however, due to these showing up all the time, it's possible to be incomplete. (https://github.com/StopModReposts/Illegal-Mod-Sites/blob/master/SITES.md)\n\n    Q: Why can't you just take these sites down?\n    > Unfortunately, these sites are often hosted in countries like Russia or Vietnam, where doing so isn't as feasible.\n\n    Q: What if it says \"Official Download\" on the sites?\n    > Sometimes they'll do that to trick you. If you're uncertain, you should verify with the StopModReposts list linked above.\n\n\n    Credits: XxRexRaptorxX, Vazkii, StopModReposts campaign\n";
                Files.writeString(marker, (CharSequence)fileContent, StandardCharsets.UTF_8, new OpenOption[0]);
                String launcher = FMLLoader.getLauncherInfo().toLowerCase();
                if (!(launcher.contains("curseforge") && launcher.contains("modrinth") && launcher.contains("prism"))) {
                    Collectibles.LOGGER.info("Stop-mod-reposts info message is generated. Don't worry, this message should only appear the very first time after installation!");
                    player2.m_213846_((Component)Component.m_237113_((String)"Important Information about mod reposts:\n").m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.DARK_RED));
                    player2.m_213846_((Component)Component.m_237113_((String)"Sites like 9minecraft.net, mc-mod.net, etc. are known for reuploading mod files without permissions. \nThese sites will also contain a bunch of ads, to try to make money from mods they did not create.\n").m_130940_(ChatFormatting.RED));
                    player2.m_213846_((Component)Component.m_237113_((String)"For you, this can mean any of the following:").m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.RED));
                    player2.m_213846_((Component)Component.m_237113_((String)"- Modified versions of mods, which may contain malware & viruses").m_130940_(ChatFormatting.RED));
                    player2.m_213846_((Component)Component.m_237113_((String)"- Having your information stolen from malicious ads").m_130940_(ChatFormatting.RED));
                    player2.m_213846_((Component)Component.m_237113_((String)"- Old and broken mod versions that can corrupt your world").m_130940_(ChatFormatting.RED));
                    player2.m_213846_((Component)Component.m_237113_((String)"- Taking money and views away from the real authors, which may cause them to stop making mods").m_130940_(ChatFormatting.RED));
                    MutableComponent url = Component.m_237113_((String)(ChatFormatting.GOLD + "* Click here for more information *"));
                    url.m_130948_(url.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://vazkii.net/repost/")));
                    player2.m_213846_((Component)url);
                }
            }
        }
        catch (IOException e) {
            Collectibles.LOGGER.error((Object)e);
        }
    }
}

