/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.client;

import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.blockcommands.ISerializer;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.xnet.keys.SidedPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class ConnectedBlockClientInfo {
    @Nonnull
    private final SidedPos pos;
    @Nonnull
    private final ItemStack connectedBlock;
    @Nonnull
    private final String name;
    @Nonnull
    private final String blockName;

    public ConnectedBlockClientInfo(@Nonnull SidedPos pos, @Nonnull ItemStack connectedBlock, @Nonnull String name) {
        this.pos = pos;
        this.connectedBlock = connectedBlock;
        this.name = name;
        this.blockName = ConnectedBlockClientInfo.getStackUnlocalizedName(connectedBlock);
    }

    public ConnectedBlockClientInfo(@Nonnull FriendlyByteBuf buf) {
        this.pos = new SidedPos(buf.m_130135_(), OrientationTools.DIRECTION_VALUES[buf.readByte()]);
        this.connectedBlock = buf.m_130267_();
        this.name = NetworkTools.readStringUTF8((FriendlyByteBuf)buf);
        this.blockName = NetworkTools.readStringUTF8((FriendlyByteBuf)buf);
    }

    public void writeToBuf(@Nonnull FriendlyByteBuf buf) {
        buf.m_130064_(this.pos.pos());
        buf.writeByte(this.pos.side().ordinal());
        buf.m_130055_(this.connectedBlock);
        NetworkTools.writeStringUTF8((FriendlyByteBuf)buf, (String)this.name);
        NetworkTools.writeStringUTF8((FriendlyByteBuf)buf, (String)this.blockName);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getBlockUnlocName() {
        return this.blockName;
    }

    @Nonnull
    public SidedPos getPos() {
        return this.pos;
    }

    @Nonnull
    public ItemStack getConnectedBlock() {
        return this.connectedBlock;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectedBlockClientInfo that = (ConnectedBlockClientInfo)o;
        return this.pos.equals((Object)that.pos);
    }

    public int hashCode() {
        return this.pos.hashCode();
    }

    private static String getStackUnlocalizedName(ItemStack stack) {
        CompoundTag nbttagcompound = ConnectedBlockClientInfo.getSubCompound(stack, "display");
        if (nbttagcompound != null) {
            if (nbttagcompound.m_128425_("Name", 8)) {
                return nbttagcompound.m_128461_("Name");
            }
            if (nbttagcompound.m_128425_("LocName", 8)) {
                return nbttagcompound.m_128461_("LocName");
            }
        }
        return stack.m_41720_().m_5671_(stack);
    }

    private static CompoundTag getSubCompound(ItemStack stack, String key) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128425_(key, 10)) {
            return stack.m_41783_().m_128469_(key);
        }
        return null;
    }

    public static class Serializer
    implements ISerializer<ConnectedBlockClientInfo> {
        public Function<FriendlyByteBuf, ConnectedBlockClientInfo> getDeserializer() {
            return buf -> {
                if (buf.readBoolean()) {
                    return new ConnectedBlockClientInfo((FriendlyByteBuf)buf);
                }
                return null;
            };
        }

        public BiConsumer<FriendlyByteBuf, ConnectedBlockClientInfo> getSerializer() {
            return (buf, info) -> {
                if (info == null) {
                    buf.writeBoolean(false);
                } else {
                    buf.writeBoolean(true);
                    info.writeToBuf((FriendlyByteBuf)buf);
                }
            };
        }
    }
}

