/*
 * Decompiled with CFR 0.152.
 */
package capsule.recipes;

import capsule.Config;
import capsule.items.CapsuleItem;
import capsule.items.CapsuleItems;
import capsule.recipes.CapsuleRecipes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class UpgradeCapsuleRecipe
implements CraftingRecipe {
    public final Ingredient upgradeIngredient;
    private final ResourceLocation recipeId;

    public UpgradeCapsuleRecipe(ResourceLocation recipeId, Ingredient upgradeIngredient) {
        this.upgradeIngredient = upgradeIngredient;
        this.recipeId = recipeId;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return CapsuleItems.getUpgradedCapsule(CapsuleItems.withState(CapsuleItem.CapsuleState.EMPTY), 1);
    }

    public boolean matches(CraftingContainer invC, Level worldIn) {
        ItemStack sourceCapsule = ItemStack.f_41583_;
        int material = 0;
        for (int i = 0; i < invC.m_6643_(); ++i) {
            ItemStack itemstack = invC.m_8020_(i);
            if (!itemstack.m_41619_() && itemstack.m_41720_() instanceof CapsuleItem && CapsuleItem.hasState(itemstack, CapsuleItem.CapsuleState.EMPTY) && CapsuleItem.getUpgradeLevel(itemstack) < Config.upgradeLimit) {
                sourceCapsule = itemstack;
                continue;
            }
            if (this.upgradeIngredient.test(itemstack)) {
                ++material;
                continue;
            }
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return sourceCapsule != ItemStack.f_41583_ && material > 0 && CapsuleItem.getUpgradeLevel(sourceCapsule) + material <= Config.upgradeLimit;
    }

    public ItemStack assemble(CraftingContainer invC, RegistryAccess registryAccess) {
        ItemStack input = ItemStack.f_41583_;
        int material = 0;
        for (int i = 0; i < invC.m_6643_(); ++i) {
            ItemStack itemstack = invC.m_8020_(i);
            if (!itemstack.m_41619_() && itemstack.m_41720_() instanceof CapsuleItem && CapsuleItem.hasState(itemstack, CapsuleItem.CapsuleState.EMPTY) && CapsuleItem.getUpgradeLevel(itemstack) < Config.upgradeLimit) {
                input = itemstack;
                continue;
            }
            if (this.upgradeIngredient.test(itemstack)) {
                ++material;
                continue;
            }
            if (itemstack.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        if (input == ItemStack.f_41583_) {
            return ItemStack.f_41583_;
        }
        ItemStack copy = input.m_41777_();
        int newSize = CapsuleItem.getSize(input) + material * 2;
        int newUpgraded = CapsuleItem.getUpgradeLevel(input) + material;
        if (newSize > 255) {
            newSize = 255;
        }
        if (newUpgraded > Config.upgradeLimit) {
            newUpgraded = Config.upgradeLimit;
        }
        CapsuleItem.setSize(copy, newSize);
        CapsuleItem.setUpgradeLevel(copy, newUpgraded);
        return copy;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CapsuleRecipes.UPGRADE_CAPSULE_SERIALIZER.get();
    }

    public boolean m_5598_() {
        return true;
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.MISC;
    }

    public static class Serializer
    implements RecipeSerializer<UpgradeCapsuleRecipe> {
        private static NonNullList<Ingredient> readIngredients(JsonArray p_199568_0_) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < p_199568_0_.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)p_199568_0_.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public UpgradeCapsuleRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList<Ingredient> nonnulllist = Serializer.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            return new UpgradeCapsuleRecipe(recipeId, (Ingredient)nonnulllist.get(0));
        }

        public UpgradeCapsuleRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new UpgradeCapsuleRecipe(recipeId, Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }

        public void toNetwork(FriendlyByteBuf buffer, UpgradeCapsuleRecipe recipe) {
            recipe.upgradeIngredient.m_43923_(buffer);
        }
    }
}

