/*
 * Decompiled with CFR 0.152.
 */
package capsule.recipes;

import capsule.Config;
import capsule.StructureSaver;
import capsule.helpers.Blueprint;
import capsule.items.CapsuleItem;
import capsule.items.CapsuleItems;
import capsule.recipes.CapsuleRecipes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.util.TriConsumer;

public class PrefabsBlueprintAggregatorRecipe
extends CustomRecipe {
    public static PrefabsBlueprintAggregatorRecipe instance;
    public List<PrefabsBlueprintCapsuleRecipe> recipes = new ArrayList<PrefabsBlueprintCapsuleRecipe>();

    public PrefabsBlueprintAggregatorRecipe(ResourceLocation idIn, CraftingBookCategory craftingCategory) {
        super(idIn, craftingCategory);
        instance = this;
    }

    public void populateRecipes(ResourceManager resourceManager) {
        if (resourceManager == null) {
            return;
        }
        List<String> prefabsTemplatesList = Config.prefabsTemplatesList;
        this.recipes.clear();
        Blueprint.createDynamicPrefabRecipes(resourceManager, prefabsTemplatesList, (TriConsumer<ResourceLocation, JsonObject, Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>>)((TriConsumer)(id, recipe, ingredients) -> this.recipes.add(new PrefabsBlueprintCapsuleRecipe((ResourceLocation)id, (JsonObject)recipe, (Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>)ingredients))));
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CapsuleRecipes.PREFABS_AGGREGATOR_SERIALIZER.get();
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        return this.recipes.stream().anyMatch(r -> r.matches(inv));
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        Optional<PrefabsBlueprintCapsuleRecipe> recipe = this.recipes.stream().filter(r -> r.matches(inv)).findFirst();
        if (recipe.isPresent()) {
            return recipe.get().assemble(inv, registryAccess);
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return CapsuleItems.withState(CapsuleItem.CapsuleState.BLUEPRINT);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        Optional<PrefabsBlueprintCapsuleRecipe> recipe = this.recipes.stream().filter(r -> r.matches(inv)).findFirst();
        if (recipe.isPresent()) {
            return recipe.get().getRemainingItems(inv);
        }
        return NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
    }

    public static class PrefabsBlueprintCapsuleRecipe
    implements CraftingRecipe {
        private final ResourceLocation id;
        public final ShapedRecipe recipe;
        private int ingredientOneIndex = 4;
        private int ingredientTwoIndex = 0;
        private int ingredientThreeIndex = 2;

        public PrefabsBlueprintCapsuleRecipe(ResourceLocation id, JsonObject template, Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey> ingredients) {
            this.id = id;
            this.FixIngredient(template, (StructureSaver.ItemStackKey)ingredients.getLeft(), "1");
            this.FixIngredient(template, (StructureSaver.ItemStackKey)ingredients.getMiddle(), "2");
            this.FixIngredient(template, (StructureSaver.ItemStackKey)ingredients.getRight(), "3");
            this.recipe = (ShapedRecipe)ShapedRecipe.Serializer.f_44076_.m_6729_(id, template);
        }

        private void FixIngredient(JsonObject template, StructureSaver.ItemStackKey ingredientKey, String key) {
            if (ingredientKey != null) {
                JsonObject keyOne = new JsonObject();
                keyOne.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)ingredientKey.itemStack.m_41720_()).toString());
                template.getAsJsonObject("key").add(key, (JsonElement)keyOne);
            } else {
                JsonArray patternArr = GsonHelper.m_13933_((JsonObject)template, (String)"pattern");
                if (patternArr.size() != 3) {
                    throw new JsonSyntaxException("pattern entry in prefab_blueprint_recipe.json should define a 3x3 recipe.");
                }
                for (int i = 0; i < 3; ++i) {
                    patternArr.set(i, (JsonElement)new JsonPrimitive(patternArr.get(i).getAsString().replaceAll(key, " ")));
                }
            }
        }

        public PrefabsBlueprintCapsuleRecipe(ResourceLocation id, ShapedRecipe serializedRecipe) {
            this.id = id;
            this.recipe = serializedRecipe;
        }

        public ItemStack m_8043_(RegistryAccess registryAccess) {
            return this.recipe.m_8043_(registryAccess);
        }

        public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
            NonNullList nonnulllist = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
            for (int i = 0; i < nonnulllist.size(); ++i) {
                ItemStack itemstack = inv.m_8020_(i);
                nonnulllist.set(i, (Object)ForgeHooks.getCraftingRemainingItem((ItemStack)itemstack));
                if (itemstack.m_41720_() instanceof CapsuleItem) {
                    nonnulllist.set(i, (Object)itemstack.m_41777_());
                    continue;
                }
                if (i != this.ingredientOneIndex && i != this.ingredientTwoIndex && i != this.ingredientThreeIndex) continue;
                ItemStack refund = itemstack.m_41777_();
                refund.m_41764_(1);
                nonnulllist.set(i, (Object)refund);
            }
            return nonnulllist;
        }

        public ResourceLocation m_6423_() {
            return this.id;
        }

        public RecipeSerializer<?> m_7707_() {
            return ShapedRecipe.Serializer.f_44076_;
        }

        public boolean matches(CraftingContainer inv) {
            for (int i = 0; i <= inv.m_39347_() - this.recipe.m_44220_(); ++i) {
                for (int j = 0; j <= inv.m_39346_() - this.recipe.m_44221_(); ++j) {
                    if (this.checkMatch(inv, i, j, true)) {
                        return true;
                    }
                    if (!this.checkMatch(inv, i, j, false)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean matches(CraftingContainer inv, Level worldIn) {
            return this.matches(inv);
        }

        private boolean checkMatch(CraftingContainer craftingInventory, int p_77573_2_, int p_77573_3_, boolean p_77573_4_) {
            for (int i = 0; i < craftingInventory.m_39347_(); ++i) {
                for (int j = 0; j < craftingInventory.m_39346_(); ++j) {
                    int k = i - p_77573_2_;
                    int l = j - p_77573_3_;
                    Ingredient ingredient = Ingredient.f_43901_;
                    if (k >= 0 && l >= 0 && k < this.recipe.m_44220_() && l < this.recipe.m_44221_()) {
                        ingredient = p_77573_4_ ? (Ingredient)this.recipe.m_7527_().get(this.recipe.m_44220_() - k - 1 + l * this.recipe.m_44220_()) : (Ingredient)this.recipe.m_7527_().get(k + l * this.recipe.m_44220_());
                    }
                    if (ingredient.test(craftingInventory.m_8020_(i + j * craftingInventory.m_39347_()))) continue;
                    return false;
                }
            }
            return true;
        }

        public ItemStack assemble(CraftingContainer invC, RegistryAccess registryAccess) {
            return this.recipe.m_5874_(invC, registryAccess);
        }

        public boolean m_8004_(int width, int height) {
            return this.recipe.m_8004_(width, height);
        }

        public CraftingBookCategory m_245232_() {
            return CraftingBookCategory.MISC;
        }
    }

    public static class Serializer
    implements RecipeSerializer<PrefabsBlueprintAggregatorRecipe> {
        public PrefabsBlueprintAggregatorRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return instance != null ? instance : new PrefabsBlueprintAggregatorRecipe(recipeId, CraftingBookCategory.MISC);
        }

        public PrefabsBlueprintAggregatorRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            if (instance == null) {
                instance = new PrefabsBlueprintAggregatorRecipe(recipeId, CraftingBookCategory.MISC);
            }
            PrefabsBlueprintAggregatorRecipe.instance.recipes.clear();
            int size = buffer.readInt();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = new ResourceLocation(buffer.m_130277_());
                ShapedRecipe recipe = (ShapedRecipe)ShapedRecipe.Serializer.f_44076_.m_8005_(id, buffer);
                PrefabsBlueprintAggregatorRecipe.instance.recipes.add(new PrefabsBlueprintCapsuleRecipe(id, recipe));
            }
            return instance;
        }

        public void toNetwork(FriendlyByteBuf buffer, PrefabsBlueprintAggregatorRecipe recipe) {
            buffer.writeInt(recipe.recipes.size());
            for (PrefabsBlueprintCapsuleRecipe subRecipe : recipe.recipes) {
                buffer.m_130070_(subRecipe.id.toString());
                ShapedRecipe.Serializer.f_44076_.m_6178_(buffer, (Recipe)subRecipe.recipe);
            }
        }
    }
}

