/*
 * Decompiled with CFR 0.152.
 */
package capsule.network;

import capsule.helpers.Capsule;
import capsule.items.CapsuleItem;
import capsule.network.CapsuleNetwork;
import capsule.network.CapsuleUndeployNotifToClient;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapsuleThrowQueryToServer {
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleThrowQueryToServer.class);
    public BlockPos pos = null;
    public boolean instant = false;

    public CapsuleThrowQueryToServer(BlockPos pos, boolean instant) {
        this.pos = pos;
        this.instant = instant;
    }

    public void onServer(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            LOGGER.error("ServerPlayerEntity was null when " + this.getClass().getName() + " was received");
            return;
        }
        ItemStack heldItem = sendingPlayer.m_21205_();
        ServerLevel world = sendingPlayer.m_284548_();
        ctx.get().enqueueWork(() -> {
            if (heldItem.m_41720_() instanceof CapsuleItem) {
                if (this.instant && this.pos != null) {
                    int size = CapsuleItem.getSize(heldItem);
                    int extendLength = (size - 1) / 2;
                    if (CapsuleItem.hasState(heldItem, CapsuleItem.CapsuleState.EMPTY)) {
                        boolean captured = Capsule.captureAtPosition(heldItem, sendingPlayer.m_20148_(), size, sendingPlayer.m_284548_(), this.pos);
                        if (captured) {
                            BlockPos center = this.pos.m_7918_(0, size / 2, 0);
                            CapsuleNetwork.wrapper.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint((double)center.m_123341_(), (double)center.m_123342_(), (double)center.m_123343_(), (double)(200 + size), sendingPlayer.m_20193_().m_46472_())), (Object)new CapsuleUndeployNotifToClient(center, sendingPlayer.m_20183_(), size, CapsuleItem.getStructureName(heldItem)));
                        }
                    } else {
                        boolean deployed = Capsule.deployCapsule(heldItem, this.pos.m_7918_(0, -1, 0), sendingPlayer.m_20148_(), extendLength, world);
                        if (deployed) {
                            CapsuleItem.setUndeployDelay(heldItem, (Player)sendingPlayer);
                            world.m_5594_(null, this.pos, SoundEvents.f_11687_, SoundSource.BLOCKS, 0.4f, 0.1f);
                            Capsule.showDeployParticules(world, this.pos, size);
                        }
                        if (deployed && CapsuleItem.isOneUse(heldItem)) {
                            heldItem.m_41774_(1);
                        }
                    }
                }
                if (!this.instant) {
                    Capsule.throwCapsule(heldItem, (Player)sendingPlayer, this.pos);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public CapsuleThrowQueryToServer(FriendlyByteBuf buf) {
        try {
            this.instant = buf.readBoolean();
            boolean hasPos = buf.readBoolean();
            if (hasPos) {
                this.pos = BlockPos.m_122022_((long)buf.readLong());
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.instant);
        boolean hasPos = this.pos != null;
        buf.writeBoolean(hasPos);
        if (hasPos) {
            buf.writeLong(this.pos.m_121878_());
        }
    }

    public String toString() {
        return this.getClass().toString();
    }
}

