/*
 * Decompiled with CFR 0.152.
 */
package capsule.network;

import capsule.client.CapsulePreviewHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapsuleContentPreviewAnswerToClient {
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleContentPreviewAnswerToClient.class);
    private List<AABB> boundingBoxes = null;
    private String structureName = null;

    public CapsuleContentPreviewAnswerToClient(List<AABB> boundingBoxes, String structureName) {
        this.boundingBoxes = boundingBoxes;
        this.structureName = structureName;
    }

    public void onClient(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Map<String, List<AABB>> map = CapsulePreviewHandler.currentPreview;
            synchronized (map) {
                CapsulePreviewHandler.currentPreview.put(this.getStructureName(), this.getBoundingBoxes());
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public CapsuleContentPreviewAnswerToClient(FriendlyByteBuf buf) {
        try {
            this.structureName = buf.m_130136_(Short.MAX_VALUE);
            int size = buf.readShort();
            this.boundingBoxes = new ArrayList<AABB>(size);
            for (int i = 0; i < size; ++i) {
                boolean isSingleBlock = buf.readBoolean();
                if (isSingleBlock) {
                    BlockPos p = BlockPos.m_122022_((long)buf.readLong());
                    this.boundingBoxes.add(new AABB(p, p));
                    continue;
                }
                this.boundingBoxes.add(new AABB(BlockPos.m_122022_((long)buf.readLong()), BlockPos.m_122022_((long)buf.readLong())));
            }
        }
        catch (IndexOutOfBoundsException ioe) {
            LOGGER.error("Exception while reading CapsuleContentPreviewMessageToClient: " + ioe);
            return;
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.structureName);
        int size = Math.min(this.boundingBoxes.size(), Short.MAX_VALUE);
        buf.writeShort(size);
        for (int i = 0; i < size; ++i) {
            AABB bb = this.boundingBoxes.get(i);
            boolean isSingleBlock = bb.m_82309_() == 0.0;
            buf.writeBoolean(isSingleBlock);
            buf.writeLong(BlockPos.m_274561_((double)bb.f_82288_, (double)bb.f_82289_, (double)bb.f_82290_).m_121878_());
            if (isSingleBlock) continue;
            buf.writeLong(BlockPos.m_274561_((double)bb.f_82291_, (double)bb.f_82292_, (double)bb.f_82293_).m_121878_());
        }
    }

    public String toString() {
        return this.getClass().toString();
    }

    public List<AABB> getBoundingBoxes() {
        return this.boundingBoxes;
    }

    public String getStructureName() {
        return this.structureName;
    }
}

