/*
 * Decompiled with CFR 0.152.
 */
package capsule.loot;

import capsule.Config;
import capsule.helpers.Capsule;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="capsule", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class StarterLoot {
    protected static final Logger LOGGER = LogManager.getLogger(StarterLoot.class);
    public static StarterLoot instance = new StarterLoot();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getEntity().m_9236_().f_46443_) {
            if (StringUtil.m_14408_((String)Config.starterMode) || Config.starterTemplatesList == null || Config.starterTemplatesList.isEmpty()) {
                LOGGER.info("Capsule starters are disabled in capsule.cfg. To enable, set starterMode to 'all' or 'random' and set a directory path with structures for starterTemplatesPath.");
                return;
            }
            ServerPlayer player = (ServerPlayer)event.getEntity();
            CompoundTag playerData = player.getPersistentData();
            CompoundTag data = !playerData.m_128441_("PlayerPersisted") ? new CompoundTag() : playerData.m_128469_("PlayerPersisted");
            LOGGER.info("playerLogin: " + (data.m_128471_("capsule:receivedStarter") ? "already received starters" : "giving starters now"));
            if (!data.m_128471_("capsule:receivedStarter")) {
                if ("all".equals(Config.starterMode.toLowerCase())) {
                    StarterLoot.giveAllStarters(player, Config.starterTemplatesList);
                    data.m_128379_("capsule:receivedStarter", true);
                } else if ("random".equals(Config.starterMode)) {
                    StarterLoot.giveAllStarters(player, Collections.singletonList(Config.starterTemplatesList.get((int)(Math.random() * (double)Config.starterTemplatesList.size()))));
                    data.m_128379_("capsule:receivedStarter", true);
                }
                playerData.m_128365_("PlayerPersisted", (Tag)data);
            }
        }
    }

    public static void giveAllStarters(ServerPlayer player, List<String> allStartersToGive) {
        for (String templatePath : allStartersToGive) {
            ItemStack starterCapsule = Capsule.createLinkedCapsuleFromReward(templatePath, player);
            int stackIdx = player.m_150109_().m_36062_();
            if (stackIdx < 0 || stackIdx >= player.m_150109_().m_6643_()) {
                Capsule.throwCapsule(starterCapsule, (Player)player, player.m_20183_());
                continue;
            }
            try {
                player.m_150109_().m_6836_(stackIdx, starterCapsule);
            }
            catch (Exception e) {
                Capsule.throwCapsule(starterCapsule, (Player)player, player.m_20183_());
            }
        }
    }
}

