/*
 * Decompiled with CFR 0.152.
 */
package capsule.helpers;

import capsule.Config;
import capsule.StructureSaver;
import capsule.helpers.Capsule;
import capsule.helpers.Files;
import capsule.structure.CapsuleTemplate;
import capsule.structure.CapsuleTemplateManager;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.TriConsumer;

public class Blueprint {
    protected static final Logger LOGGER = LogManager.getLogger(Blueprint.class);

    public static ItemStack getBlockItemCost(StructureTemplate.StructureBlockInfo blockInfo) {
        BlockState state = blockInfo.f_74676_();
        Block block = state.m_60734_();
        CompoundTag blockNBT = blockInfo.f_74677_();
        try {
            if (block instanceof DoorBlock) {
                if (state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER) {
                    return new ItemStack((ItemLike)block.m_5456_(), 1);
                }
                return ItemStack.f_41583_;
            }
            if (block instanceof BedBlock) {
                if (state.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD) {
                    return new ItemStack((ItemLike)block.m_5456_(), 1);
                }
                return ItemStack.f_41583_;
            }
            if (block instanceof SlabBlock && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.DOUBLE) {
                return new ItemStack((ItemLike)block.m_5456_(), 2);
            }
            if (block instanceof FarmBlock) {
                return new ItemStack((ItemLike)Blocks.f_50493_);
            }
            if (block instanceof LiquidBlock) {
                LiquidBlock fblock = (LiquidBlock)block;
                if (Blueprint.isLiquidSource(state, fblock)) {
                    ItemStack item = FluidUtil.getFilledBucket((FluidStack)new FluidStack((Fluid)fblock.getFluid(), 1000));
                    return item.m_41619_() ? null : item;
                }
                return ItemStack.f_41583_;
            }
            if (block instanceof PistonHeadBlock || block instanceof MovingPistonBlock) {
                return ItemStack.f_41583_;
            }
            ItemStack item = new ItemStack((ItemLike)block.m_5456_(), 1);
            if (blockNBT != null) {
                CompoundTag itemNBT = new CompoundTag();
                JsonObject allowedNBT = Config.getBlueprintAllowedNBT(block);
                for (String key : blockNBT.m_128431_()) {
                    if (!allowedNBT.has(key) || allowedNBT.get(key).isJsonNull()) continue;
                    String targetKey = allowedNBT.get(key).getAsString();
                    itemNBT.m_128365_(targetKey, blockNBT.m_128423_(key));
                }
                if (itemNBT.m_128440_() > 0) {
                    item.m_41751_(itemNBT);
                }
            }
            return item;
        }
        catch (Exception e) {
            return new ItemStack((ItemLike)Item.m_41439_((Block)block), 1);
        }
    }

    public static boolean isLiquidSource(BlockState state, LiquidBlock block) {
        return block.m_5888_(state).m_76170_();
    }

    @Nullable
    public static Map<StructureSaver.ItemStackKey, Integer> getMaterialList(ItemStack blueprint, ServerLevel worldserver, Player player) {
        CapsuleTemplate blueprintTemplate = (CapsuleTemplate)StructureSaver.getTemplate(blueprint, worldserver).getRight();
        if (blueprintTemplate == null) {
            return null;
        }
        return Blueprint.getMaterialList(blueprintTemplate, player);
    }

    public static Map<StructureSaver.ItemStackKey, Integer> getMaterialList(CapsuleTemplate blueprintTemplate, @Nullable Player player) {
        HashMap<StructureSaver.ItemStackKey, Integer> list = new HashMap<StructureSaver.ItemStackKey, Integer>();
        for (StructureTemplate.StructureBlockInfo block : blueprintTemplate.getPalette()) {
            ItemStack itemStack = Blueprint.getBlockItemCost(block);
            StructureSaver.ItemStackKey stackKey = new StructureSaver.ItemStackKey(itemStack);
            if (itemStack == null) {
                if (player != null) {
                    player.m_213846_((Component)Component.m_237115_((String)"capsule.error.technicalError"));
                }
                if (player != null) {
                    LOGGER.error("Unknown item during blueprint undo for " + block.f_74676_().m_60734_().toString());
                }
                return null;
            }
            if (itemStack.m_41619_() || itemStack.m_41720_() == Items.f_41852_) continue;
            Integer currValue = (Integer)list.get(stackKey);
            if (currValue == null) {
                currValue = 0;
            }
            list.put(stackKey, currValue + itemStack.m_41613_());
        }
        return list;
    }

    public static TreeMap<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String> sortTemplatesByIngredients(List<String> prefabsTemplatesList, CapsuleTemplateManager tempManager) {
        TreeMap<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String> templatesByIngrendients = new TreeMap<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String>(Triple::compareTo);
        for (String templateName : prefabsTemplatesList) {
            try {
                Map<StructureSaver.ItemStackKey, Integer> fullList;
                CapsuleTemplate template = tempManager.getTemplate(new ResourceLocation(templateName));
                if (template == null || (fullList = Blueprint.getMaterialList(template, null)) == null) continue;
                StructureSaver.ItemStackKey[] list = (StructureSaver.ItemStackKey[])fullList.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).limit(5L).map(Map.Entry::getKey).toArray(StructureSaver.ItemStackKey[]::new);
                Triple key = Triple.of((Object)list[0], (Object)(list.length > 1 ? list[1] : null), list.length > 2 ? list[2] : null);
                if (templatesByIngrendients.containsKey(key)) {
                    key = Triple.of((Object)list[0], (Object)(list.length > 2 ? list[2] : null), list.length > 1 ? list[1] : null);
                }
                if (templatesByIngrendients.containsKey(key)) {
                    key = Triple.of((Object)(list.length > 1 ? list[1] : null), (Object)list[0], list.length > 2 ? list[2] : null);
                }
                if (templatesByIngrendients.containsKey(key)) {
                    key = Triple.of((Object)(list.length > 2 ? list[2] : null), (Object)list[0], list.length > 1 ? list[1] : null);
                }
                if (templatesByIngrendients.containsKey(key)) {
                    key = Triple.of((Object)(list.length > 1 ? list[1] : null), (Object)(list.length > 2 ? list[2] : null), (Object)list[0]);
                }
                if (templatesByIngrendients.containsKey(key)) {
                    key = Triple.of((Object)(list.length > 2 ? list[2] : null), (Object)(list.length > 1 ? list[1] : null), (Object)list[0]);
                }
                templatesByIngrendients.put((Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>)key, templateName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return templatesByIngrendients;
    }

    public static Map<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String> reduceIngredientCount(TreeMap<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String> templatesByIngrendients) {
        HashMap<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String> reduced = new HashMap<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String>();
        templatesByIngrendients.forEach((ingredients, value) -> {
            Triple withOneIngredient = Triple.of((Object)((StructureSaver.ItemStackKey)ingredients.getLeft()), null, null);
            if (!reduced.containsKey(withOneIngredient)) {
                reduced.put((Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>)withOneIngredient, (String)value);
            } else if (ingredients.getMiddle() != null) {
                Triple withTwoIngredient = Triple.of((Object)((StructureSaver.ItemStackKey)ingredients.getLeft()), (Object)((StructureSaver.ItemStackKey)ingredients.getMiddle()), null);
                if (!reduced.containsKey(withTwoIngredient)) {
                    reduced.put((Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>)withTwoIngredient, (String)value);
                } else if (ingredients.getRight() != null) {
                    if (!reduced.containsKey(ingredients)) {
                        reduced.put((Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>)ingredients, (String)value);
                    } else {
                        LOGGER.warn("Could not create prefab recipe with 2 ingredients or less.");
                    }
                } else {
                    LOGGER.warn("Could not create prefab recipe with 2 ingredients or less.");
                }
            } else {
                LOGGER.warn("Could not create prefab recipe with 1 ingredient.");
            }
        });
        return reduced;
    }

    public static void createDynamicPrefabRecipes(ResourceManager resourceManager, List<String> prefabsTemplatesList, TriConsumer<ResourceLocation, JsonObject, Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>> parseTemplate) {
        JsonObject referenceRecipe = Files.readJSON(new File(Config.getCapsuleConfigDir().toString(), "prefab_blueprint_recipe.json"));
        if (referenceRecipe != null) {
            CapsuleTemplateManager tempManager = new CapsuleTemplateManager(resourceManager, new File("."), DataFixers.m_14512_());
            List<String> enabledPrefabsTemplatesList = Blueprint.getModEnabledTemplates(prefabsTemplatesList);
            TreeMap<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String> templatesByIngrendients = Blueprint.sortTemplatesByIngredients(enabledPrefabsTemplatesList, tempManager);
            Map<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String> reduced = Blueprint.reduceIngredientCount(templatesByIngrendients);
            reduced.forEach((ingredients, templateName) -> {
                CapsuleTemplate template = tempManager.getTemplate(new ResourceLocation(templateName));
                JsonObject jsonRecipe = Files.copy(referenceRecipe);
                if (ingredients.getLeft() == null && ingredients.getMiddle() == null && ingredients.getRight() == null) {
                    LOGGER.error("template " + templateName + " cannot be turned into recipe because capsule failed to turn any block of the structure into ingredient. Please ensure all the modded blocks you are using in the template have their corresponding mod loaded in a version compatible with the template you are using.");
                } else if (jsonRecipe != null && template != null) {
                    jsonRecipe.getAsJsonObject("result").getAsJsonObject("nbt").addProperty("structureName", templateName);
                    jsonRecipe.getAsJsonObject("result").getAsJsonObject("nbt").addProperty("label", Capsule.labelFromPath(templateName));
                    int size = Math.max(template.getSize().m_123341_(), Math.max(template.getSize().m_123342_(), template.getSize().m_123343_()));
                    jsonRecipe.getAsJsonObject("result").getAsJsonObject("nbt").addProperty("size", (Number)size);
                    parseTemplate.accept((Object)new ResourceLocation(templateName), (Object)jsonRecipe, ingredients);
                }
            });
        }
    }

    public static List<String> getModEnabledTemplates(List<String> prefabsTemplatesList) {
        return prefabsTemplatesList.stream().filter(templatePath -> {
            String[] path = templatePath.replaceAll(Config.prefabsTemplatesPath + "/", "").split("/");
            return path.length == 1 || ModList.get().isLoaded(path[0]);
        }).collect(Collectors.toList());
    }
}

