/*
 * Decompiled with CFR 0.152.
 */
package capsule.dispenser;

import capsule.helpers.Capsule;
import capsule.helpers.Spacial;
import capsule.items.CapsuleItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DispenseCapsuleBehavior
extends DefaultDispenseItemBehavior {
    protected static final Logger LOGGER = LogManager.getLogger(DispenseCapsuleBehavior.class);

    public ItemStack m_7498_(BlockSource source, ItemStack capsule) {
        if (!(capsule.m_41720_() instanceof CapsuleItem)) {
            return capsule;
        }
        ServerLevel serverWorld = source.m_7727_();
        if (CapsuleItem.hasState(capsule, CapsuleItem.CapsuleState.DEPLOYED) && CapsuleItem.getDimension(capsule) != null) {
            try {
                Capsule.resentToCapsule(capsule, serverWorld, null);
                source.m_7727_().m_5594_(null, source.m_7961_(), SoundEvents.f_12443_, SoundSource.BLOCKS, 0.2f, 0.4f);
            }
            catch (Exception e) {
                LOGGER.error("Couldn't resend the content into the capsule", (Throwable)e);
            }
        } else if (CapsuleItem.hasStructureLink(capsule)) {
            int size = CapsuleItem.getSize(capsule);
            int extendLength = (size - 1) / 2;
            BlockPos anchor = Spacial.getAnchor(source.m_7961_(), source.m_6414_(), size).m_7918_(0, CapsuleItem.getYOffset(capsule), 0);
            boolean deployed = Capsule.deployCapsule(capsule, anchor, null, extendLength, serverWorld);
            if (deployed) {
                source.m_7727_().m_5594_(null, source.m_7961_(), SoundEvents.f_11687_, SoundSource.BLOCKS, 0.2f, 0.4f);
                Capsule.showDeployParticules(serverWorld, source.m_7961_(), size);
            }
            if (deployed && CapsuleItem.isOneUse(capsule)) {
                capsule.m_41774_(1);
            }
        }
        return capsule;
    }

    protected void m_6823_(BlockSource source) {
        source.m_7727_().m_46796_(1000, source.m_7961_(), 0);
    }
}

