/*
 * Decompiled with CFR 0.152.
 */
package capsule.client.render;

import capsule.client.render.CustomRenderType;
import capsule.client.render.FakeWorld;
import capsule.client.render.vbo.MultiVBORenderer;
import capsule.structure.CapsuleTemplate;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.LiquidBlockRenderer;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.data.ModelData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;

public class CapsuleTemplateRenderer {
    private static final Logger LOGGER = LogManager.getLogger();
    public MultiVBORenderer renderBuffer;
    public FakeWorld templateWorld = null;
    private boolean isWorldDirty = true;
    private StructurePlaceSettings lastPlacementSettings;
    private ModelBlockRenderer blockRenderer = Minecraft.m_91087_().m_91289_().m_110937_();
    private LiquidBlockRenderer liquidBlockRenderer = new LiquidBlockRenderer();
    private final RandomSource random = RandomSource.m_216327_();

    public void renderTemplate(PoseStack poseStack, Player player, BlockPos destPos) {
        if (player == null) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        Vec3 cameraView = minecraft.f_91063_.m_109153_().m_90583_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)destPos.m_123341_() - cameraView.f_82479_, (double)destPos.m_123342_() - cameraView.f_82480_, (double)destPos.m_123343_() - cameraView.f_82481_);
        this.renderTemplate(poseStack, cameraView, player);
        poseStack.m_85849_();
    }

    public void renderTemplate(PoseStack poseStack, Vec3 cameraView, Player player) {
        Minecraft minecraft = Minecraft.m_91087_();
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        VertexConsumer bufferSolid = bufferSource.m_6299_(CustomRenderType.VISUAL_BLOCK);
        for (Map.Entry<BlockPos, BlockState> entry : this.templateWorld.entrySet()) {
            BlockPos targetPos = entry.getKey();
            BlockState state = entry.getValue();
            BakedModel ibakedmodel = minecraft.m_91289_().m_110910_(state);
            poseStack.m_85836_();
            poseStack.m_252880_((float)targetPos.m_123341_(), (float)targetPos.m_123342_(), (float)targetPos.m_123343_());
            try {
                if (state.m_60799_() == RenderShape.MODEL || state.m_60799_() == RenderShape.ENTITYBLOCK_ANIMATED) {
                    this.random.m_188584_(Mth.m_14057_((Vec3i)targetPos));
                    this.blockRenderer.tesselateWithAO((BlockAndTintGetter)this.templateWorld, ibakedmodel, state, targetPos, poseStack, bufferSolid, true, this.random, Mth.m_14057_((Vec3i)targetPos), OverlayTexture.f_118083_, ModelData.EMPTY, (RenderType)RenderType.f_110371_);
                } else {
                    FluidState ifluidstate = state.m_60819_();
                    if (!ifluidstate.m_76178_()) {
                        CapsuleTemplateRenderer.renderFluid(poseStack, targetPos, (BlockAndTintGetter)this.templateWorld, bufferSolid, ifluidstate);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.trace("Caught exception whilst rendering {}.", (Object)state, (Object)e);
            }
            poseStack.m_85849_();
        }
    }

    private static void renderFluid(PoseStack matrixStack, BlockPos destOriginPos, BlockAndTintGetter world, VertexConsumer buffer, FluidState ifluidstate) {
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((FluidState)ifluidstate);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidTypeExtensions.getStillTexture());
        float minU = sprite.m_118409_();
        float maxU = Math.min(minU + (sprite.m_118410_() - minU) * 1.0f, sprite.m_118410_());
        float minV = sprite.m_118411_();
        float maxV = Math.min(minV + (sprite.m_118412_() - minV) * 1.0f, sprite.m_118412_());
        int waterColor = fluidTypeExtensions.getTintColor(ifluidstate, world, destOriginPos);
        float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(waterColor & 0xFF) / 255.0f;
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        CapsuleTemplateRenderer.vertex(buffer, maxU, minV, red, green, blue, matrix, 0, 1, 0);
        CapsuleTemplateRenderer.vertex(buffer, minU, minV, red, green, blue, matrix, 0, 1, 1);
        CapsuleTemplateRenderer.vertex(buffer, minU, maxV, red, green, blue, matrix, 1, 1, 1);
        CapsuleTemplateRenderer.vertex(buffer, maxU, maxV, red, green, blue, matrix, 1, 1, 0);
    }

    private static void vertex(VertexConsumer buffer, float maxU, float minV, float red, float green, float blue, Matrix4f matrix, int x, int y, int z) {
        buffer.m_252986_(matrix, (float)x, (float)y, (float)z).m_85950_(red, green, blue, 1.0f).m_7421_(maxU, minV).m_85969_(256).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void renderModelBrightnessColorQuads(PoseStack.Pose matrixEntry, VertexConsumer builder, float red, float green, float blue, float alpha, List<BakedQuad> listQuads, int combinedLightsIn, int combinedOverlayIn) {
        for (BakedQuad bakedquad : listQuads) {
            float f2;
            float f1;
            float f;
            if (bakedquad.m_111304_()) {
                f = red;
                f1 = green;
                f2 = blue;
            } else {
                f = 1.0f;
                f1 = 1.0f;
                f2 = 1.0f;
            }
            builder.putBulkData(matrixEntry, bakedquad, f, f1, f2, alpha, combinedLightsIn, combinedOverlayIn, false);
        }
    }

    public boolean changeTemplateIfDirty(CapsuleTemplate template, Level world, BlockPos destPos, BlockPos offPos, StructurePlaceSettings placementSettings, int placeFlag) {
        if (this.lastPlacementSettings == null || placementSettings != null && (placementSettings.m_74404_() != this.lastPlacementSettings.m_74404_() || placementSettings.m_74401_() != this.lastPlacementSettings.m_74401_())) {
            this.isWorldDirty = true;
        }
        if (!this.isWorldDirty) {
            return true;
        }
        if (this.renderBuffer != null) {
            this.renderBuffer.close();
        }
        this.renderBuffer = null;
        this.lastPlacementSettings = placementSettings;
        if (template.palettes.isEmpty()) {
            return false;
        }
        this.templateWorld = new FakeWorld((LevelAccessor)world);
        List<StructureTemplate.StructureBlockInfo> list = CapsuleTemplate.Palette.getRandomPalette(placementSettings, template.palettes, destPos).blocks();
        if (!list.isEmpty() && template.size.m_123341_() >= 1 && template.size.m_123342_() >= 1 && template.size.m_123343_() >= 1) {
            BoundingBox mutableboundingbox = placementSettings.m_74409_();
            ArrayList list1 = Lists.newArrayListWithCapacity((int)(placementSettings.m_74413_() ? list.size() : 0));
            ArrayList list2 = Lists.newArrayListWithCapacity((int)list.size());
            int i = Integer.MAX_VALUE;
            int j = Integer.MAX_VALUE;
            int k = Integer.MAX_VALUE;
            int l = Integer.MIN_VALUE;
            int i1 = Integer.MIN_VALUE;
            int j1 = Integer.MIN_VALUE;
            for (StructureTemplate.StructureBlockInfo template$blockinfo : CapsuleTemplate.processBlockInfos(template, this.templateWorld, offPos, placementSettings, list)) {
                BlockPos blockpos = template$blockinfo.f_74675_();
                if (mutableboundingbox != null && !mutableboundingbox.m_71051_((Vec3i)blockpos)) continue;
                FluidState fluidstate = placementSettings.m_74413_() ? this.templateWorld.m_6425_(blockpos) : null;
                BlockState blockstate = template$blockinfo.f_74676_().m_60715_(placementSettings.m_74401_()).rotate((LevelAccessor)this.templateWorld, blockpos, placementSettings.m_74404_());
                if (template$blockinfo.f_74677_() != null) {
                    BlockEntity BlockEntity2 = this.templateWorld.m_7702_(blockpos);
                    Clearable.m_18908_((Object)BlockEntity2);
                    this.templateWorld.m_7731_(blockpos, Blocks.f_50375_.m_49966_(), 20);
                }
                if (!this.templateWorld.m_7731_(blockpos, blockstate, placeFlag)) continue;
                i = Math.min(i, blockpos.m_123341_());
                j = Math.min(j, blockpos.m_123342_());
                k = Math.min(k, blockpos.m_123343_());
                l = Math.max(l, blockpos.m_123341_());
                i1 = Math.max(i1, blockpos.m_123342_());
                j1 = Math.max(j1, blockpos.m_123343_());
                list2.add(Pair.of((Object)blockpos, (Object)template$blockinfo.f_74677_()));
                if (fluidstate == null || !(blockstate.m_60734_() instanceof LiquidBlockContainer)) continue;
                ((LiquidBlockContainer)blockstate.m_60734_()).m_7361_((LevelAccessor)this.templateWorld, blockpos, blockstate, fluidstate);
                if (fluidstate.m_76170_()) continue;
                list1.add(blockpos);
            }
            boolean flag = true;
            Direction[] adirection = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
            while (flag && !list1.isEmpty()) {
                flag = false;
                Iterator iterator = list1.iterator();
                while (iterator.hasNext()) {
                    BlockState blockstate2;
                    Block block;
                    BlockPos blockpos2;
                    BlockPos blockpos3 = blockpos2 = (BlockPos)iterator.next();
                    FluidState fluidstate2 = this.templateWorld.m_6425_(blockpos2);
                    for (int k1 = 0; k1 < adirection.length && !fluidstate2.m_76170_(); ++k1) {
                        BlockPos blockpos1 = blockpos3.m_121945_(adirection[k1]);
                        FluidState fluidstate1 = this.templateWorld.m_6425_(blockpos1);
                        if (!(fluidstate1.m_76155_((BlockGetter)this.templateWorld, blockpos1) > fluidstate2.m_76155_((BlockGetter)this.templateWorld, blockpos3)) && (!fluidstate1.m_76170_() || fluidstate2.m_76170_())) continue;
                        fluidstate2 = fluidstate1;
                        blockpos3 = blockpos1;
                    }
                    if (!fluidstate2.m_76170_() || !((block = (blockstate2 = this.templateWorld.m_8055_(blockpos2)).m_60734_()) instanceof LiquidBlockContainer)) continue;
                    ((LiquidBlockContainer)block).m_7361_((LevelAccessor)this.templateWorld, blockpos2, blockstate2, fluidstate2);
                    flag = true;
                    iterator.remove();
                }
            }
            if (i <= l) {
                if (!placementSettings.m_74410_()) {
                    BitSetDiscreteVoxelShape voxelshapepart = new BitSetDiscreteVoxelShape(l - i + 1, i1 - j + 1, j1 - k + 1);
                    int l1 = i;
                    int i2 = j;
                    int j2 = k;
                    for (Pair pair1 : list2) {
                        BlockPos blockpos5 = (BlockPos)pair1.getFirst();
                        voxelshapepart.m_142703_(blockpos5.m_123341_() - l1, blockpos5.m_123342_() - i2, blockpos5.m_123343_() - j2);
                    }
                    StructureTemplate.m_74510_((LevelAccessor)this.templateWorld, (int)placeFlag, (DiscreteVoxelShape)voxelshapepart, (int)l1, (int)i2, (int)j2);
                }
                for (Pair pair : list2) {
                    BlockState blockstate3;
                    BlockPos blockpos4 = (BlockPos)pair.getFirst();
                    if (placementSettings.m_74410_()) continue;
                    BlockState blockstate1 = this.templateWorld.m_8055_(blockpos4);
                    if (blockstate1 != (blockstate3 = Block.m_49931_((BlockState)blockstate1, (LevelAccessor)this.templateWorld, (BlockPos)blockpos4))) {
                        this.templateWorld.m_7731_(blockpos4, blockstate3, placeFlag & 0xFFFFFFFE | 0x10);
                    }
                    this.templateWorld.m_6289_(blockpos4, blockstate3.m_60734_());
                }
            }
            this.isWorldDirty = false;
            return true;
        }
        this.isWorldDirty = false;
        return false;
    }

    public void setWorldDirty() {
        this.isWorldDirty = true;
    }
}

