/*
 * Decompiled with CFR 0.152.
 */
package capsule;

import capsule.Config;
import capsule.blocks.CapsuleBlocks;
import capsule.command.CapsuleCommand;
import capsule.enchantments.CapsuleEnchantments;
import capsule.gui.LabelGui;
import capsule.itemGroups.CapsuleCreativeTabs;
import capsule.items.CapsuleItems;
import capsule.recipes.CapsuleRecipes;
import capsule.recipes.PrefabsBlueprintAggregatorRecipe;
import com.mojang.brigadier.CommandDispatcher;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="capsule")
public class CapsuleMod {
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleMod.class);
    public static final String MODID = "capsule";
    public static Consumer<Player> openGuiScreenCommon = (Consumer)DistExecutor.unsafeRunForDist(() -> () -> CapsuleMod::openGuiScreenClient, () -> () -> CapsuleMod::openGuiScreenServer);
    public static MinecraftServer server = null;

    public CapsuleMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_CONFIG);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        CapsuleBlocks.registerBlocks(modEventBus);
        CapsuleItems.registerItems(modEventBus);
        CapsuleCreativeTabs.registerTabs(modEventBus);
        CapsuleRecipes.registerRecipeSerializers(modEventBus);
        CapsuleEnchantments.registerEnchantments(modEventBus);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, CapsuleMod::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, CapsuleMod::serverStopped);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, CapsuleMod::RegisterCommands);
    }

    public static void serverStarting(ServerStartingEvent e) {
        server = e.getServer();
        Config.populateConfigFolders(server);
        if (PrefabsBlueprintAggregatorRecipe.instance != null) {
            PrefabsBlueprintAggregatorRecipe.instance.populateRecipes(server.m_177941_());
        }
    }

    public static void RegisterCommands(RegisterCommandsEvent e) {
        CapsuleCommand.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }

    public static void serverStopped(ServerStoppedEvent e) {
        server = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openGuiScreenClient(Player player) {
        if (player.m_9236_().f_46443_) {
            LabelGui screen = new LabelGui(player);
            Minecraft.m_91087_().m_91152_((Screen)screen);
        }
    }

    public static void openGuiScreenServer(Player player) {
    }
}

